/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkFactory
extends ByteBufferFactory {
    public int maxChunkSize;
    public int maxPlaintextSize;
    public int messageHeaderSize;
    public int securityHeader;
    public int sequenceHeader;
    public int cipherBlockSize;
    public int signatureSize;
    public MessageSecurityMode securityMode = MessageSecurityMode.Invalid;
    private boolean useExtraPaddingByte;
    static Logger logger = LoggerFactory.getLogger(ChunkFactory.class);

    public ChunkFactory(int n, int n2, int n3, int n4, int n5, int n6, MessageSecurityMode messageSecurityMode, int n7) {
        logger.trace("ChunkFactory: class={}", this.getClass());
        this.maxChunkSize = n;
        this.messageHeaderSize = n2;
        this.securityHeader = n3;
        this.sequenceHeader = n4;
        this.cipherBlockSize = n6;
        this.signatureSize = n5;
        this.securityMode = messageSecurityMode;
        boolean bl = this.useExtraPaddingByte = n7 > 2048;
        if (messageSecurityMode == MessageSecurityMode.None || messageSecurityMode == MessageSecurityMode.Invalid) {
            this.maxPlaintextSize = n - n2 - n3 - this.sequenceHeader;
            assert (n5 == 0);
            assert (n6 == 1);
        } else if (messageSecurityMode == MessageSecurityMode.Sign) {
            this.maxPlaintextSize = n - n2 - n3 - this.sequenceHeader - n5;
        }
        if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
            int n8 = this.getMinimumPadding();
            int n9 = n - n2 - n3 - n8;
            n9 -= n9 % n6;
            this.maxPlaintextSize = n9 - n4 - n5 - n8;
        }
    }

    protected int getMinimumPadding() {
        return this.useExtraPaddingByte ? 2 : 1;
    }

    @Override
    public ByteBuffer allocate(int n) {
        int n2;
        n = Math.min(n, this.maxPlaintextSize);
        int n3 = 0;
        if (this.securityMode == MessageSecurityMode.SignAndEncrypt) {
            n2 = n + this.sequenceHeader + this.signatureSize;
            n3 = this.getMinimumPadding();
            int n4 = (n3 + n2) % this.cipherBlockSize;
            if (n4 != 0) {
                n3 += this.cipherBlockSize - n4;
            }
            logger.trace("allocate: padding={}", (Object)n3);
        }
        n2 = n + this.messageHeaderSize + this.securityHeader + this.sequenceHeader + this.signatureSize + n3;
        logger.trace("allocate: chunkSize={}", (Object)n2);
        assert (n2 <= this.maxChunkSize);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(4);
        byteBuffer.putInt(n2);
        if (this.securityMode == MessageSecurityMode.SignAndEncrypt) {
            this.writePadding(this.messageHeaderSize + this.securityHeader + this.sequenceHeader + n, n3, byteBuffer);
        }
        byteBuffer.position(this.messageHeaderSize + this.securityHeader + this.sequenceHeader);
        byteBuffer = byteBuffer.slice();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.limit(n);
        return byteBuffer;
    }

    protected void writePadding(int n, int n2, ByteBuffer byteBuffer) {
        int n3;
        byte by;
        int n4 = this.getMinimumPadding();
        logger.trace("writePadding: result.position={}", (Object)byteBuffer.position());
        logger.trace("writePadding: minimumPadding={}", (Object)n4);
        logger.trace("writePadding: padding={}", (Object)n2);
        if (n4 == 1) {
            byteBuffer.position(n);
            by = (byte)(n2 - 1 & 0xFF);
            for (n3 = 0; n3 < n2; ++n3) {
                byteBuffer.put(by);
            }
        }
        if (n4 == 2) {
            byteBuffer.position(n);
            by = (byte)(n2 - 2 & 0xFF);
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                byteBuffer.put(by);
            }
            byteBuffer.put((byte)(n2 - 2 >> 8));
        }
        logger.trace("writePadding: result={}", (Object)CryptoUtil.toHex(byteBuffer.array(), 64));
    }

    protected void writePaddingSize(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = this.getMinimumPadding();
        byteBuffer.position(n);
        if (n3 == 1) {
            byteBuffer.put((byte)(n2 - 1 & 0xFF));
        }
        if (n3 == 2) {
            byteBuffer.put((byte)(n2 - 2 & 0xFF));
            byteBuffer.put((byte)(n2 - 2 >> 8));
        }
        logger.trace("writePadding: result={}", (Object)CryptoUtil.toHex(byteBuffer.array(), 64));
    }

    public void signChunk(ByteBuffer byteBuffer) {
    }

    public void encryptChunk(ByteBuffer byteBuffer) {
    }

    public ByteBuffer expandToCompleteChunk(ByteBuffer byteBuffer) {
        return ByteBuffer.wrap(byteBuffer.array()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer[] expandToCompleteChunk(ByteBuffer[] byteBufferArray) {
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[byteBufferArray.length];
        for (int i = 0; i < byteBufferArray2.length; ++i) {
            byteBufferArray2[i] = this.expandToCompleteChunk(byteBufferArray[i]);
        }
        return byteBufferArray2;
    }

    public static class AsymmMsgChunkFactory
    extends ChunkFactory {
        SecurityConfiguration profile;

        public AsymmMsgChunkFactory(int n, SecurityConfiguration securityConfiguration) throws ServiceResultException {
            super(n, 12, 12 + securityConfiguration.getSecurityPolicy().getEncodedPolicyUri().length + (securityConfiguration.getEncodedLocalCertificate() != null ? securityConfiguration.getEncodedLocalCertificate().length : 0) + (securityConfiguration.getEncodedRemoteCertificateThumbprint() != null ? securityConfiguration.getEncodedRemoteCertificateThumbprint().length : 0), 8, securityConfiguration.getMessageSecurityMode().hasSigning() ? CryptoUtil.getSignatureSize(securityConfiguration.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), securityConfiguration.getLocalPrivateKey()) : 0, securityConfiguration.getMessageSecurityMode() != MessageSecurityMode.None ? CryptoUtil.getCipherBlockSize(securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), securityConfiguration.getRemoteCertificate().getPublicKey()) : 1, securityConfiguration.getMessageSecurityMode(), securityConfiguration.getLocalCertificate() == null ? 0 : ((RSAPublicKey)securityConfiguration.getRemoteCertificate().getPublicKey()).getModulus().bitLength());
            this.profile = securityConfiguration;
        }

        @Override
        public ByteBuffer allocate(int n) {
            MessageSecurityMode messageSecurityMode = this.securityMode;
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            n = Math.min(n, this.maxPlaintextSize);
            int n2 = -1;
            int n3 = -1;
            int n4 = n + this.sequenceHeader;
            int n5 = 0;
            int n6 = this.getMinimumPadding();
            int n7 = 0;
            int n8 = -1;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n9 = 1;
                try {
                    PublicKey publicKey = this.profile.getReceiverCertificate().getPublicKey();
                    n9 = CryptoUtil.getPlainTextBlockSize(this.profile.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), publicKey);
                }
                catch (ServiceResultException serviceResultException) {
                    throw new RuntimeServiceResultException(serviceResultException);
                }
                n4 += this.signatureSize;
                if ((n4 += n6) % n9 != 0) {
                    n7 = n9 - n4 % n9;
                    n4 += n7;
                }
                n5 = n6 + n7;
                n2 = n4 / n9;
                n3 = n2 * this.cipherBlockSize;
                n8 = this.messageHeaderSize + this.securityHeader + n3;
            } else if (messageSecurityMode == MessageSecurityMode.Sign) {
                n8 = this.messageHeaderSize + this.securityHeader + n4 + this.signatureSize;
            } else if (messageSecurityMode == MessageSecurityMode.None) {
                n8 = this.messageHeaderSize + this.securityHeader + n4;
            }
            logger.trace("AsymmMSGChunkFactory.allocate: chunkSize={}", (Object)n8);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.writePadding(this.messageHeaderSize + this.securityHeader + this.sequenceHeader + n, n5, byteBuffer);
                this.writePaddingSize(n8 - n6, n5, byteBuffer);
            }
            byteBuffer.position(4);
            byteBuffer.putInt(n8);
            byteBuffer.position(this.messageHeaderSize + this.securityHeader + this.sequenceHeader);
            byteBuffer = byteBuffer.slice();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.limit(n);
            return byteBuffer;
        }
    }

    public static class ErrorMessageChunkFactory
    extends ChunkFactory {
        public ErrorMessageChunkFactory() {
            super(4100, 8, 0, 0, 0, 1, MessageSecurityMode.Invalid, 0);
            this.maxChunkSize = 4108;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = 4092;
        }
    }

    public static class AcknowledgeChunkFactory
    extends ChunkFactory {
        public AcknowledgeChunkFactory() {
            super(8192, 8, 0, 0, 0, 1, MessageSecurityMode.Invalid, 0);
            this.maxChunkSize = 8192;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = this.maxChunkSize - 8;
        }
    }

    public static class HelloChunkFactory
    extends ChunkFactory {
        public HelloChunkFactory() {
            super(8192, 8, 0, 0, 0, 0, MessageSecurityMode.Invalid, 0);
            this.maxChunkSize = 8192;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = this.maxChunkSize - 8;
        }
    }
}

