/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.ChunkUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmDecryptVerifier.class);
    ByteBuffer chunk;
    SecurityConfiguration securityProfile;
    String securityPolicyUri;
    byte[] senderCertificate;
    byte[] receiverCertificateThumbPrint;

    public ChunkAsymmDecryptVerifier(ByteBuffer byteBuffer, SecurityConfiguration securityConfiguration) {
        this.chunk = byteBuffer;
        this.securityProfile = securityConfiguration;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            SecurityPolicy securityPolicy = this.securityProfile.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = this.securityProfile.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            this.chunk.position(12);
            this.securityPolicyUri = ChunkUtils.getString(this.chunk);
            logger.debug("SecurityPolicy in use: {}", (Object)this.securityPolicyUri);
            logger.debug("SecurityMode in use: {}", (Object)this.securityProfile.getMessageSecurityMode());
            if (logger.isTraceEnabled()) {
                logger.trace("Chunk: {}", (Object)CryptoUtil.toHex(this.chunk.array(), 64));
            }
            this.senderCertificate = ChunkUtils.getByteString(this.chunk);
            this.receiverCertificateThumbPrint = ChunkUtils.getByteString(this.chunk);
            int n = this.chunk.position();
            int n2 = this.chunk.position() + 8;
            int n3 = this.chunk.limit();
            int n4 = n3 - n;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n4];
                this.chunk.position(n);
                this.chunk.get(byArray, 0, byArray.length);
                n4 = this.decrypt(byArray, this.securityProfile.getLocalPrivateKey(), this.chunk.array(), n + this.chunk.arrayOffset());
                if (logger.isTraceEnabled()) {
                    logger.trace("Chunk decrypted: {}", (Object)CryptoUtil.toHex(this.chunk.array(), 64));
                }
            }
            int n5 = 0;
            if (messageSecurityMode.hasSigning()) {
                SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
                logger.debug("signatureAlgorithm={}", (Object)securityAlgorithm);
                PublicKey publicKey = this.securityProfile.getRemoteCertificate().getPublicKey();
                n5 = CryptoUtil.getSignatureSize(securityAlgorithm, publicKey);
                logger.debug("signatureSize={}", (Object)n5);
                byte[] byArray = new byte[n + n4 - n5];
                this.chunk.position(0);
                this.chunk.get(byArray, 0, byArray.length);
                this.chunk.position(n + n4 - n5);
                byte[] byArray2 = new byte[n5];
                this.chunk.get(byArray2, 0, n5);
                Certificate certificate = this.securityProfile.getRemoteCertificate();
                if (!this.verify(byArray, certificate, byArray2)) {
                    logger.error("Signature verification fails.");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature could not be VERIFIED");
                }
            }
            int n6 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n7;
                byte by;
                boolean bl;
                int n8 = this.securityProfile.getLocalCertificate2().getCertificate().getKeySize();
                int n9 = n + n4 - n5 - 1;
                boolean bl2 = bl = n8 > 2048;
                if (bl) {
                    by = this.chunk.get(n9 - 1);
                    n7 = this.chunk.get(n9);
                    n6 = (by & 0xFF | (n7 & 0xFF) << 8) + 2;
                } else {
                    by = this.chunk.get(n9);
                    n6 = (by & 0xFF) + 1;
                }
                logger.debug("paddingEnd={} paddingSize={}", (Object)n9, (Object)n6);
                n7 = bl ? n6 - 1 : n6;
                int n10 = bl ? n9 - n7 : n9 - n7 + 1;
                for (int i = 0; i < n7; ++i) {
                    byte by2 = this.chunk.get(n10 + i);
                    if (by2 == by) continue;
                    logger.error(String.format("Padding does not match: %x <> %x", by2, (int)by));
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
            }
            this.chunk.position(n2);
            this.chunk.limit(this.chunk.position() + n4 - 8 - n6 - n5);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public byte[] getSenderCertificate() {
        return this.senderCertificate;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.receiverCertificateThumbPrint;
    }

    private boolean verify(byte[] byArray, Certificate certificate, byte[] byArray2) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.securityProfile.getSecurityPolicy();
        logger.debug("verify: policy={}", (Object)securityPolicy);
        if (logger.isTraceEnabled()) {
            logger.trace("verify: {}", (Object)certificate);
            logger.trace("verify: dataToVerify={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("verify: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return CryptoUtil.getCryptoProvider().verifyAsymm(certificate.getPublicKey(), this.securityProfile.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray, byArray2);
    }

    private int decrypt(byte[] byArray, PrivateKey privateKey, byte[] byArray2, int n) throws ServiceResultException {
        int n2 = CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, this.securityProfile.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n);
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: dataToDecrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("decrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
            logger.trace("decrypt: bytesDecrypted={}", (Object)n2);
        }
        return n2;
    }
}

