/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.CryptoProvider;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JceCryptoProvider
implements CryptoProvider {
    static Logger logger = LoggerFactory.getLogger(JceCryptoProvider.class);
    protected Provider provider;

    public JceCryptoProvider() {
        String string = CryptoUtil.getSecurityProviderName();
        this.provider = Security.getProvider(string);
    }

    @Override
    public abstract byte[] base64Decode(String var1);

    @Override
    public abstract String base64Encode(byte[] var1);

    @Override
    public Mac createMac(SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, securityAlgorithm.getStandardName());
        try {
            mac = Mac.getInstance(securityAlgorithm.getStandardName(), this.provider);
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        return mac;
    }

    @Override
    public int decryptAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n) throws ServiceResultException {
        Cipher cipher;
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
        int n2 = rSAPrivateKey.getModulus().bitLength() / 8;
        try {
            cipher = this.getAsymmetricCipher(securityAlgorithm, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.info("decrypt: The provided RSA key is invalid", (Throwable)invalidKeyException);
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        if (byArray.length % n2 != 0) {
            logger.error("decrypt: Wrong blockSize!!!");
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in asymmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        try {
            logger.info("JceCipherDecrypt={}", (Object)((Object)cipher).toString());
            int n3 = n + byArray.length;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            for (int i = n; i < n3; i += n2) {
                n5 = cipher.doFinal(byArray, n6, n2, byArray2, n);
                n6 += n2;
                n += n5;
                n4 += n5;
            }
            return n4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.error("decrypt: error", (Throwable)generalSecurityException);
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public int decryptSymm(SecurityToken securityToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ServiceResultException {
        SecurityAlgorithm securityAlgorithm = securityToken.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: token.getRemoteEncryptingKey()=" + CryptoUtil.toHex(securityToken.getRemoteEncryptingKey()));
            logger.trace("decrypt: token.getRemoteInitializationVector()=" + CryptoUtil.toHex(securityToken.getRemoteInitializationVector()));
            logger.trace("decrypt: dataToDecrypt=" + CryptoUtil.toHex(byArray));
            logger.trace("decrypt: algorithm=" + (Object)((Object)securityAlgorithm));
        }
        int n4 = 0;
        SecretKeySpec secretKeySpec = new SecretKeySpec(securityToken.getRemoteEncryptingKey(), securityAlgorithm.getStandardName());
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getTransformation());
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(securityToken.getRemoteInitializationVector()));
            n4 = cipher.update(byArray, n, n2, byArray2, n3);
            n4 += cipher.doFinal(byArray2, n3 + n4);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)illegalStateException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: output=" + CryptoUtil.toHex(byArray2));
        }
        return n4;
    }

    @Override
    public void encryptAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n) throws ServiceResultException {
        Cipher cipher = null;
        int n2 = 1;
        n2 = CryptoUtil.getPlainTextBlockSize(securityAlgorithm, publicKey);
        try {
            cipher = this.getAsymmetricCipher(securityAlgorithm, publicKey);
            int n3 = n + byArray.length;
            int n4 = 0;
            for (int i = n; i < n3; i += n2) {
                int n5 = cipher.doFinal(byArray, n4, Math.min(n3 - i, n2), byArray2, n);
                logger.debug("Asym encryption: amountOfEncryptedBytes={} inputOffset={} outputOffset={} index={}", new Object[]{n5, n4 += n2, n += n5, i});
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public int encryptSymm(SecurityToken securityToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ServiceResultException {
        SecurityAlgorithm securityAlgorithm = securityToken.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
        SecretKeySpec secretKeySpec = new SecretKeySpec(securityToken.getLocalEncryptingKey(), securityAlgorithm.getStandardName());
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getTransformation());
            int n4 = cipher.getBlockSize();
            if (byArray.length % n4 != 0) {
                logger.error("Input data is not an even number of encryption blocks.");
                throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in symmetric decrypt: Input data is not an even number of encryption blocks.");
            }
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(securityToken.getLocalInitializationVector()));
            int n5 = cipher.update(byArray, n, n2, byArray2, n3);
            n5 += cipher.doFinal(byArray2, n3 + n5);
            return n5;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public byte[] signAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return null;
        }
        if (byArray == null || privateKey == null) {
            throw new IllegalArgumentException("null arg");
        }
        try {
            Signature signature = this.getSignature(securityAlgorithm);
            logger.debug("signer.getProvider(): {}", (Object)signature.getProvider());
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public void signSymm(SecurityToken securityToken, byte[] byArray, int n, byte[] byArray2) throws ServiceResultException {
        Mac mac = securityToken.createLocalHmac();
        mac.update(byArray, 0, n);
        try {
            mac.doFinal(byArray2, 0);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeServiceResultException(new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException));
        }
    }

    @Override
    public boolean verifyAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return true;
        }
        if (publicKey == null || byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null arg");
        }
        try {
            Signature signature = this.getSignature(securityAlgorithm);
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                logger.debug("Asym Signature Verify : OK");
                return true;
            }
            logger.error("Asymmetric Signature Verification fails");
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public void verifySymm(SecurityToken securityToken, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        Mac mac = securityToken.createRemoteHmac();
        byte[] byArray3 = mac.doFinal(byArray);
        if (byArray2.length != byArray3.length) {
            logger.warn("Signature lengths do not match: \n{} vs. \n{}", (Object)CryptoUtil.toHex(byArray2), (Object)CryptoUtil.toHex(byArray3));
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray3[i]) continue;
            logger.warn("Signatures do not match: \n{} vs. \n{}", (Object)CryptoUtil.toHex(byArray2), (Object)CryptoUtil.toHex(byArray3));
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature");
        }
    }

    private Cipher getAsymmetricCipher(SecurityAlgorithm securityAlgorithm, PrivateKey privateKey) throws NoSuchProviderException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(securityAlgorithm.getTransformation(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            cipher = Cipher.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        cipher.init(2, privateKey);
        logger.debug("decrypt: cipher.provider={}", (Object)cipher.getProvider());
        return cipher;
    }

    private Cipher getAsymmetricCipher(SecurityAlgorithm securityAlgorithm, PublicKey publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(securityAlgorithm.getTransformation(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            cipher = Cipher.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        cipher.init(1, publicKey);
        logger.trace("encrypt: cipher.provider={}", (Object)cipher.getProvider());
        return cipher;
    }

    private Signature getSignature(SecurityAlgorithm securityAlgorithm) throws NoSuchAlgorithmException {
        try {
            return Signature.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Signature.getInstance(securityAlgorithm.getStandardName());
        }
    }
}

