/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HttpsSecurityPolicy {
    public static final String URI_TLS_1_0 = "http://opcfoundation.org/UA/SecurityPolicy#TLS-1-0";
    public static final String URI_TLS_1_1 = "http://opcfoundation.org/UA/SecurityPolicy#TLS-1-1";
    public static final String URI_TLS_1_2 = "http://opcfoundation.org/UA/SecurityPolicy#TLS-1-2";
    public static final String SSL_NULL_WITH_NULL_NULL = "SSL_NULL_WITH_NULL_NULL";
    public static final String TLS_RSA_WITH_NULL_MD5 = "TLS_RSA_WITH_NULL_MD5";
    public static final String TLS_RSA_WITH_NULL_SHA = "TLS_RSA_WITH_NULL_SHA";
    public static final String SSL_RSA_WITH_RC4_128_SHA = "SSL_RSA_WITH_RC4_128_SHA";
    public static final String TLS_RSA_WITH_RC4_128_MD5 = "TLS_RSA_WITH_RC4_128_MD5";
    public static final String TLS_RSA_WITH_IDEA_CBC_SHA = "TLS_RSA_WITH_IDEA_CBC_SHA";
    public static final String TLS_RSA_WITH_DES_CBC_SHA = "TLS_RSA_WITH_DES_CBC_SHA";
    public static final String SSL_RSA_WITH_3DES_EDE_CBC_SHA = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256";
    public static final String TLS_RSA_WITH_AES_256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256";
    public static final String TLS_DH_DSS_WITH_DES_CBC_SHA = "TLS_DH_DSS_WITH_DES_CBC_SHA";
    public static final String TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_DH_RSA_WITH_DES_CBC_SHA = "TLS_DH_RSA_WITH_DES_CBC_SHA";
    public static final String TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_DHE_DSS_WITH_DES_CBC_SHA = "TLS_DHE_DSS_WITH_DES_CBC_SHA";
    public static final String TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_DHE_RSA_WITH_DES_CBC_SHA = "TLS_DHE_RSA_WITH_DES_CBC_SHA";
    public static final String TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_DH_anon_WITH_RC4_128_MD5 = "TLS_DH_anon_WITH_RC4_128_MD5";
    public static final String TLS_DH_anon_WITH_DES_CBC_SHA = "TLS_DH_anon_WITH_DES_CBC_SHA";
    public static final String TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA";
    public static final HttpsSecurityPolicy TLS_1_0 = new HttpsSecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#TLS-1-0", 1024, 4096, new String[]{"..._RSA_WITH_RC4_128_SHA"});
    public static final HttpsSecurityPolicy TLS_1_1 = new HttpsSecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#TLS-1-1", 1024, 4096, new String[]{"..._RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_RC4_128_MD5", "TLS_RSA_WITH_IDEA_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DH_DSS_WITH_DES_CBC_SHA", "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DH_RSA_WITH_DES_CBC_SHA", "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_DES_CBC_SHA", "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_WITH_DES_CBC_SHA", "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA"});
    public static final HttpsSecurityPolicy TLS_1_2 = new HttpsSecurityPolicy("http://opcfoundation.org/UA/SecurityPolicy#TLS-1-2", 2048, 4096, new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA256"});
    public static final HttpsSecurityPolicy[] ALL = new HttpsSecurityPolicy[]{TLS_1_0, TLS_1_1};
    private static Map<String, HttpsSecurityPolicy> availablePolicies = new ConcurrentHashMap<String, HttpsSecurityPolicy>();
    private final String[] cipherSuites;
    private final int maxAsymmetricKeyLength;
    private final int minAsymmetricKeyLength;
    private final String policyUri;

    public static void addAvailablePolicy(HttpsSecurityPolicy httpsSecurityPolicy) {
        availablePolicies.put(httpsSecurityPolicy.policyUri, httpsSecurityPolicy);
    }

    HttpsSecurityPolicy(String string, int n, int n2, String[] stringArray) {
        this.policyUri = string;
        this.minAsymmetricKeyLength = n;
        this.maxAsymmetricKeyLength = n2;
        this.cipherSuites = stringArray;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.maxAsymmetricKeyLength;
    }

    public int getMinAsymmetricKeyLength() {
        return this.minAsymmetricKeyLength;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public String toString() {
        return this.policyUri;
    }

    public static Map<String, HttpsSecurityPolicy> getAvailablePolicies() {
        return availablePolicies;
    }

    static {
        HttpsSecurityPolicy.addAvailablePolicy(TLS_1_0);
        HttpsSecurityPolicy.addAvailablePolicy(TLS_1_1);
        HttpsSecurityPolicy.addAvailablePolicy(TLS_1_2);
    }
}

