/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;

public class CertificateValidatorImpl
implements CertificateValidator {
    Set<Cert> trustedCertificates = new HashSet<Cert>();
    Set<PublicKey> trustedPublicKeys = new HashSet<PublicKey>();

    public CertificateValidatorImpl() {
    }

    public CertificateValidatorImpl(Cert ... certArray) {
        for (Cert cert : certArray) {
            this.addTrustedCertificate(cert);
        }
    }

    public void addTrustedCertificate(Cert cert) {
        this.trustedCertificates.add(cert);
    }

    public void addTrustedSigner(Cert cert) {
        this.addTrustedSignerPublicKey(cert.getCertificate().getPublicKey());
    }

    public void addTrustedSignerPublicKey(PublicKey publicKey) {
        this.trustedPublicKeys.add(publicKey);
    }

    @Override
    public StatusCode validateCertificate(Cert cert) {
        for (Cert object : this.trustedCertificates) {
            if (!object.equals(cert)) continue;
            return null;
        }
        for (PublicKey publicKey : this.trustedPublicKeys) {
            try {
                cert.getCertificate().verify(publicKey);
                return null;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        return new StatusCode(StatusCodes.Bad_SecurityChecksFailed);
    }
}

