/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;

public class CertValidatorTrustManager
implements X509TrustManager {
    CertificateValidator validator;
    Map<X509Certificate, Cert> certMap = new HashMap<X509Certificate, Cert>();
    List<Cert> acceptedCertificates = new ArrayList<Cert>();
    List<Cert> acceptedIssuers = new ArrayList<Cert>();
    X509Certificate[] acceptedIssuersArray;

    public CertValidatorTrustManager(CertificateValidator certificateValidator) {
        this.validator = certificateValidator;
    }

    synchronized void validate(X509Certificate x509Certificate) throws CertificateException {
        StatusCode statusCode;
        boolean bl;
        Cert cert = this.certMap.get(x509Certificate);
        if (cert == null) {
            cert = new Cert(x509Certificate);
            this.certMap.put(x509Certificate, cert);
        }
        boolean bl2 = bl = (statusCode = this.validator.validateCertificate(cert)) == null || statusCode.isGood();
        if (!bl) {
            throw new CertificateException("Certificate is not valid");
        }
        this.acceptedCertificates.add(cert);
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        if (!x500Principal2.equals(x500Principal) && bl) {
            this.acceptedIssuers.add(cert);
            this.acceptedIssuersArray = null;
        }
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            this.validate(x509Certificate);
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            this.validate(x509Certificate);
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        if (this.acceptedIssuersArray == null) {
            int n = this.acceptedIssuers.size();
            this.acceptedIssuersArray = new X509Certificate[n];
            for (int i = 0; i < n; ++i) {
                Cert cert = this.acceptedIssuers.get(i);
                this.acceptedIssuersArray[i] = cert.getCertificate();
            }
        }
        return this.acceptedIssuersArray;
    }
}

