/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertValidatorTrustManager;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.security.KeyPair;

public class HttpsSettings {
    X509KeyManager keyManager;
    TrustManager trustManager;
    X509HostnameVerifier hostnameVerifier;
    String username;
    String password;
    HttpParams httpParams;
    private HttpsSecurityPolicy[] httpsSecurityPolicies;

    public HttpsSettings() {
    }

    public HttpsSettings(KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) {
        this.setKeyPair(keyPair, new Cert[0]);
        this.setCertificateValidator(certificateValidator);
        this.hostnameVerifier = x509HostnameVerifier;
    }

    public HttpsSettings(X509KeyManager x509KeyManager, TrustManager trustManager, X509HostnameVerifier x509HostnameVerifier) {
        this.keyManager = x509KeyManager;
        this.trustManager = trustManager;
        this.hostnameVerifier = x509HostnameVerifier;
    }

    public HttpsSettings(X509KeyManager x509KeyManager, TrustManager trustManager, X509HostnameVerifier x509HostnameVerifier, String string, String string2) {
        this.keyManager = x509KeyManager;
        this.trustManager = trustManager;
        this.hostnameVerifier = x509HostnameVerifier;
        this.username = string;
        this.password = string2;
    }

    public void setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        this.hostnameVerifier = x509HostnameVerifier;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setKeyPair(KeyPair keyPair, Cert ... certArray) {
        if (keyPair != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("jks");
                Certificate[] certificateArray = new Certificate[]{keyPair.certificate.certificate};
                KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(keyPair.privateKey.getPrivateKey(), certificateArray);
                String string = "";
                keyStore.load(null);
                keyStore.setEntry("myentry-" + keyPair.hashCode(), privateKeyEntry, new KeyStore.PasswordProtection(string.toCharArray()));
                int n = certArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = "cacert-" + (i + 1);
                    keyStore.setEntry(string2, new KeyStore.TrustedCertificateEntry(certArray[i].certificate), null);
                }
                this.setKeyStore(keyStore, "");
            }
            catch (KeyStoreException keyStoreException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new RuntimeException(certificateException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
    }

    public void setKeyPairs(KeyPair[] keyPairArray, Cert ... certArray) {
        try {
            Object object;
            int n;
            KeyStore keyStore = KeyStore.getInstance("jks");
            String string = "";
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string.toCharArray());
            keyStore.load(null);
            for (n = 0; n < keyPairArray.length; ++n) {
                Certificate[] certificateArray = new Certificate[1 + certArray.length];
                certificateArray[0] = keyPairArray[n].certificate.certificate;
                for (int i = 0; i < certArray.length; ++i) {
                    certificateArray[i + 1] = certArray[i].certificate;
                }
                object = new KeyStore.PrivateKeyEntry(keyPairArray[n].privateKey.privateKey, certificateArray);
                keyStore.setEntry("my-key-pair-entry-" + (n + 1), (KeyStore.Entry)object, passwordProtection);
            }
            n = certArray.length;
            for (int i = 0; i < n; ++i) {
                object = "cacert-" + (i + 1);
                keyStore.setEntry((String)object, new KeyStore.TrustedCertificateEntry(certArray[i].certificate), null);
            }
            this.setKeyStore(keyStore, "");
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(certificateException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
    }

    public void setKeyStore(KeyStore keyStore, String string) throws ServiceResultException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, string.toCharArray());
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            this.keyManager = keyManagerArray.length == 0 ? null : (X509KeyManager)keyManagerArray[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ServiceResultException(unrecoverableKeyException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ServiceResultException(keyStoreException);
        }
    }

    public void setKeyManager(X509KeyManager x509KeyManager) throws ServiceResultException {
        this.keyManager = x509KeyManager;
    }

    public void setTrustManager(TrustManager trustManager) throws ServiceResultException {
        this.trustManager = trustManager;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.trustManager = new CertValidatorTrustManager(certificateValidator);
    }

    public void setHttpsAuth(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public TrustManager[] getTrustManagers() {
        TrustManager[] trustManagerArray;
        if (this.trustManager == null) {
            trustManagerArray = new TrustManager[]{};
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = this.trustManager;
        }
        return trustManagerArray;
    }

    public KeyManager[] getKeyManagers() {
        KeyManager[] keyManagerArray;
        if (this.keyManager == null) {
            keyManagerArray = new KeyManager[]{};
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = this.keyManager;
        }
        return keyManagerArray;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public HttpParams getHttpParams() {
        return this.httpParams;
    }

    public void setHttpParams(HttpParams httpParams) {
        this.httpParams = httpParams;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void readFrom(HttpsSettings httpsSettings) {
        if (httpsSettings.hostnameVerifier != null) {
            this.hostnameVerifier = httpsSettings.hostnameVerifier;
        }
        if (httpsSettings.trustManager != null) {
            this.trustManager = httpsSettings.trustManager;
        }
        if (httpsSettings.keyManager != null) {
            this.keyManager = httpsSettings.keyManager;
        }
        if (httpsSettings.username != null && httpsSettings.password != null) {
            this.username = httpsSettings.username;
            this.password = httpsSettings.password;
        }
        if (httpsSettings.httpParams != null) {
            this.httpParams = httpsSettings.httpParams;
        }
        if (httpsSettings.httpsSecurityPolicies != null) {
            this.httpsSecurityPolicies = httpsSettings.httpsSecurityPolicies;
        }
    }

    public HttpsSettings clone() {
        HttpsSettings httpsSettings = new HttpsSettings();
        httpsSettings.hostnameVerifier = this.hostnameVerifier;
        httpsSettings.trustManager = this.trustManager;
        httpsSettings.keyManager = this.keyManager;
        httpsSettings.username = this.username;
        httpsSettings.password = this.password;
        httpsSettings.httpParams = this.httpParams;
        httpsSettings.httpsSecurityPolicies = this.httpsSecurityPolicies;
        return httpsSettings;
    }

    public HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.httpsSecurityPolicies;
    }

    public void setHttpsSecurityPolicies(HttpsSecurityPolicy ... httpsSecurityPolicyArray) {
        this.httpsSecurityPolicies = httpsSecurityPolicyArray;
    }
}

