/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.CloseableObject;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.ConnectionMonitor;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.EndpointServer;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.endpoint.EndpointBindingCollection;
import org.opcfoundation.ua.transport.https.HttpsServerConnection;
import org.opcfoundation.ua.transport.https.HttpsServerEndpointHandler;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.impl.ConnectionCollection;
import org.opcfoundation.ua.transport.security.CertValidatorTrustManager;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.asyncsocket.AsyncServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger log = LoggerFactory.getLogger(HttpsServer.class);
    public static final HttpParams DEFAULT_HTTPPARAMS = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", (Object)"OpcUA/1.1").setParameter("http.useragent", (Object)"OpcUA/1.1");
    Application application;
    String[] enabledCipherSuites;
    String[] cipherSuitePatterns;
    String[] cipherSuites;
    AtomicInteger secureChannelCounter = new AtomicInteger();
    AsyncServerSocket socket;
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    ConnectionCollection connections = new ConnectionCollection(this);
    Thread sslReactorThread;
    Thread plainReactorThread;
    Semaphore sslThreadSemaphore;
    Semaphore plainThreadSemaphore;
    HttpAsyncService protocolHandler;
    ConnectionReuseStrategy connectionReuseStrategy;
    RequestResolver registry;
    NHttpConnectionFactory<DefaultNHttpServerConnection> plainConnFactory;
    NHttpConnectionFactory<DefaultNHttpServerConnection> sslConnFactory;
    SSLEngine sslEngine;
    SSLSetupHandler sslSetupHandler;
    IOEventDispatch plainIoEventDispatch;
    IOEventDispatch sslIoEventDispatch;
    ListeningIOReactor ioReactor;
    IOReactorConfig ioConfig;
    HttpsSecurityPolicy[] securityPolicies;
    Map<SocketAddress, SocketHandle> socketHandles = new HashMap<SocketAddress, SocketHandle>();
    Server discoveryServer;
    HttpsServerEndpointHandler discoveryHandler;

    public static TrustManager[] makeTrustManager(CertificateValidator ... certificateValidatorArray) {
        TrustManager[] trustManagerArray = new TrustManager[certificateValidatorArray.length];
        for (int i = 0; i < trustManagerArray.length; ++i) {
            trustManagerArray[i] = new CertValidatorTrustManager(certificateValidatorArray[i]);
        }
        return trustManagerArray;
    }

    public HttpsServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        this.ioConfig = new IOReactorConfig();
        this.securityPolicies = application.getHttpsSettings().getHttpsSecurityPolicies();
        this.ioConfig.setTcpNoDelay(false);
        ImmutableHttpProcessor immutableHttpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.registry = new RequestResolver();
        final Map map = Collections.synchronizedMap(new HashMap());
        this.connectionReuseStrategy = new DefaultConnectionReuseStrategy();
        this.protocolHandler = new HttpAsyncService((HttpProcessor)immutableHttpProcessor, this.connectionReuseStrategy, this.registry, this.getHttpParams()){

            public void connected(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)nHttpServerConnection;
                log.info("connected: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = new HttpsServerConnection(HttpsServer.this, nHttpServerConnection);
                map.put(nHttpServerConnection, httpsServerConnection);
                HttpsServer.this.connections.addConnection(httpsServerConnection);
                super.connected(nHttpServerConnection);
            }

            public void closed(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)nHttpServerConnection;
                log.info("closed: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = (HttpsServerConnection)map.remove(nHttpServerConnection);
                HttpsServer.this.connections.removeConnection(httpsServerConnection);
                super.closed(nHttpServerConnection);
            }
        };
        this.discoveryServer = new Server(application);
        this.discoveryServer.setEndpointBindings(this.endpointBindings);
        EndpointBinding endpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        this.discoveryHandler = new HttpsServerEndpointHandler(endpointBinding);
    }

    Set<SecurityPolicy> calcSecurityPolicies() {
        HashSet<SecurityPolicy> hashSet = new HashSet<SecurityPolicy>();
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            for (SecurityMode securityMode : endpointBinding.endpointAddress.getSecurityModes()) {
                hashSet.add(securityMode.getSecurityPolicy());
            }
        }
        return hashSet;
    }

    String[] calcCipherSuitePatterns() throws ServiceResultException {
        Collection<HttpsSecurityPolicy> collection = this.getSupportedSecurityPolicies();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpsSecurityPolicy httpsSecurityPolicy : collection) {
            String[] stringArray = httpsSecurityPolicy.getCipherSuites();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Collection<HttpsSecurityPolicy> getSupportedSecurityPolicies() {
        if (this.securityPolicies == null) {
            return HttpsSecurityPolicy.getAvailablePolicies().values();
        }
        return Arrays.asList(this.securityPolicies);
    }

    HttpParams getHttpParams() {
        return this.application.getHttpsSettings().getHttpParams() == null ? DEFAULT_HTTPPARAMS : this.application.getHttpsSettings().getHttpParams();
    }

    public void setWorkerThreadCount(int n) {
        if (this.ioReactor != null) {
            throw new RuntimeException("Set workercount before binding the first socket address");
        }
        this.ioConfig.setIoThreadCount(n);
    }

    public int getWorkerThreadCount() {
        return this.ioConfig.getIoThreadCount();
    }

    protected void shutdownReactor() {
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            ListenerEndpoint listenerEndpoint = socketHandle.listenerEndpoint;
            if (listenerEndpoint != null) {
                listenerEndpoint.close();
            }
            socketHandle.listenerEndpoint = null;
        }
        if (this.ioReactor != null) {
            try {
                this.ioReactor.shutdown();
            }
            catch (IOException iOException) {
                log.error("Failed to shutdown ioReactor", (Throwable)iOException);
            }
            this.ioReactor = null;
        }
        if (this.sslReactorThread != null) {
            this.sslReactorThread.interrupt();
            try {
                this.sslThreadSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sslThreadSemaphore = null;
            this.sslReactorThread = null;
        }
        if (this.plainReactorThread != null) {
            this.plainReactorThread.interrupt();
            try {
                this.plainThreadSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.plainThreadSemaphore = null;
            this.plainReactorThread = null;
        }
    }

    protected void initReactor() throws ServiceResultException {
        boolean bl = false;
        boolean bl2 = false;
        for (SocketHandle socketHandle : this.socketHandles.values()) {
            bl |= socketHandle.scheme.equals("https");
            bl2 |= socketHandle.scheme.equals("http");
        }
        try {
            Object object;
            if (bl && this.sslSetupHandler == null) {
                object = SSLContext.getInstance("TLS");
                ((SSLContext)object).init(this.application.getHttpsSettings().getKeyManagers(), this.application.getHttpsSettings().getTrustManagers(), null);
                this.sslSetupHandler = new SSLSetupHandler(){

                    public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    }

                    public void initalize(SSLEngine sSLEngine) throws SSLException {
                    }
                };
                this.sslConnFactory = new SSLNHttpServerConnectionFactory((SSLContext)object, this.sslSetupHandler, this.getHttpParams());
                this.sslIoEventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)this.protocolHandler, this.sslConnFactory);
                this.sslEngine = ((SSLContext)object).createSSLEngine();
                log.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(this.sslEngine.getEnabledProtocols()));
                this.enabledCipherSuites = this.sslEngine.getEnabledCipherSuites();
                log.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(this.enabledCipherSuites));
            }
            if (bl) {
                object = this.cipherSuites;
                this.cipherSuitePatterns = this.calcCipherSuitePatterns();
                this.cipherSuites = CryptoUtil.filterCipherSuiteList(this.enabledCipherSuites, this.cipherSuitePatterns);
                this.sslEngine.setEnabledCipherSuites(this.cipherSuites);
                if (object == null || !Arrays.equals((Object[])object, this.cipherSuites)) {
                    log.info("CipherSuites for policies ({}) are {}", (Object)Arrays.toString(this.securityPolicies), (Object)Arrays.toString(this.cipherSuites));
                }
            }
            if (bl2 && this.plainConnFactory == null) {
                this.plainConnFactory = new DefaultNHttpServerConnectionFactory(this.getHttpParams());
                this.plainIoEventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)this.protocolHandler, this.plainConnFactory);
            }
            if (this.ioReactor == null) {
                this.ioReactor = new DefaultListeningIOReactor(this.ioConfig, null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (IOReactorException iOReactorException) {
            throw new ServiceResultException(iOReactorException);
        }
    }

    public HttpsSettings getHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    synchronized SocketHandle getOrCreateSocketHandle(SocketAddress socketAddress, String string) throws ServiceResultException {
        SocketHandle socketHandle = this.socketHandles.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress, string);
            this.socketHandles.put(socketAddress, socketHandle);
        } else if (!string.equals(socketHandle.scheme)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Socket port=" + socketHandle.getPort() + " cannot be bound as http and https.");
        }
        return socketHandle;
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        Object object2;
        String string;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        String string2 = string = endpointBinding.endpointAddress.getEndpointUrl();
        string2 = UriUtil.getEndpointName(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((object2 = this.registry.lookup(string2)) == null) {
            object = new HttpsServerEndpointHandler(endpointBinding);
            this.registry.register(string2, (HttpsServerEndpointHandler)object);
            this.registry.register("", this.discoveryHandler);
        } else {
            object = (HttpsServerEndpointHandler)object2;
            if (((HttpsServerEndpointHandler)object).endpointServer != endpointBinding.endpointServer) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind endpoint " + string + " and " + ((HttpsServerEndpointHandler)object).endpointBinding.endpointAddress.getEndpointUrl() + " with two different sets of service.");
            }
        }
        string2 = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        object2 = this.getOrCreateSocketHandle(socketAddress, string2);
        object = ((SocketHandle)object2).getOrCreate(endpointBinding);
        try {
            ListeningIOReactor listeningIOReactor;
            this.shutdownReactor();
            this.initReactor();
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                if (socketHandle.listenerEndpoint != null) continue;
                socketHandle.listenerEndpoint = this.ioReactor.listen(socketHandle.getSocketAddress());
            }
            if ("https".equals(string2) && (this.sslReactorThread == null || !this.sslReactorThread.isAlive())) {
                listeningIOReactor = this.ioReactor;
                Semaphore semaphore = this.sslThreadSemaphore = new Semaphore(0);
                this.sslReactorThread = new Thread((IOReactor)listeningIOReactor, semaphore){
                    final /* synthetic */ IOReactor val$r;
                    final /* synthetic */ Semaphore val$s;
                    {
                        this.val$r = iOReactor;
                        this.val$s = semaphore;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            this.val$r.execute(HttpsServer.this.sslIoEventDispatch);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            this.val$s.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.sslReactorThread.start();
            }
            if ("http".equals(string2) && (this.plainReactorThread == null || !this.plainReactorThread.isAlive())) {
                listeningIOReactor = this.ioReactor;
                Semaphore semaphore = this.plainThreadSemaphore = new Semaphore(0);
                this.plainReactorThread = new Thread((IOReactor)listeningIOReactor, semaphore){
                    final /* synthetic */ IOReactor val$r;
                    final /* synthetic */ Semaphore val$s;
                    {
                        this.val$r = iOReactor;
                        this.val$s = semaphore;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            this.val$r.execute(HttpsServer.this.plainIoEventDispatch);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            this.val$s.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.plainReactorThread.start();
            }
        }
        catch (ServiceResultException serviceResultException) {
            ((HttpsEndpointHandle)object).close();
            throw serviceResultException;
        }
        log.info("Endpoint bound to {}", (Object)string);
        return object;
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.connections.addConnectionListener(connectListener);
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.connections.getConnections(collection);
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.connections.removeConnectionListener(connectListener);
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            endpointBinding.endpointServer.getEndpointBindings().remove(endpointBinding);
        }
        this.endpointBindings.clear();
        try {
            this.setState(CloseableObjectState.Closing);
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            try {
                if (this.ioReactor != null) {
                    this.ioReactor.shutdown();
                }
                if (this.sslReactorThread != null) {
                    this.sslReactorThread.interrupt();
                    this.sslReactorThread = null;
                }
                if (this.plainReactorThread != null) {
                    this.plainReactorThread.interrupt();
                    this.plainReactorThread = null;
                }
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.socketHandles.values().toArray(new SocketHandle[this.socketHandles.size()]);
    }

    List<HttpsEndpointHandle> findEndpoints(String string) {
        ArrayList<HttpsEndpointHandle> arrayList = new ArrayList<HttpsEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.endpointHandleSnapshot(arrayList);
        }
        return arrayList;
    }

    int countEndpoints(Endpoint endpoint) {
        int n = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (HttpsEndpointHandle httpsEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!httpsEndpointHandle.endpointBinding.endpointAddress.equals(endpoint)) continue;
                ++n;
            }
        }
        return n;
    }

    class RequestResolver
    implements HttpAsyncRequestHandlerResolver {
        Map<String, HttpsServerEndpointHandler> map = new HashMap<String, HttpsServerEndpointHandler>();

        public void register(String string, HttpsServerEndpointHandler httpsServerEndpointHandler) {
            this.map.put(string, httpsServerEndpointHandler);
        }

        public void unregister(String string) {
            this.map.remove(string);
        }

        public void setHandlers(Map<String, HttpAsyncRequestHandler<?>> map) {
            this.map.clear();
            for (Map.Entry<String, HttpAsyncRequestHandler<?>> entry : map.entrySet()) {
                this.map.put(entry.getKey(), (HttpsServerEndpointHandler)entry.getValue());
            }
        }

        public Map<String, HttpAsyncRequestHandler<?>> getHandlers() {
            return new HashMap(this.map);
        }

        public HttpAsyncRequestHandler<?> lookup(String string) {
            HttpAsyncRequestHandler httpAsyncRequestHandler = this.map.get(string);
            if (httpAsyncRequestHandler == null && (string.equals("") || string.equals("/"))) {
                return HttpsServer.this.discoveryHandler;
            }
            return httpAsyncRequestHandler;
        }
    }

    public class HttpsEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding endpointBinding;
        SocketHandle socketHandle;

        HttpsEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.socketHandle = socketHandle;
            this.endpointBinding = endpointBinding;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.socketHandle.getSocketAddress();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.endpointBinding;
        }

        @Override
        public void close() {
            this.close_();
            this.close__();
        }

        void close_() {
            this.socketHandle.endpoints.remove(this.endpointBinding.endpointAddress);
            if (this.socketHandle.endpoints.isEmpty()) {
                this.socketHandle.close();
            }
        }

        void close__() {
            int n = HttpsServer.this.countEndpoints(this.endpointBinding.endpointAddress);
            if (n == 0) {
                String string = this.endpointBinding.endpointAddress.getEndpointUrl();
                HttpsServer.this.registry.unregister(string);
                HttpsServer.this.registry.unregister("");
                HttpsServer.this.endpointBindings.remove(this.endpointBinding);
                this.endpointBinding.serviceServer.getEndpointBindings().remove(this.endpointBinding);
            }
        }

        public String toString() {
            return "(" + this.endpointBinding.endpointAddress.toString() + ")";
        }
    }

    public class SocketHandle {
        private SocketAddress socketAddress;
        ListenerEndpoint listenerEndpoint;
        String scheme;
        Map<Endpoint, HttpsEndpointHandle> endpoints = new HashMap<Endpoint, HttpsEndpointHandle>();

        SocketHandle(SocketAddress socketAddress, String string) {
            this.setSocketAddress(socketAddress);
            this.scheme = string;
        }

        public synchronized HttpsEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new HttpsEndpointHandle[this.endpoints.size()]);
        }

        synchronized void endpointHandleSnapshot(Collection<HttpsEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized HttpsEndpointHandle getOrCreate(EndpointBinding endpointBinding) throws ServiceResultException {
            HttpsEndpointHandle httpsEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (httpsEndpointHandle == null) {
                httpsEndpointHandle = new HttpsEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, httpsEndpointHandle);
                HttpsServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!httpsEndpointHandle.endpointBinding.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return httpsEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        void close() {
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                httpsEndpointHandle.close__();
            }
            HttpsServer.this.socketHandles.remove(this.getSocketAddress());
            if (this.listenerEndpoint != null) {
                this.listenerEndpoint.close();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme + "(" + this.getSocketAddress() + ", ");
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(httpsEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public SocketAddress getSocketAddress() {
            return this.socketAddress;
        }

        void setSocketAddress(SocketAddress socketAddress) {
            this.socketAddress = socketAddress;
        }
    }
}

