/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.endpoint;

import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.ServerSecureChannel;

public abstract class EndpointServiceRequest<Request extends ServiceRequest, Response extends ServiceResponse> {
    protected Server server;
    protected Endpoint endpoint;
    protected Request request;

    public EndpointServiceRequest(Request Request, Server server, Endpoint endpoint) {
        this.request = Request;
        this.server = server;
        this.endpoint = endpoint;
    }

    public Request getRequest() {
        return this.request;
    }

    public Server getServer() {
        return this.server;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public abstract void sendResponse(AsyncWrite var1);

    public abstract AsyncWrite sendResponse(Response var1);

    public void sendFault(ServiceFault serviceFault) {
        this.sendResponse(new AsyncWrite(serviceFault));
    }

    public void sendException(Throwable throwable) {
        this.sendResponse(new AsyncWrite(ServiceFault.toServiceFault(throwable)));
    }

    public abstract ServerSecureChannel getChannel();
}

