/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.utils.EndpointUtil;

public class EndpointCollection {
    protected Map<Endpoint, Server> endpoints = new HashMap<Endpoint, Server>();

    public synchronized void add(Endpoint endpoint, Server server) {
        if (endpoint == null || server == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (Endpoint endpoint2 : this.endpoints.keySet()) {
            if (!endpoint2.getEndpointUrl().equals(endpoint.getEndpointUrl())) continue;
            throw new RuntimeException("Collection already contains endpoint");
        }
        this.endpoints.put(endpoint, server);
    }

    public synchronized Server remove(Endpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public synchronized boolean contains(Endpoint endpoint) {
        return this.endpoints.containsKey(endpoint);
    }

    public synchronized boolean contains(Server server) {
        return this.endpoints.containsValue(server);
    }

    public synchronized Server getServer(Endpoint endpoint) {
        return this.endpoints.get(endpoint);
    }

    public synchronized Endpoint[] getEndpoints() {
        return this.endpoints.keySet().toArray(new Endpoint[this.endpoints.size()]);
    }

    public synchronized Endpoint[] getEndpoints(Server server) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        for (Map.Entry<Endpoint, Server> entry : this.endpoints.entrySet()) {
            if (entry.getValue() != server) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new Endpoint[arrayList.size()]);
    }

    public synchronized Server[] getServers() {
        HashSet<Server> hashSet = new HashSet<Server>();
        for (Server server : this.endpoints.values()) {
            hashSet.add(server);
        }
        return hashSet.toArray(new Server[0]);
    }

    public synchronized Endpoint get(String string, SecurityMode securityMode) {
        for (Endpoint endpoint : this.endpoints.keySet()) {
            if (!endpoint.supportsSecurityMode(securityMode) || !string.equalsIgnoreCase(endpoint.getEndpointUrl())) continue;
            return endpoint;
        }
        return null;
    }

    public synchronized Endpoint get(String string) {
        for (Endpoint endpoint : this.endpoints.keySet()) {
            if (string != null && !string.equalsIgnoreCase(endpoint.getEndpointUrl())) continue;
            return endpoint;
        }
        return null;
    }

    public synchronized int size() {
        return this.endpoints.size();
    }

    public Endpoint getDefault(String string) {
        if (string == null) {
            throw new NullPointerException("url must be defined");
        }
        try {
            URI uRI = new URI(string);
            for (Endpoint endpoint : this.endpoints.keySet()) {
                try {
                    URI uRI2 = new URI(endpoint.getEndpointUrl());
                    if (!EndpointUtil.urlEqualsHostIgnoreCase(uRI2, uRI)) continue;
                    return endpoint;
                }
                catch (URISyntaxException uRISyntaxException) {
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

