/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.endpoint;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerSecureChannel
extends AbstractState<CloseableObjectState, ServiceResultException>
implements ServerSecureChannel {
    private int secureChannelId;
    protected Map<Integer, SecurityToken> tokens = new ConcurrentHashMap<Integer, SecurityToken>();
    protected SecurityToken activeToken;
    static Logger logger = LoggerFactory.getLogger(AbstractServerSecureChannel.class);

    protected AbstractServerSecureChannel(int n) {
        super(CloseableObjectState.Closed);
        this.secureChannelId = n;
    }

    @Override
    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public SecurityToken getActiveSecurityToken() {
        return this.activeToken;
    }

    public void setActiveSecurityToken(SecurityToken securityToken) {
        if (securityToken == null) {
            throw new IllegalArgumentException("null");
        }
        logger.debug("Switching to new security token {}", (Object)securityToken.getTokenId());
        this.activeToken = securityToken;
        this.pruneInvalidTokens();
    }

    public synchronized SecurityToken getSecurityToken(int n) {
        logger.debug("tokens({})={}", (Object)this.tokens.size(), this.tokens.values());
        return this.tokens.get(n);
    }

    private void pruneInvalidTokens() {
        if (logger.isDebugEnabled()) {
            logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.tokens.size(), this.tokens.values());
        }
        for (SecurityToken securityToken : this.tokens.values()) {
            if (securityToken.isValid()) continue;
            logger.debug("pruneInvalidTokens: remove Id={}", (Object)securityToken.getTokenId());
            this.tokens.remove(securityToken.getTokenId());
        }
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        SecurityToken securityToken = this.getActiveSecurityToken();
        return securityToken == null ? null : securityToken.getMessageSecurityMode();
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        SecurityToken securityToken = this.getActiveSecurityToken();
        return securityToken == null ? null : securityToken.getSecurityPolicy();
    }

    public synchronized SecurityToken getLatestNonExpiredToken() {
        SecurityToken securityToken = null;
        for (SecurityToken securityToken2 : this.tokens.values()) {
            if (securityToken2.isExpired()) continue;
            if (securityToken == null) {
                securityToken = securityToken2;
            }
            if (securityToken2.getCreationTime() <= securityToken.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        return securityToken;
    }

    @Override
    public synchronized void setError(ServiceResultException serviceResultException) {
        super.setError(serviceResultException);
    }

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }

    public String toString() {
        return String.format("SecureChannelId=%d State=%s URL=%s SecurityPolicy=%s RemoteAddress=%s", this.getSecureChannelId(), this.getState(), this.getConnectURL(), this.getSecurityPolicy(), this.getRemoteAddress());
    }

    protected String getRemoteAddress() {
        if (this.getConnection() == null) {
            return "(no connection)";
        }
        return "" + this.getConnection().getRemoteAddress();
    }

    @Override
    public boolean isOpen() {
        return ((CloseableObjectState)((Object)this.getState())).isOpen();
    }

    @Override
    public void close() {
        if (this.getState() != CloseableObjectState.Open) {
            return;
        }
        this.setState(CloseableObjectState.Closing);
        this.setState(CloseableObjectState.Closed);
        logger.info("Channel closed: Id={}", (Object)this.getSecureChannelId());
    }

    @Override
    public AsyncResult<ServerSecureChannel> closeAsync() {
        AsyncResultImpl<ServerSecureChannel> asyncResultImpl = new AsyncResultImpl<ServerSecureChannel>();
        if (this.getState() != CloseableObjectState.Open) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.setState(CloseableObjectState.Closing);
        this.setState(CloseableObjectState.Closed);
        asyncResultImpl.setResult(this);
        return asyncResultImpl;
    }
}

