/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.binary;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.BuiltinsMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.IEncoder;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderUtils;
import org.opcfoundation.ua.encoding.utils.EncodeableDesc;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;

public class EncoderCalc
implements IEncoder {
    EncoderContext ctx;
    int length;

    public int getLength() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }

    public int getAndReset() {
        int n = this.length;
        this.length = 0;
        return n;
    }

    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    @Override
    public void putBoolean(String string, Boolean bl) {
        ++this.length;
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) {
        if (booleanArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + booleanArray.length;
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + collection.size();
    }

    @Override
    public void putSByte(String string, Byte by) {
        ++this.length;
    }

    @Override
    public void putSByte(String string, byte by) {
        ++this.length;
    }

    @Override
    public void putSByte(String string, int n) {
        ++this.length;
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) {
        if (byteArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + byteArray.length;
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + collection.size();
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) {
        ++this.length;
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) {
        if (unsignedByteArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + unsignedByteArray.length;
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + collection.size();
    }

    @Override
    public void putInt16(String string, Short s) {
        this.length += 2;
    }

    @Override
    public void putInt16(String string, short s) {
        this.length += 2;
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) {
        if (shortArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 2 * shortArray.length;
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 2 * collection.size();
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) {
        this.length += 2;
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) {
        if (unsignedShortArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 2 * unsignedShortArray.length;
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 2 * collection.size();
    }

    @Override
    public void putInt32(String string, Integer n) {
        this.length += 4;
    }

    @Override
    public void putInt32(String string, int n) {
        this.length += 4;
    }

    @Override
    public void putInt32Array(String string, int[] nArray) {
        if (nArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * nArray.length;
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * collection.size();
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) {
        if (integerArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * integerArray.length;
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) {
        this.length += 4;
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) {
        if (unsignedIntegerArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * unsignedIntegerArray.length;
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * collection.size();
    }

    @Override
    public void putInt64(String string, Long l) {
        this.length += 8;
    }

    @Override
    public void putInt64(String string, long l) {
        this.length += 8;
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) {
        if (longArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * longArray.length;
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * collection.size();
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) {
        this.length += 8;
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) {
        if (unsignedLongArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * unsignedLongArray.length;
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * collection.size();
    }

    @Override
    public void putFloat(String string, Float f) {
        this.length += 4;
    }

    @Override
    public void putFloat(String string, float f) {
        this.length += 4;
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) {
        if (floatArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * floatArray.length;
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * collection.size();
    }

    @Override
    public void putDouble(String string, Double d) {
        this.length += 8;
    }

    @Override
    public void putDouble(String string, double d) {
        this.length += 8;
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) {
        if (doubleArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * doubleArray.length;
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * collection.size();
    }

    @Override
    public void putString(String string, String string2) {
        this.length = string2 == null ? (this.length += 4) : (this.length += 4 + string2.getBytes(BinaryEncoder.UTF8).length);
    }

    @Override
    public void putStringArray(String string, String[] stringArray) {
        if (stringArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < stringArray.length; ++i) {
            this.putString(null, stringArray[i]);
        }
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (String string2 : collection) {
            this.putString(null, string2);
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) {
        this.length += 8;
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) {
        if (dateTimeArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * dateTimeArray.length;
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 8 * collection.size();
    }

    @Override
    public void putGuid(String string, UUID uUID) {
        this.length += 16;
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) {
        if (uUIDArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 16 * uUIDArray.length;
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 16 * collection.size();
    }

    @Override
    public void putByteString(String string, byte[] byArray) {
        this.length = byArray == null ? (this.length += 4) : (this.length += 4 + byArray.length);
    }

    @Override
    public void putByteStringArray(String string, byte[][] byArray) {
        if (byArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < byArray.length; ++i) {
            this.putByteString(null, byArray[i]);
        }
    }

    @Override
    public void putByteStringArray(String string, Collection<byte[]> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (byte[] byArray : collection) {
            this.putByteString(null, byArray);
        }
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) {
        if (xmlElement == null) {
            this.length += 4;
        } else {
            this.putByteString(null, xmlElement.getData());
        }
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) {
        if (xmlElementArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < xmlElementArray.length; ++i) {
            this.putXmlElement(null, xmlElementArray[i]);
        }
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (XmlElement xmlElement : collection) {
            this.putXmlElement(null, xmlElement);
        }
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) {
        if (nodeId == null) {
            nodeId = NodeId.NULL;
        }
        Object object = nodeId.getValue();
        if (nodeId.getIdType() == IdType.Numeric) {
            UnsignedInteger unsignedInteger = (UnsignedInteger)object;
            this.length = unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0 ? (this.length += 2) : (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256 ? (this.length += 4) : (this.length += 7));
        } else if (nodeId.getIdType() == IdType.String) {
            this.length += 3;
            this.putString(null, (String)nodeId.getValue());
        } else if (nodeId.getIdType() == IdType.Opaque) {
            this.length += 3;
            this.putByteString(null, (byte[])nodeId.getValue());
        } else if (nodeId.getIdType() == IdType.Guid) {
            this.length += 19;
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) {
        if (nodeIdArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < nodeIdArray.length; ++i) {
            this.putNodeId(null, nodeIdArray[i]);
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (NodeId nodeId : collection) {
            this.putNodeId(null, nodeId);
        }
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            expandedNodeId = ExpandedNodeId.NULL;
        }
        Object object = expandedNodeId.getValue();
        if (expandedNodeId.getIdType() == IdType.Numeric) {
            UnsignedInteger unsignedInteger = (UnsignedInteger)object;
            this.length = unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0 ? (this.length += 2) : (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256 ? (this.length += 4) : (this.length += 7));
        }
        if (expandedNodeId.getIdType() == IdType.String) {
            this.length += 3;
            this.putString(null, (String)expandedNodeId.getValue());
        } else if (expandedNodeId.getIdType() == IdType.Opaque) {
            this.length += 3;
            this.putByteString(null, (byte[])expandedNodeId.getValue());
        } else if (expandedNodeId.getIdType() == IdType.Guid) {
            this.length += 3;
            this.putGuid(null, (UUID)expandedNodeId.getValue());
        }
        if (expandedNodeId.getNamespaceUri() != null) {
            this.putString(null, expandedNodeId.getNamespaceUri());
        }
        if (expandedNodeId.getServerIndex() != null) {
            this.length += 4;
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) {
        if (expandedNodeIdArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < expandedNodeIdArray.length; ++i) {
            this.putExpandedNodeId(null, expandedNodeIdArray[i]);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (ExpandedNodeId expandedNodeId : collection) {
            this.putExpandedNodeId(null, expandedNodeId);
        }
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) {
        this.length += 4;
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) {
        if (statusCodeArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * statusCodeArray.length;
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4 + 4 * collection.size();
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            this.length += 2;
            this.putString(null, null);
            return;
        }
        this.length += 2;
        this.putString(null, qualifiedName.getName());
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) {
        if (qualifiedNameArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < qualifiedNameArray.length; ++i) {
            this.putQualifiedName(null, qualifiedNameArray[i]);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (QualifiedName qualifiedName : collection) {
            this.putQualifiedName(null, qualifiedName);
        }
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) {
        if (localizedText == null) {
            ++this.length;
            return;
        }
        String string2 = localizedText.getLocaleId();
        String string3 = localizedText.getText();
        ++this.length;
        if (string2 != null) {
            this.putString(null, string2);
        }
        if (string3 != null) {
            this.putString(null, string3);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) {
        if (localizedTextArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < localizedTextArray.length; ++i) {
            this.putLocalizedText(null, localizedTextArray[i]);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (LocalizedText localizedText : collection) {
            this.putLocalizedText(null, localizedText);
        }
    }

    @Override
    public void putStructure(String string, Structure structure) throws EncodingException {
        if (structure == null) {
            this.putNodeId(null, NodeId.ZERO);
            ++this.length;
            this.length += 4;
            return;
        }
        try {
            this.putNodeId(null, this.ctx.getNamespaceTable().toNodeId(structure.getBinaryEncodeId()));
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get BinaryEncodeId for given Structure", serviceResultException);
        }
        ++this.length;
        this.length += 4;
        this.putEncodeable(string, structure);
    }

    @Override
    public void putStructureArray(String string, Structure[] structureArray) throws EncodingException {
        if (structureArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (Structure structure : structureArray) {
            this.putStructure(null, structure);
        }
    }

    @Override
    public void putStructureArray(String string, Collection<Structure> collection) throws EncodingException {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (Structure structure : collection) {
            this.putStructure(null, structure);
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        if (extensionObject == null) {
            this.putNodeId(null, null);
            ++this.length;
            return;
        }
        this.putNodeId(null, this.ctx.toNodeId(extensionObject.getTypeId()));
        Object object = extensionObject.getObject();
        if (object == null) {
            ++this.length;
        } else if (object instanceof byte[]) {
            ++this.length;
            this.putByteString(null, (byte[])object);
        } else if (object instanceof XmlElement) {
            ++this.length;
            this.putXmlElement(null, (XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + object);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        if (extensionObjectArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < extensionObjectArray.length; ++i) {
            this.putExtensionObject(null, extensionObjectArray[i]);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (ExtensionObject extensionObject : collection) {
            this.putExtensionObject(null, extensionObject);
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.putSByte(null, 0);
            return;
        }
        int n = 0;
        if (dataValue.getValue() != null) {
            n |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n |= 0x20;
        }
        ++this.length;
        if ((n & 1) == 1) {
            this.putVariant(null, dataValue.getValue());
        }
        if ((n & 2) == 2) {
            this.putStatusCode(null, dataValue.getStatusCode());
        }
        if ((n & 4) == 4) {
            this.putDateTime(null, dataValue.getSourceTimestamp());
        }
        if ((n & 8) == 8) {
            this.putDateTime(null, dataValue.getServerTimestamp());
        }
        if ((n & 0x10) == 16) {
            this.putUInt16(null, dataValue.getSourcePicoseconds());
        }
        if ((n & 0x20) == 32) {
            this.putUInt16(null, dataValue.getServerPicoseconds());
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        if (dataValueArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < dataValueArray.length; ++i) {
            this.putDataValue(null, dataValueArray[i]);
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (DataValue dataValue : collection) {
            this.putDataValue(null, dataValue);
        }
    }

    @Override
    public void putVariant(String string, Variant variant) throws EncodingException {
        if (variant == null) {
            ++this.length;
            return;
        }
        Object object = variant.getValue();
        if (object == null) {
            ++this.length;
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        int n = Structure.class.isAssignableFrom(clazz) || Enumeration.class.isAssignableFrom(clazz) ? 22 : BuiltinsMap.ID_MAP.get(clazz);
        if (!variant.isArray()) {
            this.putSByte(null, n);
            this.putScalar(null, n, object);
            return;
        }
        int n2 = variant.getDimension();
        if (n2 == 1) {
            this.putSByte(null, n | 0x80);
            this.putArray(null, n, object);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n3 = MultiDimensionArrayUtils.getLength(nArray);
        int n4 = this.guessBuiltinSize(n);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.putSByte(null, n | 0xC0);
            this.length += 4;
            if (n4 > 0) {
                this.length += n4 * n3;
            } else {
                while (arrayIterator.hasNext()) {
                    this.putScalar(null, n, arrayIterator.next());
                }
            }
            this.putInt32Array((String)null, nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The inner dimensions of a multi-dimension must be consistent", arrayIndexOutOfBoundsException);
        }
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        if (variantArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (int i = 0; i < variantArray.length; ++i) {
            this.putVariant(null, variantArray[i]);
        }
    }

    @Override
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (Variant variant : collection) {
            this.putVariant(null, variant);
        }
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) {
        if (diagnosticInfo == null) {
            this.putSByte(null, 0);
            return;
        }
        int n = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n |= 0x40;
        }
        this.putSByte(null, n);
        if ((n & 1) == 1) {
            this.length += 4;
        }
        if ((n & 2) == 2) {
            this.length += 4;
        }
        if ((n & 4) == 4) {
            this.length += 4;
        }
        if ((n & 8) == 8) {
            this.length += 4;
        }
        if ((n & 0x10) == 16) {
            this.putString(null, diagnosticInfo.getAdditionalInfo());
        }
        if ((n & 0x20) == 32) {
            this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
        }
        if ((n & 0x40) == 64) {
            this.putDiagnosticInfo(null, diagnosticInfo.getInnerDiagnosticInfo());
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        if (diagnosticInfoArray == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
            this.putDiagnosticInfo(null, diagnosticInfo);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        if (collection == null) {
            this.length += 4;
            return;
        }
        this.length += 4;
        for (DiagnosticInfo diagnosticInfo : collection) {
            this.putDiagnosticInfo(null, diagnosticInfo);
        }
    }

    @Override
    public void putEnumerationArray(String string, Object object) {
        if (object == null) {
            this.length += 4;
            return;
        }
        int n = Array.getLength(object);
        this.length += 4;
        for (int i = 0; i < n; ++i) {
            this.putEnumeration(null, (Enumeration)Array.get(object, i));
        }
    }

    @Override
    public void putEnumeration(String string, Enumeration enumeration) {
        this.length += 4;
    }

    @Override
    public void putObject(String string, Object object) throws EncodingException {
        if (object == null) {
            throw new EncodingException("Cannot encode null value");
        }
        Class<?> clazz = object.getClass();
        this.putObject(null, clazz, object);
    }

    @Override
    public void putObject(String string, Class<?> clazz, Object object) throws EncodingException {
        Class<?> clazz2;
        boolean bl;
        Integer n = BuiltinsMap.ID_MAP.get(clazz);
        boolean bl2 = bl = clazz.isArray() && !clazz.equals(byte[].class);
        if (n != null) {
            if (bl) {
                this.putArray(null, n, object);
            } else {
                this.putScalar(null, n, object);
            }
            return;
        }
        if (!bl && Enumeration.class.isAssignableFrom(clazz)) {
            this.putEnumeration(null, (Enumeration)object);
            return;
        }
        if (bl && Enumeration.class.isAssignableFrom(clazz.getComponentType())) {
            this.putEnumerationArray(null, object);
            return;
        }
        Class<?> clazz3 = clazz2 = bl ? clazz.getComponentType() : clazz;
        if (bl) {
            this.putEncodeableArray(null, clazz2, object);
        } else {
            this.ctx.encodeableSerializer.calcEncodeable(clazz2, (IEncodeable)object, this);
        }
    }

    int guessBuiltinSize(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
            case 13: {
                return 8;
            }
            case 14: {
                return 16;
            }
            case 19: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public void putScalar(String string, int n, Object object) throws EncodingException {
        switch (n) {
            case 1: {
                this.putBoolean(null, (Boolean)object);
                break;
            }
            case 2: {
                this.putSByte((String)null, (Byte)object);
                break;
            }
            case 3: {
                this.putByte(null, (UnsignedByte)object);
                break;
            }
            case 4: {
                this.putInt16((String)null, (Short)object);
                break;
            }
            case 5: {
                this.putUInt16(null, (UnsignedShort)object);
                break;
            }
            case 6: {
                this.putInt32((String)null, (Integer)object);
                break;
            }
            case 7: {
                this.putUInt32(null, (UnsignedInteger)object);
                break;
            }
            case 8: {
                this.putInt64((String)null, (Long)object);
                break;
            }
            case 9: {
                this.putUInt64(null, (UnsignedLong)object);
                break;
            }
            case 10: {
                this.putFloat((String)null, (Float)object);
                break;
            }
            case 11: {
                this.putDouble((String)null, (Double)object);
                break;
            }
            case 12: {
                this.putString(null, (String)object);
                break;
            }
            case 13: {
                this.putDateTime(null, (DateTime)object);
                break;
            }
            case 14: {
                this.putGuid(null, (UUID)object);
                break;
            }
            case 15: {
                this.putByteString(null, (byte[])object);
                break;
            }
            case 16: {
                this.putXmlElement(null, (XmlElement)object);
                break;
            }
            case 17: {
                this.putNodeId(null, (NodeId)object);
                break;
            }
            case 18: {
                this.putExpandedNodeId(null, (ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.putStatusCode(null, (StatusCode)object);
                break;
            }
            case 20: {
                this.putQualifiedName(null, (QualifiedName)object);
                break;
            }
            case 21: {
                this.putLocalizedText(null, (LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.putStructure(null, (Structure)object);
                    break;
                }
                if (object instanceof Enumeration) {
                    this.putEnumeration(null, (Enumeration)object);
                    break;
                }
                this.putExtensionObject(null, (ExtensionObject)object);
                break;
            }
            case 23: {
                this.putDataValue(null, (DataValue)object);
                break;
            }
            case 24: {
                this.putVariant(null, (Variant)object);
                break;
            }
            case 25: {
                this.putDiagnosticInfo(null, (DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n);
            }
        }
    }

    @Override
    public void putArray(String string, int n, Object object) throws EncodingException {
        switch (n) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (byte[][])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.putExtensionObjectArray(null, (ExtensionObject[])object);
                    break;
                }
                this.putStructureArray(null, (Structure[])object);
                break;
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n);
            }
        }
    }

    @Override
    public void putEncodeableArray(String string, Class<? extends IEncodeable> clazz, Object object) throws ArrayIndexOutOfBoundsException, EncodingException, IllegalArgumentException {
        if (object == null) {
            this.length += 4;
            return;
        }
        int n = Array.getLength(object);
        this.length += 4;
        for (int i = 0; i < n; ++i) {
            this.ctx.encodeableSerializer.calcEncodeable(clazz, (IEncodeable)Array.get(object, i), this);
        }
    }

    @Override
    public void putEncodeable(String string, IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        this.ctx.encodeableSerializer.calcEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putEncodeable(String string, Class<? extends IEncodeable> clazz, IEncodeable iEncodeable) throws EncodingException {
        this.ctx.encodeableSerializer.calcEncodeable(clazz, iEncodeable, this);
    }

    void putEncodeable(String string, IEncodeable iEncodeable, EncodeableDesc encodeableDesc) throws EncodingException {
        try {
            for (EncodeableDesc.FieldInfo fieldInfo : encodeableDesc.fields) {
                Field field = fieldInfo.field;
                Object object = iEncodeable == null ? null : field.get(iEncodeable);
                this.putObject(null, fieldInfo.type, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    @Override
    public void putMessage(IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        try {
            this.putNodeId(null, this.ctx.getEncodeableNodeId(clazz, EncodeType.Binary));
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get BinaryEncodeId for the class", serviceResultException);
        }
        this.ctx.encodeableSerializer.calcEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void put(String string, Object object) throws EncodingException {
        EncoderUtils.put(this, string, object);
    }

    public String toString() {
        return this.length + "";
    }

    @Override
    public void put(String string, Object object, Class<?> clazz) throws EncodingException {
        EncoderUtils.put(this, string, object, clazz);
    }
}

