/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.BuiltinsMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.IEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.encoding.binary.EncoderUtils;
import org.opcfoundation.ua.encoding.binary.NodeIdEncoding;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferWriteable;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryWriteable;
import org.opcfoundation.ua.utils.bytebuffer.OutputStreamWriteable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
implements IEncoder {
    private static Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    public static final Charset UTF8 = Charset.forName("utf-8");
    IBinaryWriteable out;
    EncoderContext ctx;
    EncoderMode mode = EncoderMode.Strict;

    public BinaryEncoder(IBinaryWriteable iBinaryWriteable) {
        this.setWriteable(iBinaryWriteable);
    }

    public BinaryEncoder(OutputStream outputStream) {
        OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(outputStream);
        outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(outputStreamWriteable);
    }

    public BinaryEncoder(ByteBuffer byteBuffer) {
        ByteBufferWriteable byteBufferWriteable = new ByteBufferWriteable(byteBuffer);
        this.setWriteable(byteBufferWriteable);
    }

    public BinaryEncoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    public void setWriteable(IBinaryWriteable iBinaryWriteable) {
        if (iBinaryWriteable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Writeable must be in Little-Ending byte order");
        }
        this.out = iBinaryWriteable;
    }

    public IBinaryWriteable getWriteable() {
        return this.out;
    }

    public IBinaryWriteable getOutput() {
        return this.out;
    }

    public EncoderMode getEncoderType() {
        return this.mode;
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.mode = encoderMode;
    }

    private void assertNullOk(Object object) throws EncodingException {
        if (object != null) {
            return;
        }
        if (this.mode == EncoderMode.Strict) {
            throw new EncodingException("Cannot encode null value");
        }
    }

    private void assertArrayLength(int n) throws EncodingException {
        int n2 = this.ctx.getMaxArrayLength();
        if (n2 > 0 && n > n2) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n2 + " < " + n);
            logger.warn("assertArrayLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void assertStringLength(int n) throws EncodingException {
        int n2 = this.ctx.getMaxStringLength();
        if (n2 > 0 && n > n2) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n2 + " < " + n);
            logger.warn("assertStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void assertByteStringLength(int n) throws EncodingException {
        int n2 = this.ctx.getMaxByteStringLength();
        if (n2 > 0 && n > n2) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n2 + " < " + n);
            logger.warn("assertByteStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private static EncodingException toEncodingException(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    @Override
    public void putBoolean(String string, Boolean bl) throws EncodingException {
        try {
            if (bl == null) {
                this.assertNullOk(bl);
                this.putSByte(null, 0);
            } else {
                this.out.put(bl != false ? (byte)1 : 0);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        try {
            if (booleanArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(booleanArray.length);
            this.out.putInt(booleanArray.length);
            for (Boolean bl : booleanArray) {
                this.putBoolean(null, bl);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Boolean bl : collection) {
                this.putBoolean(null, bl);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putSByte(String string, Byte by) throws EncodingException {
        try {
            if (by == null) {
                this.assertNullOk(by);
                this.putSByte(null, 0);
            } else {
                this.out.put(by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putSByte(String string, byte by) throws EncodingException {
        try {
            this.out.put(by);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putSByte(String string, int n) throws EncodingException {
        try {
            this.out.put((byte)n);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
        try {
            if (byteArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(byteArray.length);
            this.out.putInt(byteArray.length);
            for (Byte by : byteArray) {
                this.putSByte((String)null, by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Byte by : collection) {
                this.putSByte((String)null, by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte == null) {
                this.assertNullOk(unsignedByte);
                this.putSByte(null, 0);
            } else {
                this.out.put(unsignedByte.toByteBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        try {
            if (unsignedByteArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(unsignedByteArray.length);
            this.out.putInt(unsignedByteArray.length);
            for (UnsignedByte unsignedByte : unsignedByteArray) {
                this.putByte(null, unsignedByte);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (UnsignedByte unsignedByte : collection) {
                this.putByte(null, unsignedByte);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt16(String string, Short s) throws EncodingException {
        try {
            if (s == null) {
                this.assertNullOk(s);
                this.out.putShort((short)0);
            } else {
                this.out.putShort(s);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt16(String string, short s) throws EncodingException {
        try {
            this.out.putShort(s);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        try {
            if (shortArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(shortArray.length);
            this.out.putInt(shortArray.length);
            for (Short s : shortArray) {
                this.putInt16((String)null, s);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Short s : collection) {
                this.putInt16((String)null, s);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort == null) {
                this.assertNullOk(unsignedShort);
                this.out.putShort((short)0);
            } else {
                this.out.putShort(unsignedShort.toShortBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        try {
            if (unsignedShortArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(unsignedShortArray.length);
            this.out.putInt(unsignedShortArray.length);
            for (UnsignedShort unsignedShort : unsignedShortArray) {
                this.putUInt16(null, unsignedShort);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (UnsignedShort unsignedShort : collection) {
                this.putUInt16(null, unsignedShort);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt32(String string, Integer n) throws EncodingException {
        try {
            if (n == null) {
                this.assertNullOk(n);
                this.out.putInt(0);
            } else {
                this.out.putInt(n);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt32(String string, int n) throws EncodingException {
        try {
            this.out.putInt(n);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, int[] nArray) throws EncodingException {
        try {
            if (nArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(nArray.length);
            this.out.putInt(nArray.length);
            for (int n : nArray) {
                this.putInt32((String)null, n);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (int n : collection) {
                this.putInt32((String)null, n);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        try {
            if (integerArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(integerArray.length);
            this.out.putInt(integerArray.length);
            for (Integer n : integerArray) {
                this.putInt32((String)null, n);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger == null) {
                this.assertNullOk(unsignedInteger);
                this.out.putInt(0);
            } else {
                this.out.putInt(unsignedInteger.toIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        try {
            if (unsignedIntegerArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(unsignedIntegerArray.length);
            this.out.putInt(unsignedIntegerArray.length);
            for (UnsignedInteger unsignedInteger : unsignedIntegerArray) {
                this.putUInt32(null, unsignedInteger);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (UnsignedInteger unsignedInteger : collection) {
                this.putUInt32(null, unsignedInteger);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt64(String string, Long l) throws EncodingException {
        try {
            if (l == null) {
                this.assertNullOk(l);
                this.out.putLong(0L);
            } else {
                this.out.putLong(l);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt64(String string, long l) throws EncodingException {
        try {
            this.out.putLong(l);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        try {
            if (longArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(longArray.length);
            this.out.putInt(longArray.length);
            for (Long l : longArray) {
                this.putInt64((String)null, l);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Long l : collection) {
                this.putInt64((String)null, l);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong == null) {
                this.assertNullOk(unsignedLong);
                this.out.putLong(0L);
            } else {
                this.out.putLong(unsignedLong.toLongBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        try {
            if (unsignedLongArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(unsignedLongArray.length);
            this.out.putInt(unsignedLongArray.length);
            for (UnsignedLong unsignedLong : unsignedLongArray) {
                this.putUInt64(null, unsignedLong);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (UnsignedLong unsignedLong : collection) {
                this.putUInt64(null, unsignedLong);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putFloat(String string, Float f) throws EncodingException {
        try {
            if (f == null) {
                this.assertNullOk(f);
                this.out.putFloat(0.0f);
            } else {
                this.out.putFloat(f.floatValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putFloat(String string, float f) throws EncodingException {
        try {
            this.out.putFloat(f);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        try {
            if (floatArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(floatArray.length);
            this.out.putInt(floatArray.length);
            for (Float f : floatArray) {
                this.putFloat((String)null, f);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Float f : collection) {
                this.putFloat((String)null, f);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDouble(String string, Double d) throws EncodingException {
        try {
            if (d == null) {
                this.assertNullOk(d);
                this.out.putDouble(0.0);
            } else {
                this.out.putDouble(d);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDouble(String string, double d) throws EncodingException {
        try {
            this.out.putDouble(d);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        try {
            if (doubleArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(doubleArray.length);
            this.out.putInt(doubleArray.length);
            for (Double d : doubleArray) {
                this.putDouble((String)null, d);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Double d : collection) {
                this.putDouble((String)null, d);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putString(String string, String string2) throws EncodingException {
        try {
            if (string2 == null) {
                this.assertNullOk(string2);
                this.out.putInt(-1);
            } else {
                this.assertStringLength(string2.length());
                byte[] byArray = string2.getBytes(UTF8);
                this.out.putInt(byArray.length);
                this.out.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (String string2 : collection) {
                this.putString(null, string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStringArray(String string, String[] stringArray) throws EncodingException {
        try {
            if (stringArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(stringArray.length);
            this.out.putInt(stringArray.length);
            for (String string2 : stringArray) {
                this.putString(null, string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        try {
            if (dateTime == null) {
                this.assertNullOk(dateTime);
                this.out.putLong(0L);
            } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                this.out.putLong(Long.MAX_VALUE);
            } else if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                this.out.putLong(0L);
            } else {
                this.out.putLong(dateTime.getValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        try {
            if (dateTimeArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(dateTimeArray.length);
            this.out.putInt(dateTimeArray.length);
            for (DateTime dateTime : dateTimeArray) {
                this.putDateTime(null, dateTime);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (DateTime dateTime : collection) {
                this.putDateTime(null, dateTime);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putGuid(String string, UUID uUID) throws EncodingException {
        try {
            if (uUID == null) {
                this.assertNullOk(uUID);
                this.out.putLong(0L);
                this.out.putLong(0L);
            } else {
                int n;
                long l = uUID.getMostSignificantBits();
                long l2 = uUID.getLeastSignificantBits();
                byte[] byArray = new byte[16];
                for (n = 0; n < 8; ++n) {
                    byArray[n] = (byte)(l >>> 8 * (7 - n));
                }
                for (n = 8; n < 16; ++n) {
                    byArray[n] = (byte)(l2 >>> 8 * (7 - n));
                }
                this.out.put(byArray[3]);
                this.out.put(byArray[2]);
                this.out.put(byArray[1]);
                this.out.put(byArray[0]);
                this.out.put(byArray[5]);
                this.out.put(byArray[4]);
                this.out.put(byArray[7]);
                this.out.put(byArray[6]);
                for (n = 8; n < 16; ++n) {
                    this.out.put(byArray[n]);
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        try {
            if (uUIDArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(uUIDArray.length);
            this.out.putInt(uUIDArray.length);
            for (UUID uUID : uUIDArray) {
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (UUID uUID : collection) {
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByteString(String string, byte[] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.out.putInt(-1);
            } else {
                this.assertByteStringLength(byArray.length);
                this.out.putInt(byArray.length);
                this.out.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByteStringArray(String string, byte[][] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(byArray.length);
            this.out.putInt(byArray.length);
            for (byte[] byArray2 : byArray) {
                this.putByteString(null, byArray2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putByteStringArray(String string, Collection<byte[]> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (byte[] byArray : collection) {
                this.putByteString(null, byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement == null) {
                this.out.putInt(-1);
            } else {
                this.putByteString(string, xmlElement.getData());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        try {
            if (xmlElementArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(xmlElementArray.length);
            this.out.putInt(xmlElementArray.length);
            for (XmlElement xmlElement : xmlElementArray) {
                this.putXmlElement(null, xmlElement);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (XmlElement xmlElement : collection) {
                this.putXmlElement(null, xmlElement);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        try {
            if (nodeId == null) {
                nodeId = NodeId.NULL;
            }
            Object object = nodeId.getValue();
            if (nodeId.getIdType() == IdType.Numeric) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0) {
                    this.out.put(NodeIdEncoding.TwoByte.getBits());
                    this.out.put(unsignedInteger.byteValue());
                } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256) {
                    this.out.put(NodeIdEncoding.FourByte.getBits());
                    this.putSByte(null, nodeId.getNamespaceIndex());
                    this.out.putShort(unsignedInteger.shortValue());
                } else {
                    this.out.put(NodeIdEncoding.Numeric.getBits());
                    this.out.putShort((short)nodeId.getNamespaceIndex());
                    this.out.putInt(unsignedInteger.intValue());
                }
            } else if (nodeId.getIdType() == IdType.String) {
                this.out.put(NodeIdEncoding.String.getBits());
                this.out.putShort((short)nodeId.getNamespaceIndex());
                this.putString(null, (String)nodeId.getValue());
            } else if (nodeId.getIdType() == IdType.Opaque) {
                this.out.put(NodeIdEncoding.ByteString.getBits());
                this.out.putShort((short)nodeId.getNamespaceIndex());
                this.putByteString(null, (byte[])nodeId.getValue());
            } else if (nodeId.getIdType() == IdType.Guid) {
                UUID uUID = (UUID)nodeId.getValue();
                this.out.put(NodeIdEncoding.Guid.getBits());
                this.out.putShort((short)nodeId.getNamespaceIndex());
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        try {
            if (nodeIdArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(nodeIdArray.length);
            this.out.putInt(nodeIdArray.length);
            for (NodeId nodeId : nodeIdArray) {
                this.putNodeId(null, nodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (NodeId nodeId : collection) {
                this.putNodeId(null, nodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId == null) {
                expandedNodeId = ExpandedNodeId.NULL;
            }
            int n = 0;
            if (expandedNodeId.getNamespaceUri() != null) {
                n = (byte)(n | 0x80);
            }
            if (expandedNodeId.getServerIndex() != null) {
                n = (byte)(n | 0x40);
            }
            Object object = expandedNodeId.getValue();
            if (expandedNodeId.getIdType() == IdType.Numeric) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0) {
                    this.putSByte(null, NodeIdEncoding.TwoByte.getBits() | n);
                    this.out.put(unsignedInteger.byteValue());
                } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256) {
                    this.putSByte(null, NodeIdEncoding.FourByte.getBits() | n);
                    this.putSByte(null, expandedNodeId.getNamespaceIndex());
                    this.out.putShort(unsignedInteger.shortValue());
                } else {
                    this.putSByte(null, NodeIdEncoding.Numeric.getBits() | n);
                    this.out.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.out.putInt(unsignedInteger.intValue());
                }
            }
            if (expandedNodeId.getIdType() == IdType.String) {
                this.putSByte(null, NodeIdEncoding.String.getBits() | n);
                this.out.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putString(null, (String)expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Opaque) {
                this.putSByte(null, NodeIdEncoding.ByteString.getBits() | n);
                this.out.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putByteString(null, (byte[])expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Guid) {
                this.putSByte(null, NodeIdEncoding.Guid.getBits() | n);
                this.out.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putGuid(null, (UUID)expandedNodeId.getValue());
            }
            if (expandedNodeId.getNamespaceUri() != null) {
                this.putString(null, expandedNodeId.getNamespaceUri());
            }
            if (expandedNodeId.getServerIndex() != null) {
                this.out.putInt(expandedNodeId.getServerIndex().intValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        try {
            if (expandedNodeIdArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(expandedNodeIdArray.length);
            this.out.putInt(expandedNodeIdArray.length);
            for (ExpandedNodeId expandedNodeId : expandedNodeIdArray) {
                this.putExpandedNodeId(null, expandedNodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (ExpandedNodeId expandedNodeId : collection) {
                this.putExpandedNodeId(null, expandedNodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                this.assertNullOk(statusCode);
                this.out.putInt(StatusCode.GOOD.getValueAsIntBits());
            } else {
                this.out.putInt(statusCode.getValueAsIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        try {
            if (statusCodeArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(statusCodeArray.length);
            this.out.putInt(statusCodeArray.length);
            for (StatusCode statusCode : statusCodeArray) {
                this.putStatusCode(null, statusCode);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (StatusCode statusCode : collection) {
                this.putStatusCode(null, statusCode);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName == null) {
                this.out.putShort((short)0);
                this.putString(null, null);
                return;
            }
            this.out.putShort((short)qualifiedName.getNamespaceIndex());
            this.putString(null, qualifiedName.getName());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        try {
            if (qualifiedNameArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(qualifiedNameArray.length);
            this.out.putInt(qualifiedNameArray.length);
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.putQualifiedName(null, qualifiedName);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (QualifiedName qualifiedName : collection) {
                this.putQualifiedName(null, qualifiedName);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText == null) {
                this.putSByte(null, 0);
                return;
            }
            String string2 = localizedText.getLocaleId();
            String string3 = localizedText.getText();
            byte by = (byte)((string2 != null ? 1 : 0) | (string3 != null ? 2 : 0));
            this.out.put(by);
            if (string2 != null) {
                this.putString(null, string2);
            }
            if (string3 != null) {
                this.putString(null, string3);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        try {
            if (localizedTextArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(localizedTextArray.length);
            this.out.putInt(localizedTextArray.length);
            for (LocalizedText localizedText : localizedTextArray) {
                this.putLocalizedText(null, localizedText);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (LocalizedText localizedText : collection) {
                this.putLocalizedText(null, localizedText);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStructure(String string, Structure structure) throws EncodingException {
        if (structure == null) {
            this.assertNullOk(structure);
            this.putNodeId(null, NodeId.ZERO);
            this.putSByte(null, 0);
            this.putInt32((String)null, -1);
            return;
        }
        try {
            this.putNodeId(null, this.ctx.getNamespaceTable().toNodeId(structure.getBinaryEncodeId()));
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get BinaryEncodeId for given Structure", serviceResultException);
        }
        this.putSByte(null, 1);
        EncoderCalc encoderCalc = new EncoderCalc();
        encoderCalc.setEncoderContext(this.getEncoderContext());
        encoderCalc.putEncodeable(null, structure);
        int n = encoderCalc.getLength();
        this.putInt32((String)null, n);
        this.putEncodeable(null, structure);
    }

    @Override
    public void putStructureArray(String string, Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(structureArray.length);
            this.out.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.putStructure(null, structure);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putStructureArray(String string, Collection<Structure> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Structure structure : collection) {
                this.putStructure(null, structure);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        if (extensionObject == null) {
            this.assertNullOk(extensionObject);
            this.putNodeId(null, null);
            this.putSByte(null, 0);
            return;
        }
        this.putNodeId(null, this.ctx.toNodeId(extensionObject.getTypeId()));
        Object object = extensionObject.getObject();
        if (object == null) {
            this.putSByte(null, 0);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.putSByte(null, 1);
            this.putByteString(null, (byte[])object);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            this.putSByte(null, 2);
            this.putXmlElement(null, (XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(extensionObjectArray.length);
            this.out.putInt(extensionObjectArray.length);
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.putExtensionObject(null, extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (ExtensionObject extensionObject : collection) {
                this.putExtensionObject(null, extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.putSByte(null, 0);
            return;
        }
        int n = 0;
        if (dataValue.getValue() != null) {
            n |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n |= 0x20;
        }
        this.putSByte(null, n);
        if ((n & 1) == 1) {
            this.putVariant(null, dataValue.getValue());
        }
        if ((n & 2) == 2) {
            this.putStatusCode(null, dataValue.getStatusCode());
        }
        if ((n & 4) == 4) {
            this.putDateTime(null, dataValue.getSourceTimestamp());
        }
        if ((n & 8) == 8) {
            this.putDateTime(null, dataValue.getServerTimestamp());
        }
        if ((n & 0x10) == 16) {
            this.putUInt16(null, dataValue.getSourcePicoseconds());
        }
        if ((n & 0x20) == 32) {
            this.putUInt16(null, dataValue.getServerPicoseconds());
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        try {
            if (dataValueArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(dataValueArray.length);
            this.out.putInt(dataValueArray.length);
            for (DataValue dataValue : dataValueArray) {
                this.putDataValue(null, dataValue);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (DataValue dataValue : collection) {
                this.putDataValue(null, dataValue);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putVariant(String string, Variant variant) throws EncodingException {
        if (variant == null) {
            this.assertNullOk(variant);
            this.putSByte(null, 0);
            return;
        }
        Object object = variant.getValue();
        if (object == null) {
            this.putSByte(null, 0);
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        int n = Structure.class.isAssignableFrom(clazz) ? 22 : BuiltinsMap.ID_MAP.get(clazz);
        if (!variant.isArray()) {
            this.putSByte(null, n);
            this.putScalar(null, n, object);
            return;
        }
        int n2 = variant.getDimension();
        if (n2 == 1) {
            this.putSByte(null, n | 0x80);
            this.putArray(null, n, object);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n3 = MultiDimensionArrayUtils.getLength(nArray);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.putSByte(null, n | 0xC0);
            this.out.putInt(n3);
            while (arrayIterator.hasNext()) {
                this.putScalar(null, n, arrayIterator.next());
            }
            this.putInt32Array((String)null, nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The dimensions of inner array elements of a multi-dimension variable must be equal in length", arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        try {
            if (variantArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(variantArray.length);
            this.out.putInt(variantArray.length);
            for (Variant variant : variantArray) {
                this.putVariant(null, variant);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (Variant variant : collection) {
                this.putVariant(null, variant);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        try {
            if (diagnosticInfoArray == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(diagnosticInfoArray.length);
            this.out.putInt(diagnosticInfoArray.length);
            for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.out.putInt(-1);
                return;
            }
            this.assertArrayLength(collection.size());
            this.out.putInt(collection.size());
            for (DiagnosticInfo diagnosticInfo : collection) {
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo == null) {
            this.putSByte(null, 0);
            return;
        }
        int n = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n |= 0x40;
        }
        try {
            this.putSByte(null, n);
            if ((n & 1) == 1) {
                this.out.putInt(diagnosticInfo.getSymbolicId());
            }
            if ((n & 2) == 2) {
                this.out.putInt(diagnosticInfo.getNamespaceUri());
            }
            if ((n & 4) == 4) {
                this.out.putInt(diagnosticInfo.getLocalizedText());
            }
            if ((n & 8) == 8) {
                this.out.putInt(diagnosticInfo.getLocale());
            }
            if ((n & 0x10) == 16) {
                this.putString(null, diagnosticInfo.getAdditionalInfo());
            }
            if ((n & 0x20) == 32) {
                this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
            }
            if ((n & 0x40) == 64) {
                this.putDiagnosticInfo(null, diagnosticInfo.getInnerDiagnosticInfo());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putEnumerationArray(String string, Object object) throws EncodingException {
        try {
            if (object == null) {
                this.out.putInt(-1);
                return;
            }
            int n = Array.getLength(object);
            this.assertArrayLength(n);
            this.out.putInt(n);
            for (int i = 0; i < n; ++i) {
                this.putEnumeration(null, (Enumeration)Array.get(object, i));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putEnumeration(String string, Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration == null) {
                this.out.putInt(0);
                return;
            }
            this.out.putInt(enumeration.getValue());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putObject(String string, Object object) throws EncodingException {
        if (object == null) {
            throw new EncodingException("Cannot encode null value");
        }
        Class<?> clazz = object.getClass();
        this.putObject(null, clazz, object);
    }

    @Override
    public void putObject(String string, Class<?> clazz, Object object) throws EncodingException {
        Class<?> clazz2;
        boolean bl;
        Integer n = BuiltinsMap.ID_MAP.get(clazz);
        boolean bl2 = bl = clazz.isArray() && !clazz.equals(byte[].class);
        if (n != null) {
            if (bl) {
                this.putArray(null, n, object);
            } else {
                this.putScalar(null, n, object);
            }
            return;
        }
        if (!bl && Enumeration.class.isAssignableFrom(clazz)) {
            this.putEnumeration(null, (Enumeration)object);
            return;
        }
        if (bl && Enumeration.class.isAssignableFrom(clazz.getComponentType())) {
            this.putEnumerationArray(null, object);
            return;
        }
        Class<?> clazz3 = clazz2 = bl ? clazz.getComponentType() : clazz;
        if (bl) {
            this.putEncodeableArray(null, clazz2, object);
        } else {
            this.ctx.getEncodeableSerializer().putEncodeable(clazz, (IEncodeable)object, this);
        }
    }

    @Override
    public void putScalar(String string, int n, Object object) throws EncodingException {
        switch (n) {
            case 1: {
                this.putBoolean(null, (Boolean)object);
                break;
            }
            case 2: {
                this.putSByte((String)null, (Byte)object);
                break;
            }
            case 3: {
                this.putByte(null, (UnsignedByte)object);
                break;
            }
            case 4: {
                this.putInt16((String)null, (Short)object);
                break;
            }
            case 5: {
                this.putUInt16(null, (UnsignedShort)object);
                break;
            }
            case 6: {
                this.putInt32((String)null, (Integer)object);
                break;
            }
            case 7: {
                this.putUInt32(null, (UnsignedInteger)object);
                break;
            }
            case 8: {
                this.putInt64((String)null, (Long)object);
                break;
            }
            case 9: {
                this.putUInt64(null, (UnsignedLong)object);
                break;
            }
            case 10: {
                this.putFloat((String)null, (Float)object);
                break;
            }
            case 11: {
                this.putDouble((String)null, (Double)object);
                break;
            }
            case 12: {
                this.putString(null, (String)object);
                break;
            }
            case 13: {
                this.putDateTime(null, (DateTime)object);
                break;
            }
            case 14: {
                this.putGuid(null, (UUID)object);
                break;
            }
            case 15: {
                this.putByteString(null, (byte[])object);
                break;
            }
            case 16: {
                this.putXmlElement(null, (XmlElement)object);
                break;
            }
            case 17: {
                this.putNodeId(null, (NodeId)object);
                break;
            }
            case 18: {
                this.putExpandedNodeId(null, (ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.putStatusCode(null, (StatusCode)object);
                break;
            }
            case 20: {
                this.putQualifiedName(null, (QualifiedName)object);
                break;
            }
            case 21: {
                this.putLocalizedText(null, (LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.putStructure(null, (Structure)object);
                    break;
                }
                this.putExtensionObject(null, (ExtensionObject)object);
                break;
            }
            case 23: {
                this.putDataValue(null, (DataValue)object);
                break;
            }
            case 24: {
                this.putVariant(null, (Variant)object);
                break;
            }
            case 25: {
                this.putDiagnosticInfo(null, (DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n);
            }
        }
    }

    @Override
    public void putArray(String string, int n, Object object) throws EncodingException {
        switch (n) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (byte[][])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.putExtensionObjectArray(null, (ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.putStructureArray(null, (Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n);
            }
        }
    }

    @Override
    public void putEncodeableArray(String string, Class<? extends IEncodeable> clazz, Object object) throws EncodingException {
        try {
            if (object == null) {
                this.out.putInt(-1);
                return;
            }
            int n = Array.getLength(object);
            this.assertArrayLength(n);
            this.out.putInt(n);
            for (int i = 0; i < n; ++i) {
                this.ctx.getEncodeableSerializer().putEncodeable(clazz, (IEncodeable)Array.get(object, i), this);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.toEncodingException(iOException);
        }
    }

    @Override
    public void putEncodeable(String string, IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        this.ctx.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putEncodeable(String string, Class<? extends IEncodeable> clazz, IEncodeable iEncodeable) throws EncodingException {
        this.ctx.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putMessage(IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        try {
            this.putNodeId(null, this.ctx.getEncodeableNodeId(clazz, EncodeType.Binary));
        }
        catch (ServiceResultException serviceResultException) {
            serviceResultException.printStackTrace();
        }
        this.ctx.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void put(String string, Object object) throws EncodingException {
        EncoderUtils.put(this, string, object);
    }

    @Override
    public void put(String string, Object object, Class<?> clazz) throws EncodingException {
        EncoderUtils.put(this, string, object, clazz);
    }
}

