/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.IDecoder;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.NodeIdEncoding;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferReadable;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryReadable;
import org.opcfoundation.ua.utils.bytebuffer.InputStreamReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
implements IDecoder {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    IBinaryReadable in;
    EncoderContext ctx;

    public BinaryDecoder(IBinaryReadable iBinaryReadable) {
        this.setReadable(iBinaryReadable);
    }

    public BinaryDecoder(InputStream inputStream, int n) {
        InputStreamReadable inputStreamReadable = new InputStreamReadable(inputStream, n);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(inputStreamReadable);
    }

    public BinaryDecoder(ByteBuffer byteBuffer) {
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public IBinaryReadable getReadable() {
        return this.in;
    }

    public void setReadable(IBinaryReadable iBinaryReadable) {
        if (iBinaryReadable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Readable must be in Little-Ending byte order");
        }
        this.in = iBinaryReadable;
    }

    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    protected long remaining() throws DecodingException {
        try {
            return this.in.limit() - this.in.position();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    private void assertArrayLength(int n) throws DecodingException {
        if (n < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Illegal array length " + n);
        }
        int n2 = this.ctx.getMaxArrayLength();
        if (n2 > 0 && n > n2) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength=" + n2 + " < " + n);
        }
    }

    private void assertStringLength(int n) throws DecodingException {
        if (n < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected string length " + n);
        }
        int n2 = this.ctx.getMaxStringLength();
        if (n2 > 0 && n > n2) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n2 + " < " + n);
        }
    }

    private void assertByteStringLength(int n) throws DecodingException {
        if (n < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected byte string length " + n);
        }
        int n2 = this.ctx.getMaxByteStringLength();
        if (n2 > 0 && n > n2) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n2 + " < " + n);
        }
    }

    private static DecodingException toDecodingException(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new DecodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new DecodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new DecodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
        }
        return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    @Override
    public Boolean getBoolean(String string) throws DecodingException {
        try {
            if (this.in.get() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Boolean[] booleanArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                booleanArray[i] = this.getBoolean(null);
            }
            return booleanArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Byte getSByte(String string) throws DecodingException {
        try {
            return this.in.get();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Byte[] byteArray = new Byte[n];
            for (int i = 0; i < n; ++i) {
                byteArray[i] = this.getSByte(null);
            }
            return byteArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedByte getByte(String string) throws DecodingException {
        try {
            return UnsignedByte.getFromBits(this.in.get());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            UnsignedByte[] unsignedByteArray = new UnsignedByte[n];
            for (int i = 0; i < n; ++i) {
                unsignedByteArray[i] = this.getByte(null);
            }
            return unsignedByteArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Short getInt16(String string) throws DecodingException {
        try {
            return this.in.getShort();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 2) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Short[] shortArray = new Short[n];
            for (int i = 0; i < n; ++i) {
                shortArray[i] = this.getInt16(null);
            }
            return shortArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedShort getUInt16(String string) throws DecodingException {
        try {
            return UnsignedShort.getFromBits(this.in.getShort());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 2) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            UnsignedShort[] unsignedShortArray = new UnsignedShort[n];
            for (int i = 0; i < n; ++i) {
                unsignedShortArray[i] = this.getUInt16(null);
            }
            return unsignedShortArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Integer getInt32(String string) throws DecodingException {
        try {
            return this.in.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Integer[] integerArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                integerArray[i] = this.getInt32(null);
            }
            return integerArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.getInt32(null);
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedInteger getUInt32(String string) throws DecodingException {
        try {
            return UnsignedInteger.getFromBits(this.in.getInt());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[n];
            for (int i = 0; i < n; ++i) {
                unsignedIntegerArray[i] = this.getUInt32(null);
            }
            return unsignedIntegerArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Long getInt64(String string) throws DecodingException {
        try {
            return this.in.getLong();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 8) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Long[] longArray = new Long[n];
            for (int i = 0; i < n; ++i) {
                longArray[i] = this.getInt64(null);
            }
            return longArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedLong getUInt64(String string) throws DecodingException {
        try {
            return UnsignedLong.getFromBits(this.in.getLong());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 8) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            UnsignedLong[] unsignedLongArray = new UnsignedLong[n];
            for (int i = 0; i < n; ++i) {
                unsignedLongArray[i] = this.getUInt64(null);
            }
            return unsignedLongArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Float getFloat(String string) throws DecodingException {
        try {
            return Float.valueOf(this.in.getFloat());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Float[] floatArray = new Float[n];
            for (int i = 0; i < n; ++i) {
                floatArray[i] = this.getFloat(null);
            }
            return floatArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Double getDouble(String string) throws DecodingException {
        try {
            return this.in.getDouble();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 8) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Double[] doubleArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                doubleArray[i] = this.getDouble(null);
            }
            return doubleArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public String getString(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertStringLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            byte[] byArray = new byte[n];
            this.in.get(byArray);
            return new String(byArray, UTF8);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.getString(null);
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DateTime getDateTime(String string) throws DecodingException {
        try {
            long l = this.in.getLong();
            DateTime dateTime = new DateTime(l);
            if (dateTime.compareTo(DateTime.MAX_VALUE) > 0) {
                return DateTime.MAX_VALUE;
            }
            if (dateTime.compareTo(DateTime.MIN_VALUE) < 0) {
                return DateTime.MIN_VALUE;
            }
            return dateTime;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 8) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            DateTime[] dateTimeArray = new DateTime[n];
            for (int i = 0; i < n; ++i) {
                dateTimeArray[i] = this.getDateTime(null);
            }
            return dateTimeArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UUID getGuid(String string) throws DecodingException {
        try {
            int n;
            byte[] byArray = new byte[16];
            byArray[3] = this.in.get();
            byArray[2] = this.in.get();
            byArray[1] = this.in.get();
            byArray[0] = this.in.get();
            byArray[5] = this.in.get();
            byArray[4] = this.in.get();
            byArray[7] = this.in.get();
            byArray[6] = this.in.get();
            for (int i = 8; i < 16; ++i) {
                byArray[i] = this.in.get();
            }
            long l = 0L;
            long l2 = 0L;
            for (n = 0; n < 8; ++n) {
                l = l << 8 | (long)(byArray[n] & 0xFF);
            }
            for (n = 8; n < 16; ++n) {
                l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
            }
            return new UUID(l, l2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 16) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            UUID[] uUIDArray = new UUID[n];
            for (int i = 0; i < n; ++i) {
                uUIDArray[i] = this.getGuid(null);
            }
            return uUIDArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public byte[] getByteString(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertByteStringLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            byte[] byArray = new byte[n];
            this.in.get(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public byte[][] getByteStringArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            byte[][] byArrayArray = new byte[n][];
            for (int i = 0; i < n; ++i) {
                byArrayArray[i] = this.getByteString(null);
            }
            return byArrayArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public XmlElement getXmlElement(String string) throws DecodingException {
        byte[] byArray = this.getByteString(string);
        if (byArray == null) {
            return null;
        }
        return new XmlElement(byArray);
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            XmlElement[] xmlElementArray = new XmlElement[n];
            for (int i = 0; i < n; ++i) {
                xmlElementArray[i] = this.getXmlElement(null);
            }
            return xmlElementArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public NodeId getNodeId(String string) throws DecodingException {
        try {
            NodeId nodeId;
            byte by = this.in.get();
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            int n = 0;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n = 0;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.in.get() & 0xFF);
                nodeId = new NodeId(n, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n = this.in.get() & 0xFF;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.in.getShort() & 0xFFFF);
                nodeId = new NodeId(n, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n = this.in.getShort() & 0xFFFF;
                UnsignedInteger unsignedInteger = this.getUInt32(null);
                nodeId = new NodeId(n, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.String) {
                n = this.in.getShort() & 0xFFFF;
                String string2 = this.getString(null);
                nodeId = new NodeId(n, string2);
            } else if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n = this.in.getShort() & 0xFFFF;
                byte[] byArray = this.getByteString(null);
                nodeId = new NodeId(n, byArray);
            } else if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n = this.in.getShort() & 0xFFFF;
                UUID uUID = this.getGuid(null);
                nodeId = new NodeId(n, uUID);
            } else {
                throw new DecodingException("Unsupported NodeId Encoding byte " + (Object)((Object)nodeIdEncoding));
            }
            return nodeId;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 2) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            NodeId[] nodeIdArray = new NodeId[n];
            for (int i = 0; i < n; ++i) {
                nodeIdArray[i] = this.getNodeId(null);
            }
            return nodeIdArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public ExpandedNodeId getExpandedNodeId(String string) throws DecodingException {
        try {
            byte by = this.in.get();
            boolean bl = (by & 0x40) == 64;
            boolean bl2 = (by & 0x80) == 128;
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by & 0x3F);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            Object object = null;
            int n = 0;
            String string2 = null;
            UnsignedInteger unsignedInteger = null;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n = 0;
                object = new UnsignedInteger(this.in.get());
            }
            if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n = this.in.get() & 0xFF;
                object = new UnsignedInteger(this.in.getShort() & 0xFFFF);
            }
            if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n = this.in.getShort() & 0xFFFF;
                object = UnsignedInteger.getFromBits(this.in.getInt());
            }
            if (nodeIdEncoding == NodeIdEncoding.String) {
                n = this.in.getShort() & 0xFFFF;
                object = this.getString(null);
            }
            if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n = this.in.getShort() & 0xFFFF;
                object = this.getByteString(null);
            }
            if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n = this.in.getShort() & 0xFFFF;
                object = this.getGuid(null);
            }
            if (bl2) {
                string2 = this.getString(null);
            }
            if (bl) {
                unsignedInteger = this.getUInt32(null);
            }
            if (string2 != null) {
                return new ExpandedNodeId(unsignedInteger, string2, object);
            }
            return new ExpandedNodeId(unsignedInteger, n, object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 2) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            ExpandedNodeId[] expandedNodeIdArray = new ExpandedNodeId[n];
            for (int i = 0; i < n; ++i) {
                expandedNodeIdArray[i] = this.getExpandedNodeId(null);
            }
            return expandedNodeIdArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public StatusCode getStatusCode(String string) throws DecodingException {
        return new StatusCode(this.getUInt32(null));
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            StatusCode[] statusCodeArray = new StatusCode[n];
            for (int i = 0; i < n; ++i) {
                statusCodeArray[i] = this.getStatusCode(null);
            }
            return statusCodeArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public QualifiedName getQualifiedName(String string) throws DecodingException {
        UnsignedShort unsignedShort = this.getUInt16(null);
        String string2 = this.getString(null);
        if (string2 == null) {
            return new QualifiedName(unsignedShort, null);
        }
        return new QualifiedName(unsignedShort, string2);
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 6) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            QualifiedName[] qualifiedNameArray = new QualifiedName[n];
            for (int i = 0; i < n; ++i) {
                qualifiedNameArray[i] = this.getQualifiedName(null);
            }
            return qualifiedNameArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public LocalizedText getLocalizedText(String string) throws DecodingException {
        try {
            byte by = this.in.get();
            String string2 = null;
            String string3 = null;
            if ((by & 1) == 1) {
                string2 = this.getString(null);
            }
            if ((by & 2) == 2) {
                string3 = this.getString(null);
            }
            return new LocalizedText(string3, string2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            LocalizedText[] localizedTextArray = new LocalizedText[n];
            for (int i = 0; i < n; ++i) {
                localizedTextArray[i] = this.getLocalizedText(null);
            }
            return localizedTextArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Structure getStructure(String string) throws DecodingException {
        try {
            NodeId nodeId = this.getNodeId(null);
            byte by = this.in.get();
            if (by == 0) {
                return null;
            }
            if (by == 1) {
                Class<? extends IEncodeable> clazz = this.ctx.getEncodeableClass(nodeId);
                this.getInt32(null);
                return (Structure)this.getEncodeable(string, clazz);
            }
            if (by == 2) {
                throw new DecodingException("XML Decoder is not implemented");
            }
            throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Structure[] getStructureArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Structure[] structureArray = new Structure[n];
            for (int i = 0; i < n; ++i) {
                structureArray[i] = this.getStructure(null);
            }
            return structureArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws DecodingException {
        try {
            NodeId nodeId = this.getNodeId(null);
            ExpandedNodeId expandedNodeId = this.ctx.getNamespaceTable().toExpandedNodeId(nodeId);
            byte by = this.in.get();
            if (by == 0) {
                if (nodeId == null || nodeId.equals(NodeId.NULL)) {
                    return null;
                }
                return new ExtensionObject(expandedNodeId);
            }
            if (by == 1) {
                return new ExtensionObject(expandedNodeId, this.getByteString(null));
            }
            if (by == 2) {
                return new ExtensionObject(expandedNodeId, this.getXmlElement(null));
            }
            throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 3) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            ExtensionObject[] extensionObjectArray = new ExtensionObject[n];
            for (int i = 0; i < n; ++i) {
                extensionObjectArray[i] = this.getExtensionObject(null);
            }
            return extensionObjectArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DataValue getDataValue(String string) throws DecodingException {
        try {
            byte by = this.in.get();
            Variant variant = (by & 1) != 0 ? this.getVariant(null) : null;
            StatusCode statusCode = (by & 2) != 0 ? this.getStatusCode(null) : StatusCode.GOOD;
            DateTime dateTime = (by & 4) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort = (by & 0x10) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            DateTime dateTime2 = (by & 8) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort2 = (by & 0x20) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            DataValue[] dataValueArray = new DataValue[n];
            for (int i = 0; i < n; ++i) {
                dataValueArray[i] = this.getDataValue(null);
            }
            return dataValueArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        try {
            ExtensionObject[] extensionObjectArray;
            boolean bl;
            boolean bl2;
            byte by = this.in.get();
            int n = by & 0x3F;
            boolean bl3 = (by & 0x80) == 128;
            boolean bl4 = (by & 0x40) == 64;
            boolean bl5 = bl2 = n == 0;
            Object object = bl2 ? null : (bl3 ? this.getArrayObject(null, n) : this.getScalarObject(null, n));
            int[] nArray = bl4 ? this.getInt32Array_(null) : null;
            boolean bl6 = bl = bl3 && nArray != null && nArray.length > 1;
            if (object instanceof ExtensionObject) {
                extensionObjectArray = object;
                try {
                    object = extensionObjectArray.decode(this.ctx);
                }
                catch (DecodingException decodingException) {
                    logger.info("Failed to decode ExtensionObject: " + decodingException);
                    object = extensionObjectArray;
                }
            }
            if (bl3) {
                try {
                    if (bl) {
                        object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                    }
                    if (object instanceof ExtensionObject[]) {
                        extensionObjectArray = object;
                        try {
                            object = this.ctx.decode(extensionObjectArray);
                        }
                        catch (Exception exception) {
                            object = extensionObjectArray;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DecodingException("The length of ArrayDimensions-field does not match Value-field");
                }
            }
            return new Variant(object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Variant[] variantArray = new Variant[n];
            for (int i = 0; i < n; ++i) {
                variantArray[i] = this.getVariant(null);
            }
            return variantArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DiagnosticInfo getDiagnosticInfo(String string) throws DecodingException {
        try {
            byte by = this.in.get();
            Integer n = (by & 1) != 0 ? this.getInt32(null) : null;
            Integer n2 = (by & 2) != 0 ? this.getInt32(null) : null;
            Integer n3 = (by & 4) != 0 ? this.getInt32(null) : null;
            Integer n4 = (by & 8) != 0 ? this.getInt32(null) : null;
            String string2 = (by & 0x10) != 0 ? this.getString(null) : null;
            StatusCode statusCode = (by & 0x20) != 0 ? this.getStatusCode(null) : null;
            DiagnosticInfo diagnosticInfo = (by & 0x40) != 0 ? this.getDiagnosticInfo(null) : null;
            return new DiagnosticInfo(string2, diagnosticInfo, statusCode, n4, n3, n2, n);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)n > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[n];
            for (int i = 0; i < n; ++i) {
                diagnosticInfoArray[i] = this.getDiagnosticInfo(null);
            }
            return diagnosticInfoArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public <T extends Enumeration> T[] getEnumerationArray(String string, Class<T> clazz) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 4) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Object object = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                T t = this.getEnumeration(null, clazz);
                Array.set(object, i, t);
            }
            return (Enumeration[])object;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public <T extends Enumeration> T getEnumeration(String string, Class<T> clazz) throws DecodingException {
        try {
            int n = this.in.getInt();
            Method method = clazz.getMethod("valueOf", Integer.TYPE);
            return (T)((Enumeration)method.invoke(null, n));
        }
        catch (SecurityException securityException) {
            throw new DecodingException(securityException, "cannot decode " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DecodingException(noSuchMethodException, "cannot decode " + clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DecodingException(illegalArgumentException, "cannot decode " + clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DecodingException(illegalAccessException, "cannot decode " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DecodingException(invocationTargetException, "cannot decode " + clazz);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public <T extends IEncodeable> T[] getEncodeableArray(String string, Class<? extends T> clazz) throws DecodingException {
        try {
            int n = this.in.getInt();
            if (n == -1) {
                return null;
            }
            this.assertArrayLength(n);
            if ((long)(n * 2) > this.remaining()) {
                throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
            }
            Object object = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                IEncodeable iEncodeable = this.ctx.getEncodeableSerializer().getEncodeable(clazz, this);
                Array.set(object, i, iEncodeable);
            }
            return (IEncodeable[])object;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.toDecodingException(iOException);
        }
    }

    @Override
    public <T extends IEncodeable> T getEncodeable(String string, Class<? extends T> clazz) throws DecodingException {
        return (T)this.ctx.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    @Override
    public <T> T get(String string, Class<T> clazz) throws DecodingException {
        if (clazz.equals(Boolean.class)) {
            return (T)this.getBoolean(string);
        }
        if (clazz.equals(Byte.class)) {
            return (T)this.getSByte(string);
        }
        if (clazz.equals(UnsignedByte.class)) {
            return (T)this.getByte(string);
        }
        if (clazz.equals(Short.class)) {
            return (T)this.getInt16(string);
        }
        if (clazz.equals(UnsignedShort.class)) {
            return (T)this.getUInt16(string);
        }
        if (clazz.equals(Integer.class)) {
            return (T)this.getInt32(string);
        }
        if (clazz.equals(UnsignedInteger.class)) {
            return (T)this.getUInt32(string);
        }
        if (clazz.equals(Long.class)) {
            return (T)this.getInt64(string);
        }
        if (clazz.equals(UnsignedLong.class)) {
            return (T)this.getUInt64(string);
        }
        if (clazz.equals(Float.class)) {
            return (T)this.getFloat(string);
        }
        if (clazz.equals(Double.class)) {
            return (T)this.getDouble(string);
        }
        if (clazz.equals(String.class)) {
            return (T)this.getString(string);
        }
        if (clazz.equals(DateTime.class)) {
            return (T)this.getDateTime(string);
        }
        if (clazz.equals(UUID.class)) {
            return (T)this.getGuid(string);
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.getByteString(string);
        }
        if (clazz.equals(XmlElement.class)) {
            return (T)this.getXmlElement(string);
        }
        if (clazz.equals(NodeId.class)) {
            return (T)this.getNodeId(string);
        }
        if (clazz.equals(ExpandedNodeId.class)) {
            return (T)this.getExpandedNodeId(string);
        }
        if (clazz.equals(StatusCode.class)) {
            return (T)this.getStatusCode(string);
        }
        if (clazz.equals(QualifiedName.class)) {
            return (T)this.getQualifiedName(string);
        }
        if (clazz.equals(LocalizedText.class)) {
            return (T)this.getLocalizedText(string);
        }
        if (clazz.equals(ExtensionObject.class)) {
            return (T)this.getExtensionObject(string);
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return this.getEncodeable(string, clazz);
        }
        if (clazz.equals(DataValue.class)) {
            return (T)this.getDataValue(string);
        }
        if (clazz.equals(Variant.class)) {
            return (T)this.getVariant(string);
        }
        if (clazz.equals(Object.class)) {
            return (T)this.getVariant(string).getValue();
        }
        if (clazz.equals(DiagnosticInfo.class)) {
            return (T)this.getDiagnosticInfo(string);
        }
        if (clazz.equals(Boolean[].class)) {
            return (T)this.getBooleanArray(string);
        }
        if (clazz.equals(Byte[].class)) {
            return (T)this.getSByteArray(string);
        }
        if (clazz.equals(UnsignedByte[].class)) {
            return (T)this.getByteArray(string);
        }
        if (clazz.equals(Short[].class)) {
            return (T)this.getInt16Array(string);
        }
        if (clazz.equals(UnsignedShort[].class)) {
            return (T)this.getUInt16Array(string);
        }
        if (clazz.equals(Integer[].class)) {
            return (T)this.getInt32Array(string);
        }
        if (clazz.equals(UnsignedInteger[].class)) {
            return (T)this.getUInt32Array(string);
        }
        if (clazz.equals(Long[].class)) {
            return (T)this.getInt64Array(string);
        }
        if (clazz.equals(UnsignedLong[].class)) {
            return (T)this.getUInt64Array(string);
        }
        if (clazz.equals(Float[].class)) {
            return (T)this.getFloatArray(string);
        }
        if (clazz.equals(Double[].class)) {
            return (T)this.getDoubleArray(string);
        }
        if (clazz.equals(String[].class)) {
            return (T)this.getStringArray(string);
        }
        if (clazz.equals(DateTime[].class)) {
            return (T)this.getDateTimeArray(string);
        }
        if (clazz.equals(UUID[].class)) {
            return (T)this.getGuidArray(string);
        }
        if (clazz.equals(byte[][].class)) {
            return (T)this.getByteStringArray(string);
        }
        if (clazz.equals(XmlElement[].class)) {
            return (T)this.getXmlElementArray(string);
        }
        if (clazz.equals(NodeId[].class)) {
            return (T)this.getNodeIdArray(string);
        }
        if (clazz.equals(ExpandedNodeId[].class)) {
            return (T)this.getExpandedNodeIdArray(string);
        }
        if (clazz.equals(StatusCode[].class)) {
            return (T)this.getStatusCodeArray(string);
        }
        if (clazz.equals(QualifiedName[].class)) {
            return (T)this.getQualifiedNameArray(string);
        }
        if (clazz.equals(LocalizedText[].class)) {
            return (T)this.getLocalizedTextArray(string);
        }
        if (clazz.equals(ExtensionObject[].class)) {
            return (T)this.getExtensionObjectArray(string);
        }
        if (clazz.getComponentType() != null && Structure.class.isAssignableFrom(clazz.getComponentType())) {
            return (T)this.getEncodeableArray(string, clazz.getComponentType());
        }
        if (clazz.equals(DataValue[].class)) {
            return (T)this.getDataValueArray(string);
        }
        if (clazz.equals(Variant[].class)) {
            return (T)this.getVariantArray(string);
        }
        if (clazz.equals(Object[].class)) {
            Variant[] variantArray = this.getVariantArray(string);
            Object[] objectArray = new Object[variantArray.length];
            for (int i = 0; i < variantArray.length; ++i) {
                objectArray[i] = variantArray[i].getValue();
            }
            return (T)objectArray;
        }
        if (clazz.equals(DiagnosticInfo[].class)) {
            return (T)this.getDiagnosticInfoArray(string);
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return this.getEnumeration(string, clazz);
        }
        if (clazz.getComponentType() != null && Enumeration.class.isAssignableFrom(clazz.getComponentType())) {
            return (T)this.getEnumerationArray(string, clazz);
        }
        throw new DecodingException("Cannot decode " + clazz);
    }

    @Override
    public <T extends IEncodeable> T getMessage() throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        if (nodeId == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        Class<? extends IEncodeable> clazz = this.ctx.getEncodeableClass(nodeId);
        if (clazz == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        return (T)this.ctx.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    @Override
    public Object getScalarObject(String string, int n) throws DecodingException {
        switch (n) {
            case 1: {
                return this.getBoolean(null);
            }
            case 2: {
                return this.getSByte(null);
            }
            case 3: {
                return this.getByte(null);
            }
            case 4: {
                return this.getInt16(null);
            }
            case 5: {
                return this.getUInt16(null);
            }
            case 6: {
                return this.getInt32(null);
            }
            case 7: {
                return this.getUInt32(null);
            }
            case 8: {
                return this.getInt64(null);
            }
            case 9: {
                return this.getUInt64(null);
            }
            case 10: {
                return this.getFloat(null);
            }
            case 11: {
                return this.getDouble(null);
            }
            case 12: {
                return this.getString(null);
            }
            case 13: {
                return this.getDateTime(null);
            }
            case 14: {
                return this.getGuid(null);
            }
            case 15: {
                return this.getByteString(null);
            }
            case 16: {
                return this.getXmlElement(null);
            }
            case 17: {
                return this.getNodeId(null);
            }
            case 18: {
                return this.getExpandedNodeId(null);
            }
            case 19: {
                return this.getStatusCode(null);
            }
            case 20: {
                return this.getQualifiedName(null);
            }
            case 21: {
                return this.getLocalizedText(null);
            }
            case 22: {
                return this.getExtensionObject(null);
            }
            case 23: {
                return this.getDataValue(null);
            }
            case 24: {
                return this.getVariant(null);
            }
            case 25: {
                return this.getDiagnosticInfo(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n);
    }

    @Override
    public Object getArrayObject(String string, int n) throws DecodingException {
        switch (n) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n);
    }
}

