/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.InstanceNode;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ViewNode
extends InstanceNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ViewNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ViewNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ViewNode_Encoding_DefaultXml);
    protected Boolean ContainsNoLoops;
    protected UnsignedByte EventNotifier;

    public ViewNode() {
    }

    public ViewNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Boolean bl, UnsignedByte unsignedByte) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.ContainsNoLoops = bl;
        this.EventNotifier = unsignedByte;
    }

    public Boolean getContainsNoLoops() {
        return this.ContainsNoLoops;
    }

    public void setContainsNoLoops(Boolean bl) {
        this.ContainsNoLoops = bl;
    }

    public UnsignedByte getEventNotifier() {
        return this.EventNotifier;
    }

    public void setEventNotifier(UnsignedByte unsignedByte) {
        this.EventNotifier = unsignedByte;
    }

    @Override
    public ViewNode clone() {
        ViewNode viewNode = new ViewNode();
        viewNode.NodeId = this.NodeId;
        viewNode.NodeClass = this.NodeClass;
        viewNode.BrowseName = this.BrowseName;
        viewNode.DisplayName = this.DisplayName;
        viewNode.Description = this.Description;
        viewNode.WriteMask = this.WriteMask;
        viewNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            viewNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                viewNode.References[i] = this.References[i].clone();
            }
        }
        viewNode.ContainsNoLoops = this.ContainsNoLoops;
        viewNode.EventNotifier = this.EventNotifier;
        return viewNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewNode viewNode = (ViewNode)object;
        if (this.NodeId == null ? viewNode.NodeId != null : !this.NodeId.equals(viewNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? viewNode.NodeClass != null : !this.NodeClass.equals(viewNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? viewNode.BrowseName != null : !this.BrowseName.equals(viewNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? viewNode.DisplayName != null : !this.DisplayName.equals(viewNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? viewNode.Description != null : !this.Description.equals(viewNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? viewNode.WriteMask != null : !this.WriteMask.equals(viewNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? viewNode.UserWriteMask != null : !this.UserWriteMask.equals(viewNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? viewNode.References != null : !Arrays.equals(this.References, viewNode.References)) {
            return false;
        }
        if (this.ContainsNoLoops == null ? viewNode.ContainsNoLoops != null : !this.ContainsNoLoops.equals(viewNode.ContainsNoLoops)) {
            return false;
        }
        return !(this.EventNotifier == null ? viewNode.EventNotifier != null : !this.EventNotifier.equals(viewNode.EventNotifier));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.ContainsNoLoops == null ? 0 : this.ContainsNoLoops.hashCode());
        n = 31 * n + (this.EventNotifier == null ? 0 : this.EventNotifier.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ViewNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

