/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.utils.ObjectUtils;

public class VariableAttributes
extends NodeAttributes
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.VariableAttributes);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.VariableAttributes_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.VariableAttributes_Encoding_DefaultXml);
    protected Variant Value;
    protected NodeId DataType;
    protected Integer ValueRank;
    protected UnsignedInteger[] ArrayDimensions;
    protected UnsignedByte AccessLevel;
    protected UnsignedByte UserAccessLevel;
    protected Double MinimumSamplingInterval;
    protected Boolean Historizing;

    public VariableAttributes() {
    }

    public VariableAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Variant variant, NodeId nodeId, Integer n, UnsignedInteger[] unsignedIntegerArray, UnsignedByte unsignedByte, UnsignedByte unsignedByte2, Double d, Boolean bl) {
        super(unsignedInteger, localizedText, localizedText2, unsignedInteger2, unsignedInteger3);
        this.Value = variant;
        this.DataType = nodeId;
        this.ValueRank = n;
        this.ArrayDimensions = unsignedIntegerArray;
        this.AccessLevel = unsignedByte;
        this.UserAccessLevel = unsignedByte2;
        this.MinimumSamplingInterval = d;
        this.Historizing = bl;
    }

    public Variant getValue() {
        return this.Value;
    }

    public void setValue(Variant variant) {
        this.Value = variant;
    }

    public NodeId getDataType() {
        return this.DataType;
    }

    public void setDataType(NodeId nodeId) {
        this.DataType = nodeId;
    }

    public Integer getValueRank() {
        return this.ValueRank;
    }

    public void setValueRank(Integer n) {
        this.ValueRank = n;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.ArrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.ArrayDimensions = unsignedIntegerArray;
    }

    public UnsignedByte getAccessLevel() {
        return this.AccessLevel;
    }

    public void setAccessLevel(UnsignedByte unsignedByte) {
        this.AccessLevel = unsignedByte;
    }

    public UnsignedByte getUserAccessLevel() {
        return this.UserAccessLevel;
    }

    public void setUserAccessLevel(UnsignedByte unsignedByte) {
        this.UserAccessLevel = unsignedByte;
    }

    public Double getMinimumSamplingInterval() {
        return this.MinimumSamplingInterval;
    }

    public void setMinimumSamplingInterval(Double d) {
        this.MinimumSamplingInterval = d;
    }

    public Boolean getHistorizing() {
        return this.Historizing;
    }

    public void setHistorizing(Boolean bl) {
        this.Historizing = bl;
    }

    @Override
    public VariableAttributes clone() {
        VariableAttributes variableAttributes = new VariableAttributes();
        variableAttributes.SpecifiedAttributes = this.SpecifiedAttributes;
        variableAttributes.DisplayName = this.DisplayName;
        variableAttributes.Description = this.Description;
        variableAttributes.WriteMask = this.WriteMask;
        variableAttributes.UserWriteMask = this.UserWriteMask;
        variableAttributes.Value = this.Value;
        variableAttributes.DataType = this.DataType;
        variableAttributes.ValueRank = this.ValueRank;
        variableAttributes.ArrayDimensions = this.ArrayDimensions == null ? null : (UnsignedInteger[])this.ArrayDimensions.clone();
        variableAttributes.AccessLevel = this.AccessLevel;
        variableAttributes.UserAccessLevel = this.UserAccessLevel;
        variableAttributes.MinimumSamplingInterval = this.MinimumSamplingInterval;
        variableAttributes.Historizing = this.Historizing;
        return variableAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VariableAttributes variableAttributes = (VariableAttributes)object;
        if (this.SpecifiedAttributes == null ? variableAttributes.SpecifiedAttributes != null : !this.SpecifiedAttributes.equals(variableAttributes.SpecifiedAttributes)) {
            return false;
        }
        if (this.DisplayName == null ? variableAttributes.DisplayName != null : !this.DisplayName.equals(variableAttributes.DisplayName)) {
            return false;
        }
        if (this.Description == null ? variableAttributes.Description != null : !this.Description.equals(variableAttributes.Description)) {
            return false;
        }
        if (this.WriteMask == null ? variableAttributes.WriteMask != null : !this.WriteMask.equals(variableAttributes.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? variableAttributes.UserWriteMask != null : !this.UserWriteMask.equals(variableAttributes.UserWriteMask)) {
            return false;
        }
        if (this.Value == null ? variableAttributes.Value != null : !this.Value.equals(variableAttributes.Value)) {
            return false;
        }
        if (this.DataType == null ? variableAttributes.DataType != null : !this.DataType.equals(variableAttributes.DataType)) {
            return false;
        }
        if (this.ValueRank == null ? variableAttributes.ValueRank != null : !this.ValueRank.equals(variableAttributes.ValueRank)) {
            return false;
        }
        if (this.ArrayDimensions == null ? variableAttributes.ArrayDimensions != null : !Arrays.equals(this.ArrayDimensions, variableAttributes.ArrayDimensions)) {
            return false;
        }
        if (this.AccessLevel == null ? variableAttributes.AccessLevel != null : !this.AccessLevel.equals(variableAttributes.AccessLevel)) {
            return false;
        }
        if (this.UserAccessLevel == null ? variableAttributes.UserAccessLevel != null : !this.UserAccessLevel.equals(variableAttributes.UserAccessLevel)) {
            return false;
        }
        if (this.MinimumSamplingInterval == null ? variableAttributes.MinimumSamplingInterval != null : !this.MinimumSamplingInterval.equals(variableAttributes.MinimumSamplingInterval)) {
            return false;
        }
        return !(this.Historizing == null ? variableAttributes.Historizing != null : !this.Historizing.equals(variableAttributes.Historizing));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.SpecifiedAttributes == null ? 0 : this.SpecifiedAttributes.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.Value == null ? 0 : this.Value.hashCode());
        n = 31 * n + (this.DataType == null ? 0 : this.DataType.hashCode());
        n = 31 * n + (this.ValueRank == null ? 0 : this.ValueRank.hashCode());
        n = 31 * n + (this.ArrayDimensions == null ? 0 : Arrays.hashCode(this.ArrayDimensions));
        n = 31 * n + (this.AccessLevel == null ? 0 : this.AccessLevel.hashCode());
        n = 31 * n + (this.UserAccessLevel == null ? 0 : this.UserAccessLevel.hashCode());
        n = 31 * n + (this.MinimumSamplingInterval == null ? 0 : this.MinimumSamplingInterval.hashCode());
        n = 31 * n + (this.Historizing == null ? 0 : this.Historizing.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "VariableAttributes: " + ObjectUtils.printFieldsDeep(this);
    }
}

