/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.core.TypeNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ReferenceTypeNode
extends TypeNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ReferenceTypeNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ReferenceTypeNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ReferenceTypeNode_Encoding_DefaultXml);
    protected Boolean IsAbstract;
    protected Boolean Symmetric;
    protected LocalizedText InverseName;

    public ReferenceTypeNode() {
    }

    public ReferenceTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Boolean bl, Boolean bl2, LocalizedText localizedText3) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.IsAbstract = bl;
        this.Symmetric = bl2;
        this.InverseName = localizedText3;
    }

    public Boolean getIsAbstract() {
        return this.IsAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.IsAbstract = bl;
    }

    public Boolean getSymmetric() {
        return this.Symmetric;
    }

    public void setSymmetric(Boolean bl) {
        this.Symmetric = bl;
    }

    public LocalizedText getInverseName() {
        return this.InverseName;
    }

    public void setInverseName(LocalizedText localizedText) {
        this.InverseName = localizedText;
    }

    @Override
    public ReferenceTypeNode clone() {
        ReferenceTypeNode referenceTypeNode = new ReferenceTypeNode();
        referenceTypeNode.NodeId = this.NodeId;
        referenceTypeNode.NodeClass = this.NodeClass;
        referenceTypeNode.BrowseName = this.BrowseName;
        referenceTypeNode.DisplayName = this.DisplayName;
        referenceTypeNode.Description = this.Description;
        referenceTypeNode.WriteMask = this.WriteMask;
        referenceTypeNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            referenceTypeNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                referenceTypeNode.References[i] = this.References[i].clone();
            }
        }
        referenceTypeNode.IsAbstract = this.IsAbstract;
        referenceTypeNode.Symmetric = this.Symmetric;
        referenceTypeNode.InverseName = this.InverseName;
        return referenceTypeNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceTypeNode referenceTypeNode = (ReferenceTypeNode)object;
        if (this.NodeId == null ? referenceTypeNode.NodeId != null : !this.NodeId.equals(referenceTypeNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? referenceTypeNode.NodeClass != null : !this.NodeClass.equals(referenceTypeNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? referenceTypeNode.BrowseName != null : !this.BrowseName.equals(referenceTypeNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? referenceTypeNode.DisplayName != null : !this.DisplayName.equals(referenceTypeNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? referenceTypeNode.Description != null : !this.Description.equals(referenceTypeNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? referenceTypeNode.WriteMask != null : !this.WriteMask.equals(referenceTypeNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? referenceTypeNode.UserWriteMask != null : !this.UserWriteMask.equals(referenceTypeNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? referenceTypeNode.References != null : !Arrays.equals(this.References, referenceTypeNode.References)) {
            return false;
        }
        if (this.IsAbstract == null ? referenceTypeNode.IsAbstract != null : !this.IsAbstract.equals(referenceTypeNode.IsAbstract)) {
            return false;
        }
        if (this.Symmetric == null ? referenceTypeNode.Symmetric != null : !this.Symmetric.equals(referenceTypeNode.Symmetric)) {
            return false;
        }
        return !(this.InverseName == null ? referenceTypeNode.InverseName != null : !this.InverseName.equals(referenceTypeNode.InverseName));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.IsAbstract == null ? 0 : this.IsAbstract.hashCode());
        n = 31 * n + (this.Symmetric == null ? 0 : this.Symmetric.hashCode());
        n = 31 * n + (this.InverseName == null ? 0 : this.InverseName.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ReferenceTypeNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

