/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.AggregateConfiguration;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ReadProcessedDetails
extends HistoryReadDetails
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ReadProcessedDetails);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ReadProcessedDetails_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ReadProcessedDetails_Encoding_DefaultXml);
    protected DateTime StartTime;
    protected DateTime EndTime;
    protected Double ProcessingInterval;
    protected NodeId[] AggregateType;
    protected AggregateConfiguration AggregateConfiguration;

    public ReadProcessedDetails() {
    }

    public ReadProcessedDetails(DateTime dateTime, DateTime dateTime2, Double d, NodeId[] nodeIdArray, AggregateConfiguration aggregateConfiguration) {
        this.StartTime = dateTime;
        this.EndTime = dateTime2;
        this.ProcessingInterval = d;
        this.AggregateType = nodeIdArray;
        this.AggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.StartTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.EndTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.EndTime = dateTime;
    }

    public Double getProcessingInterval() {
        return this.ProcessingInterval;
    }

    public void setProcessingInterval(Double d) {
        this.ProcessingInterval = d;
    }

    public NodeId[] getAggregateType() {
        return this.AggregateType;
    }

    public void setAggregateType(NodeId[] nodeIdArray) {
        this.AggregateType = nodeIdArray;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.AggregateConfiguration;
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.AggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public ReadProcessedDetails clone() {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails();
        readProcessedDetails.StartTime = this.StartTime;
        readProcessedDetails.EndTime = this.EndTime;
        readProcessedDetails.ProcessingInterval = this.ProcessingInterval;
        readProcessedDetails.AggregateType = this.AggregateType == null ? null : (NodeId[])this.AggregateType.clone();
        readProcessedDetails.AggregateConfiguration = this.AggregateConfiguration == null ? null : this.AggregateConfiguration.clone();
        return readProcessedDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadProcessedDetails readProcessedDetails = (ReadProcessedDetails)object;
        if (this.StartTime == null ? readProcessedDetails.StartTime != null : !this.StartTime.equals(readProcessedDetails.StartTime)) {
            return false;
        }
        if (this.EndTime == null ? readProcessedDetails.EndTime != null : !this.EndTime.equals(readProcessedDetails.EndTime)) {
            return false;
        }
        if (this.ProcessingInterval == null ? readProcessedDetails.ProcessingInterval != null : !this.ProcessingInterval.equals(readProcessedDetails.ProcessingInterval)) {
            return false;
        }
        if (this.AggregateType == null ? readProcessedDetails.AggregateType != null : !Arrays.equals(this.AggregateType, readProcessedDetails.AggregateType)) {
            return false;
        }
        return !(this.AggregateConfiguration == null ? readProcessedDetails.AggregateConfiguration != null : !this.AggregateConfiguration.equals(readProcessedDetails.AggregateConfiguration));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StartTime == null ? 0 : this.StartTime.hashCode());
        n = 31 * n + (this.EndTime == null ? 0 : this.EndTime.hashCode());
        n = 31 * n + (this.ProcessingInterval == null ? 0 : this.ProcessingInterval.hashCode());
        n = 31 * n + (this.AggregateType == null ? 0 : Arrays.hashCode(this.AggregateType));
        n = 31 * n + (this.AggregateConfiguration == null ? 0 : this.AggregateConfiguration.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ReadProcessedDetails: " + ObjectUtils.printFieldsDeep(this);
    }
}

