/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ParsingResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ParsingResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ParsingResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ParsingResult_Encoding_DefaultXml);
    protected StatusCode StatusCode;
    protected StatusCode[] DataStatusCodes;
    protected DiagnosticInfo[] DataDiagnosticInfos;

    public ParsingResult() {
    }

    public ParsingResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.StatusCode = statusCode;
        this.DataStatusCodes = statusCodeArray;
        this.DataDiagnosticInfos = diagnosticInfoArray;
    }

    public StatusCode getStatusCode() {
        return this.StatusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.StatusCode = statusCode;
    }

    public StatusCode[] getDataStatusCodes() {
        return this.DataStatusCodes;
    }

    public void setDataStatusCodes(StatusCode[] statusCodeArray) {
        this.DataStatusCodes = statusCodeArray;
    }

    public DiagnosticInfo[] getDataDiagnosticInfos() {
        return this.DataDiagnosticInfos;
    }

    public void setDataDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DataDiagnosticInfos = diagnosticInfoArray;
    }

    public ParsingResult clone() {
        ParsingResult parsingResult = new ParsingResult();
        parsingResult.StatusCode = this.StatusCode;
        parsingResult.DataStatusCodes = this.DataStatusCodes == null ? null : (StatusCode[])this.DataStatusCodes.clone();
        parsingResult.DataDiagnosticInfos = this.DataDiagnosticInfos == null ? null : (DiagnosticInfo[])this.DataDiagnosticInfos.clone();
        return parsingResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ParsingResult parsingResult = (ParsingResult)object;
        if (this.StatusCode == null ? parsingResult.StatusCode != null : !this.StatusCode.equals(parsingResult.StatusCode)) {
            return false;
        }
        if (this.DataStatusCodes == null ? parsingResult.DataStatusCodes != null : !Arrays.equals(this.DataStatusCodes, parsingResult.DataStatusCodes)) {
            return false;
        }
        return !(this.DataDiagnosticInfos == null ? parsingResult.DataDiagnosticInfos != null : !Arrays.equals(this.DataDiagnosticInfos, parsingResult.DataDiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StatusCode == null ? 0 : this.StatusCode.hashCode());
        n = 31 * n + (this.DataStatusCodes == null ? 0 : Arrays.hashCode(this.DataStatusCodes));
        n = 31 * n + (this.DataDiagnosticInfos == null ? 0 : Arrays.hashCode(this.DataDiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "ParsingResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

