/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum OpenFileMode implements Enumeration
{
    Read(1),
    Write(2),
    EraseExisiting(4),
    Append(8);

    public static final NodeId ID;
    public static EnumSet<OpenFileMode> NONE;
    public static EnumSet<OpenFileMode> ALL;
    private final int value;
    private static final Map<Integer, OpenFileMode> map;

    private OpenFileMode(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static OpenFileMode valueOf(int n) {
        return map.get(n);
    }

    public static OpenFileMode valueOf(Integer n) {
        return n == null ? null : OpenFileMode.valueOf((int)n);
    }

    public static OpenFileMode valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : OpenFileMode.valueOf(unsignedInteger.intValue());
    }

    public static OpenFileMode[] valueOf(int[] nArray) {
        OpenFileMode[] openFileModeArray = new OpenFileMode[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            openFileModeArray[i] = OpenFileMode.valueOf(nArray[i]);
        }
        return openFileModeArray;
    }

    public static OpenFileMode[] valueOf(Integer[] integerArray) {
        OpenFileMode[] openFileModeArray = new OpenFileMode[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            openFileModeArray[i] = OpenFileMode.valueOf(integerArray[i]);
        }
        return openFileModeArray;
    }

    public static OpenFileMode[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        OpenFileMode[] openFileModeArray = new OpenFileMode[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            openFileModeArray[i] = OpenFileMode.valueOf(unsignedIntegerArray[i]);
        }
        return openFileModeArray;
    }

    public static UnsignedInteger getMask(OpenFileMode ... openFileModeArray) {
        int n = 0;
        for (OpenFileMode openFileMode : openFileModeArray) {
            n |= openFileMode.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<OpenFileMode> collection) {
        int n = 0;
        for (OpenFileMode openFileMode : collection) {
            n |= openFileMode.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<OpenFileMode> getSet(UnsignedInteger unsignedInteger) {
        return OpenFileMode.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<OpenFileMode> getSet(int n) {
        ArrayList<OpenFileMode> arrayList = new ArrayList<OpenFileMode>();
        for (OpenFileMode openFileMode : OpenFileMode.values()) {
            if ((n & openFileMode.value) != openFileMode.value) continue;
            arrayList.add(openFileMode);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.OpenFileMode;
        NONE = EnumSet.noneOf(OpenFileMode.class);
        ALL = EnumSet.allOf(OpenFileMode.class);
        map = new HashMap<Integer, OpenFileMode>();
        for (OpenFileMode openFileMode : OpenFileMode.values()) {
            map.put(openFileMode.value, openFileMode);
        }
    }
}

