/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.QueryDataDescription;
import org.opcfoundation.ua.utils.ObjectUtils;

public class NodeTypeDescription
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.NodeTypeDescription);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.NodeTypeDescription_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.NodeTypeDescription_Encoding_DefaultXml);
    protected ExpandedNodeId TypeDefinitionNode;
    protected Boolean IncludeSubTypes;
    protected QueryDataDescription[] DataToReturn;

    public NodeTypeDescription() {
    }

    public NodeTypeDescription(ExpandedNodeId expandedNodeId, Boolean bl, QueryDataDescription[] queryDataDescriptionArray) {
        this.TypeDefinitionNode = expandedNodeId;
        this.IncludeSubTypes = bl;
        this.DataToReturn = queryDataDescriptionArray;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.TypeDefinitionNode;
    }

    public void setTypeDefinitionNode(ExpandedNodeId expandedNodeId) {
        this.TypeDefinitionNode = expandedNodeId;
    }

    public Boolean getIncludeSubTypes() {
        return this.IncludeSubTypes;
    }

    public void setIncludeSubTypes(Boolean bl) {
        this.IncludeSubTypes = bl;
    }

    public QueryDataDescription[] getDataToReturn() {
        return this.DataToReturn;
    }

    public void setDataToReturn(QueryDataDescription[] queryDataDescriptionArray) {
        this.DataToReturn = queryDataDescriptionArray;
    }

    public NodeTypeDescription clone() {
        NodeTypeDescription nodeTypeDescription = new NodeTypeDescription();
        nodeTypeDescription.TypeDefinitionNode = this.TypeDefinitionNode;
        nodeTypeDescription.IncludeSubTypes = this.IncludeSubTypes;
        if (this.DataToReturn != null) {
            nodeTypeDescription.DataToReturn = new QueryDataDescription[this.DataToReturn.length];
            for (int i = 0; i < this.DataToReturn.length; ++i) {
                nodeTypeDescription.DataToReturn[i] = this.DataToReturn[i].clone();
            }
        }
        return nodeTypeDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeTypeDescription nodeTypeDescription = (NodeTypeDescription)object;
        if (this.TypeDefinitionNode == null ? nodeTypeDescription.TypeDefinitionNode != null : !this.TypeDefinitionNode.equals(nodeTypeDescription.TypeDefinitionNode)) {
            return false;
        }
        if (this.IncludeSubTypes == null ? nodeTypeDescription.IncludeSubTypes != null : !this.IncludeSubTypes.equals(nodeTypeDescription.IncludeSubTypes)) {
            return false;
        }
        return !(this.DataToReturn == null ? nodeTypeDescription.DataToReturn != null : !Arrays.equals(this.DataToReturn, nodeTypeDescription.DataToReturn));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.TypeDefinitionNode == null ? 0 : this.TypeDefinitionNode.hashCode());
        n = 31 * n + (this.IncludeSubTypes == null ? 0 : this.IncludeSubTypes.hashCode());
        n = 31 * n + (this.DataToReturn == null ? 0 : Arrays.hashCode(this.DataToReturn));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "NodeTypeDescription: " + ObjectUtils.printFieldsDeep(this);
    }
}

