/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class NodeReference
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.NodeReference);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.NodeReference_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.NodeReference_Encoding_DefaultXml);
    protected NodeId NodeId;
    protected NodeId ReferenceTypeId;
    protected Boolean IsForward;
    protected NodeId[] ReferencedNodeIds;

    public NodeReference() {
    }

    public NodeReference(NodeId nodeId, NodeId nodeId2, Boolean bl, NodeId[] nodeIdArray) {
        this.NodeId = nodeId;
        this.ReferenceTypeId = nodeId2;
        this.IsForward = bl;
        this.ReferencedNodeIds = nodeIdArray;
    }

    public NodeId getNodeId() {
        return this.NodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.NodeId = nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.ReferenceTypeId;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.ReferenceTypeId = nodeId;
    }

    public Boolean getIsForward() {
        return this.IsForward;
    }

    public void setIsForward(Boolean bl) {
        this.IsForward = bl;
    }

    public NodeId[] getReferencedNodeIds() {
        return this.ReferencedNodeIds;
    }

    public void setReferencedNodeIds(NodeId[] nodeIdArray) {
        this.ReferencedNodeIds = nodeIdArray;
    }

    public NodeReference clone() {
        NodeReference nodeReference = new NodeReference();
        nodeReference.NodeId = this.NodeId;
        nodeReference.ReferenceTypeId = this.ReferenceTypeId;
        nodeReference.IsForward = this.IsForward;
        nodeReference.ReferencedNodeIds = this.ReferencedNodeIds == null ? null : (NodeId[])this.ReferencedNodeIds.clone();
        return nodeReference;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeReference nodeReference = (NodeReference)object;
        if (this.NodeId == null ? nodeReference.NodeId != null : !this.NodeId.equals(nodeReference.NodeId)) {
            return false;
        }
        if (this.ReferenceTypeId == null ? nodeReference.ReferenceTypeId != null : !this.ReferenceTypeId.equals(nodeReference.ReferenceTypeId)) {
            return false;
        }
        if (this.IsForward == null ? nodeReference.IsForward != null : !this.IsForward.equals(nodeReference.IsForward)) {
            return false;
        }
        return !(this.ReferencedNodeIds == null ? nodeReference.ReferencedNodeIds != null : !Arrays.equals(this.ReferencedNodeIds, nodeReference.ReferencedNodeIds));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.ReferenceTypeId == null ? 0 : this.ReferenceTypeId.hashCode());
        n = 31 * n + (this.IsForward == null ? 0 : this.IsForward.hashCode());
        n = 31 * n + (this.ReferencedNodeIds == null ? 0 : Arrays.hashCode(this.ReferencedNodeIds));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "NodeReference: " + ObjectUtils.printFieldsDeep(this);
    }
}

