/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.Node;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class InstanceNode
extends Node
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.InstanceNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.InstanceNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.InstanceNode_Encoding_DefaultXml);

    public InstanceNode() {
    }

    public InstanceNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
    }

    @Override
    public InstanceNode clone() {
        InstanceNode instanceNode = new InstanceNode();
        instanceNode.NodeId = this.NodeId;
        instanceNode.NodeClass = this.NodeClass;
        instanceNode.BrowseName = this.BrowseName;
        instanceNode.DisplayName = this.DisplayName;
        instanceNode.Description = this.Description;
        instanceNode.WriteMask = this.WriteMask;
        instanceNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            instanceNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                instanceNode.References[i] = this.References[i].clone();
            }
        }
        return instanceNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InstanceNode instanceNode = (InstanceNode)object;
        if (this.NodeId == null ? instanceNode.NodeId != null : !this.NodeId.equals(instanceNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? instanceNode.NodeClass != null : !this.NodeClass.equals(instanceNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? instanceNode.BrowseName != null : !this.BrowseName.equals(instanceNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? instanceNode.DisplayName != null : !this.DisplayName.equals(instanceNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? instanceNode.Description != null : !this.Description.equals(instanceNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? instanceNode.WriteMask != null : !this.WriteMask.equals(instanceNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? instanceNode.UserWriteMask != null : !this.UserWriteMask.equals(instanceNode.UserWriteMask)) {
            return false;
        }
        return !(this.References == null ? instanceNode.References != null : !Arrays.equals(this.References, instanceNode.References));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "InstanceNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

