/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.HistoryReadResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class HistoryReadResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.HistoryReadResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.HistoryReadResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.HistoryReadResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected HistoryReadResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public HistoryReadResponse() {
    }

    public HistoryReadResponse(ResponseHeader responseHeader, HistoryReadResult[] historyReadResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = historyReadResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public HistoryReadResult[] getResults() {
        return this.Results;
    }

    public void setResults(HistoryReadResult[] historyReadResultArray) {
        this.Results = historyReadResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public HistoryReadResponse clone() {
        HistoryReadResponse historyReadResponse = new HistoryReadResponse();
        ResponseHeader responseHeader = historyReadResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            historyReadResponse.Results = new HistoryReadResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                historyReadResponse.Results[i] = this.Results[i].clone();
            }
        }
        historyReadResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return historyReadResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadResponse historyReadResponse = (HistoryReadResponse)object;
        if (this.ResponseHeader == null ? historyReadResponse.ResponseHeader != null : !this.ResponseHeader.equals(historyReadResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? historyReadResponse.Results != null : !Arrays.equals(this.Results, historyReadResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? historyReadResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, historyReadResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

