/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.HistoryEventFieldList;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class HistoryEvent
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.HistoryEvent);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.HistoryEvent_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.HistoryEvent_Encoding_DefaultXml);
    protected HistoryEventFieldList[] Events;

    public HistoryEvent() {
    }

    public HistoryEvent(HistoryEventFieldList[] historyEventFieldListArray) {
        this.Events = historyEventFieldListArray;
    }

    public HistoryEventFieldList[] getEvents() {
        return this.Events;
    }

    public void setEvents(HistoryEventFieldList[] historyEventFieldListArray) {
        this.Events = historyEventFieldListArray;
    }

    public HistoryEvent clone() {
        HistoryEvent historyEvent = new HistoryEvent();
        if (this.Events != null) {
            historyEvent.Events = new HistoryEventFieldList[this.Events.length];
            for (int i = 0; i < this.Events.length; ++i) {
                historyEvent.Events[i] = this.Events[i].clone();
            }
        }
        return historyEvent;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryEvent historyEvent = (HistoryEvent)object;
        return !(this.Events == null ? historyEvent.Events != null : !Arrays.equals(this.Events, historyEvent.Events));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Events == null ? 0 : Arrays.hashCode(this.Events));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "HistoryEvent: " + ObjectUtils.printFieldsDeep(this);
    }
}

