/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum EnumeratedTestType implements Enumeration
{
    Red(1),
    Yellow(4),
    Green(5);

    public static final NodeId ID;
    public static EnumSet<EnumeratedTestType> NONE;
    public static EnumSet<EnumeratedTestType> ALL;
    private final int value;
    private static final Map<Integer, EnumeratedTestType> map;

    private EnumeratedTestType(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static EnumeratedTestType valueOf(int n) {
        return map.get(n);
    }

    public static EnumeratedTestType valueOf(Integer n) {
        return n == null ? null : EnumeratedTestType.valueOf((int)n);
    }

    public static EnumeratedTestType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : EnumeratedTestType.valueOf(unsignedInteger.intValue());
    }

    public static EnumeratedTestType[] valueOf(int[] nArray) {
        EnumeratedTestType[] enumeratedTestTypeArray = new EnumeratedTestType[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            enumeratedTestTypeArray[i] = EnumeratedTestType.valueOf(nArray[i]);
        }
        return enumeratedTestTypeArray;
    }

    public static EnumeratedTestType[] valueOf(Integer[] integerArray) {
        EnumeratedTestType[] enumeratedTestTypeArray = new EnumeratedTestType[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            enumeratedTestTypeArray[i] = EnumeratedTestType.valueOf(integerArray[i]);
        }
        return enumeratedTestTypeArray;
    }

    public static EnumeratedTestType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        EnumeratedTestType[] enumeratedTestTypeArray = new EnumeratedTestType[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            enumeratedTestTypeArray[i] = EnumeratedTestType.valueOf(unsignedIntegerArray[i]);
        }
        return enumeratedTestTypeArray;
    }

    public static UnsignedInteger getMask(EnumeratedTestType ... enumeratedTestTypeArray) {
        int n = 0;
        for (EnumeratedTestType enumeratedTestType : enumeratedTestTypeArray) {
            n |= enumeratedTestType.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<EnumeratedTestType> collection) {
        int n = 0;
        for (EnumeratedTestType enumeratedTestType : collection) {
            n |= enumeratedTestType.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<EnumeratedTestType> getSet(UnsignedInteger unsignedInteger) {
        return EnumeratedTestType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<EnumeratedTestType> getSet(int n) {
        ArrayList<EnumeratedTestType> arrayList = new ArrayList<EnumeratedTestType>();
        for (EnumeratedTestType enumeratedTestType : EnumeratedTestType.values()) {
            if ((n & enumeratedTestType.value) != enumeratedTestType.value) continue;
            arrayList.add(enumeratedTestType);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.EnumeratedTestType;
        NONE = EnumSet.noneOf(EnumeratedTestType.class);
        ALL = EnumSet.allOf(EnumeratedTestType.class);
        map = new HashMap<Integer, EnumeratedTestType>();
        for (EnumeratedTestType enumeratedTestType : EnumeratedTestType.values()) {
            map.put(enumeratedTestType.value, enumeratedTestType);
        }
    }
}

