/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.utils.ObjectUtils;

public class CreateSessionResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.CreateSessionResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.CreateSessionResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.CreateSessionResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected NodeId SessionId;
    protected NodeId AuthenticationToken;
    protected Double RevisedSessionTimeout;
    protected byte[] ServerNonce;
    protected byte[] ServerCertificate;
    protected EndpointDescription[] ServerEndpoints;
    protected SignedSoftwareCertificate[] ServerSoftwareCertificates;
    protected SignatureData ServerSignature;
    protected UnsignedInteger MaxRequestMessageSize;

    public CreateSessionResponse() {
    }

    public CreateSessionResponse(ResponseHeader responseHeader, NodeId nodeId, NodeId nodeId2, Double d, byte[] byArray, byte[] byArray2, EndpointDescription[] endpointDescriptionArray, SignedSoftwareCertificate[] signedSoftwareCertificateArray, SignatureData signatureData, UnsignedInteger unsignedInteger) {
        this.ResponseHeader = responseHeader;
        this.SessionId = nodeId;
        this.AuthenticationToken = nodeId2;
        this.RevisedSessionTimeout = d;
        this.ServerNonce = byArray;
        this.ServerCertificate = byArray2;
        this.ServerEndpoints = endpointDescriptionArray;
        this.ServerSoftwareCertificates = signedSoftwareCertificateArray;
        this.ServerSignature = signatureData;
        this.MaxRequestMessageSize = unsignedInteger;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public NodeId getSessionId() {
        return this.SessionId;
    }

    public void setSessionId(NodeId nodeId) {
        this.SessionId = nodeId;
    }

    public NodeId getAuthenticationToken() {
        return this.AuthenticationToken;
    }

    public void setAuthenticationToken(NodeId nodeId) {
        this.AuthenticationToken = nodeId;
    }

    public Double getRevisedSessionTimeout() {
        return this.RevisedSessionTimeout;
    }

    public void setRevisedSessionTimeout(Double d) {
        this.RevisedSessionTimeout = d;
    }

    public byte[] getServerNonce() {
        return this.ServerNonce;
    }

    public void setServerNonce(byte[] byArray) {
        this.ServerNonce = byArray;
    }

    public byte[] getServerCertificate() {
        return this.ServerCertificate;
    }

    public void setServerCertificate(byte[] byArray) {
        this.ServerCertificate = byArray;
    }

    public EndpointDescription[] getServerEndpoints() {
        return this.ServerEndpoints;
    }

    public void setServerEndpoints(EndpointDescription[] endpointDescriptionArray) {
        this.ServerEndpoints = endpointDescriptionArray;
    }

    public SignedSoftwareCertificate[] getServerSoftwareCertificates() {
        return this.ServerSoftwareCertificates;
    }

    public void setServerSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) {
        this.ServerSoftwareCertificates = signedSoftwareCertificateArray;
    }

    public SignatureData getServerSignature() {
        return this.ServerSignature;
    }

    public void setServerSignature(SignatureData signatureData) {
        this.ServerSignature = signatureData;
    }

    public UnsignedInteger getMaxRequestMessageSize() {
        return this.MaxRequestMessageSize;
    }

    public void setMaxRequestMessageSize(UnsignedInteger unsignedInteger) {
        this.MaxRequestMessageSize = unsignedInteger;
    }

    public CreateSessionResponse clone() {
        int n;
        CreateSessionResponse createSessionResponse = new CreateSessionResponse();
        createSessionResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        createSessionResponse.SessionId = this.SessionId;
        createSessionResponse.AuthenticationToken = this.AuthenticationToken;
        createSessionResponse.RevisedSessionTimeout = this.RevisedSessionTimeout;
        createSessionResponse.ServerNonce = this.ServerNonce;
        createSessionResponse.ServerCertificate = this.ServerCertificate;
        if (this.ServerEndpoints != null) {
            createSessionResponse.ServerEndpoints = new EndpointDescription[this.ServerEndpoints.length];
            for (n = 0; n < this.ServerEndpoints.length; ++n) {
                createSessionResponse.ServerEndpoints[n] = this.ServerEndpoints[n].clone();
            }
        }
        if (this.ServerSoftwareCertificates != null) {
            createSessionResponse.ServerSoftwareCertificates = new SignedSoftwareCertificate[this.ServerSoftwareCertificates.length];
            for (n = 0; n < this.ServerSoftwareCertificates.length; ++n) {
                createSessionResponse.ServerSoftwareCertificates[n] = this.ServerSoftwareCertificates[n].clone();
            }
        }
        createSessionResponse.ServerSignature = this.ServerSignature == null ? null : this.ServerSignature.clone();
        createSessionResponse.MaxRequestMessageSize = this.MaxRequestMessageSize;
        return createSessionResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CreateSessionResponse createSessionResponse = (CreateSessionResponse)object;
        if (this.ResponseHeader == null ? createSessionResponse.ResponseHeader != null : !this.ResponseHeader.equals(createSessionResponse.ResponseHeader)) {
            return false;
        }
        if (this.SessionId == null ? createSessionResponse.SessionId != null : !this.SessionId.equals(createSessionResponse.SessionId)) {
            return false;
        }
        if (this.AuthenticationToken == null ? createSessionResponse.AuthenticationToken != null : !this.AuthenticationToken.equals(createSessionResponse.AuthenticationToken)) {
            return false;
        }
        if (this.RevisedSessionTimeout == null ? createSessionResponse.RevisedSessionTimeout != null : !this.RevisedSessionTimeout.equals(createSessionResponse.RevisedSessionTimeout)) {
            return false;
        }
        if (this.ServerNonce == null ? createSessionResponse.ServerNonce != null : !this.ServerNonce.equals(createSessionResponse.ServerNonce)) {
            return false;
        }
        if (this.ServerCertificate == null ? createSessionResponse.ServerCertificate != null : !this.ServerCertificate.equals(createSessionResponse.ServerCertificate)) {
            return false;
        }
        if (this.ServerEndpoints == null ? createSessionResponse.ServerEndpoints != null : !Arrays.equals(this.ServerEndpoints, createSessionResponse.ServerEndpoints)) {
            return false;
        }
        if (this.ServerSoftwareCertificates == null ? createSessionResponse.ServerSoftwareCertificates != null : !Arrays.equals(this.ServerSoftwareCertificates, createSessionResponse.ServerSoftwareCertificates)) {
            return false;
        }
        if (this.ServerSignature == null ? createSessionResponse.ServerSignature != null : !this.ServerSignature.equals(createSessionResponse.ServerSignature)) {
            return false;
        }
        return !(this.MaxRequestMessageSize == null ? createSessionResponse.MaxRequestMessageSize != null : !this.MaxRequestMessageSize.equals(createSessionResponse.MaxRequestMessageSize));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.SessionId == null ? 0 : this.SessionId.hashCode());
        n = 31 * n + (this.AuthenticationToken == null ? 0 : this.AuthenticationToken.hashCode());
        n = 31 * n + (this.RevisedSessionTimeout == null ? 0 : this.RevisedSessionTimeout.hashCode());
        n = 31 * n + (this.ServerNonce == null ? 0 : this.ServerNonce.hashCode());
        n = 31 * n + (this.ServerCertificate == null ? 0 : this.ServerCertificate.hashCode());
        n = 31 * n + (this.ServerEndpoints == null ? 0 : Arrays.hashCode(this.ServerEndpoints));
        n = 31 * n + (this.ServerSoftwareCertificates == null ? 0 : Arrays.hashCode(this.ServerSoftwareCertificates));
        n = 31 * n + (this.ServerSignature == null ? 0 : this.ServerSignature.hashCode());
        n = 31 * n + (this.MaxRequestMessageSize == null ? 0 : this.MaxRequestMessageSize.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

