/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class CallMethodResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.CallMethodResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.CallMethodResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.CallMethodResult_Encoding_DefaultXml);
    protected StatusCode StatusCode;
    protected StatusCode[] InputArgumentResults;
    protected DiagnosticInfo[] InputArgumentDiagnosticInfos;
    protected Variant[] OutputArguments;

    public CallMethodResult() {
    }

    public CallMethodResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray) {
        this.StatusCode = statusCode;
        this.InputArgumentResults = statusCodeArray;
        this.InputArgumentDiagnosticInfos = diagnosticInfoArray;
        this.OutputArguments = variantArray;
    }

    public StatusCode getStatusCode() {
        return this.StatusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.StatusCode = statusCode;
    }

    public StatusCode[] getInputArgumentResults() {
        return this.InputArgumentResults;
    }

    public void setInputArgumentResults(StatusCode[] statusCodeArray) {
        this.InputArgumentResults = statusCodeArray;
    }

    public DiagnosticInfo[] getInputArgumentDiagnosticInfos() {
        return this.InputArgumentDiagnosticInfos;
    }

    public void setInputArgumentDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.InputArgumentDiagnosticInfos = diagnosticInfoArray;
    }

    public Variant[] getOutputArguments() {
        return this.OutputArguments;
    }

    public void setOutputArguments(Variant[] variantArray) {
        this.OutputArguments = variantArray;
    }

    public CallMethodResult clone() {
        CallMethodResult callMethodResult = new CallMethodResult();
        callMethodResult.StatusCode = this.StatusCode;
        callMethodResult.InputArgumentResults = this.InputArgumentResults == null ? null : (StatusCode[])this.InputArgumentResults.clone();
        callMethodResult.InputArgumentDiagnosticInfos = this.InputArgumentDiagnosticInfos == null ? null : (DiagnosticInfo[])this.InputArgumentDiagnosticInfos.clone();
        callMethodResult.OutputArguments = this.OutputArguments == null ? null : (Variant[])this.OutputArguments.clone();
        return callMethodResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallMethodResult callMethodResult = (CallMethodResult)object;
        if (this.StatusCode == null ? callMethodResult.StatusCode != null : !this.StatusCode.equals(callMethodResult.StatusCode)) {
            return false;
        }
        if (this.InputArgumentResults == null ? callMethodResult.InputArgumentResults != null : !Arrays.equals(this.InputArgumentResults, callMethodResult.InputArgumentResults)) {
            return false;
        }
        if (this.InputArgumentDiagnosticInfos == null ? callMethodResult.InputArgumentDiagnosticInfos != null : !Arrays.equals(this.InputArgumentDiagnosticInfos, callMethodResult.InputArgumentDiagnosticInfos)) {
            return false;
        }
        return !(this.OutputArguments == null ? callMethodResult.OutputArguments != null : !Arrays.equals(this.OutputArguments, callMethodResult.OutputArguments));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StatusCode == null ? 0 : this.StatusCode.hashCode());
        n = 31 * n + (this.InputArgumentResults == null ? 0 : Arrays.hashCode(this.InputArgumentResults));
        n = 31 * n + (this.InputArgumentDiagnosticInfos == null ? 0 : Arrays.hashCode(this.InputArgumentDiagnosticInfos));
        n = 31 * n + (this.OutputArguments == null ? 0 : Arrays.hashCode(this.OutputArguments));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "CallMethodResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

