/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.BrowseResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowseResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowseResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowseResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowseResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected BrowseResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public BrowseResponse() {
    }

    public BrowseResponse(ResponseHeader responseHeader, BrowseResult[] browseResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = browseResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public BrowseResult[] getResults() {
        return this.Results;
    }

    public void setResults(BrowseResult[] browseResultArray) {
        this.Results = browseResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public BrowseResponse clone() {
        BrowseResponse browseResponse = new BrowseResponse();
        ResponseHeader responseHeader = browseResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            browseResponse.Results = new BrowseResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                browseResponse.Results[i] = this.Results[i].clone();
            }
        }
        browseResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return browseResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseResponse browseResponse = (BrowseResponse)object;
        if (this.ResponseHeader == null ? browseResponse.ResponseHeader != null : !this.ResponseHeader.equals(browseResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? browseResponse.Results != null : !Arrays.equals(this.Results, browseResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? browseResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, browseResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

