/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowsePathResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowsePathResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowsePathResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowsePathResult_Encoding_DefaultXml);
    protected StatusCode StatusCode;
    protected BrowsePathTarget[] Targets;

    public BrowsePathResult() {
    }

    public BrowsePathResult(StatusCode statusCode, BrowsePathTarget[] browsePathTargetArray) {
        this.StatusCode = statusCode;
        this.Targets = browsePathTargetArray;
    }

    public StatusCode getStatusCode() {
        return this.StatusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.StatusCode = statusCode;
    }

    public BrowsePathTarget[] getTargets() {
        return this.Targets;
    }

    public void setTargets(BrowsePathTarget[] browsePathTargetArray) {
        this.Targets = browsePathTargetArray;
    }

    public BrowsePathResult clone() {
        BrowsePathResult browsePathResult = new BrowsePathResult();
        browsePathResult.StatusCode = this.StatusCode;
        if (this.Targets != null) {
            browsePathResult.Targets = new BrowsePathTarget[this.Targets.length];
            for (int i = 0; i < this.Targets.length; ++i) {
                browsePathResult.Targets[i] = this.Targets[i].clone();
            }
        }
        return browsePathResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePathResult browsePathResult = (BrowsePathResult)object;
        if (this.StatusCode == null ? browsePathResult.StatusCode != null : !this.StatusCode.equals(browsePathResult.StatusCode)) {
            return false;
        }
        return !(this.Targets == null ? browsePathResult.Targets != null : !Arrays.equals(this.Targets, browsePathResult.Targets));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StatusCode == null ? 0 : this.StatusCode.hashCode());
        n = 31 * n + (this.Targets == null ? 0 : Arrays.hashCode(this.Targets));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "BrowsePathResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

