/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.BrowseResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowseNextResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowseNextResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowseNextResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowseNextResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected BrowseResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public BrowseNextResponse() {
    }

    public BrowseNextResponse(ResponseHeader responseHeader, BrowseResult[] browseResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = browseResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public BrowseResult[] getResults() {
        return this.Results;
    }

    public void setResults(BrowseResult[] browseResultArray) {
        this.Results = browseResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public BrowseNextResponse clone() {
        BrowseNextResponse browseNextResponse = new BrowseNextResponse();
        ResponseHeader responseHeader = browseNextResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            browseNextResponse.Results = new BrowseResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                browseNextResponse.Results[i] = this.Results[i].clone();
            }
        }
        browseNextResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return browseNextResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseNextResponse browseNextResponse = (BrowseNextResponse)object;
        if (this.ResponseHeader == null ? browseNextResponse.ResponseHeader != null : !this.ResponseHeader.equals(browseNextResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? browseNextResponse.Results != null : !Arrays.equals(this.Results, browseNextResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? browseNextResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, browseNextResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

