/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class Argument
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.Argument);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.Argument_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.Argument_Encoding_DefaultXml);
    protected String Name;
    protected NodeId DataType;
    protected Integer ValueRank;
    protected UnsignedInteger[] ArrayDimensions;
    protected LocalizedText Description;

    public Argument() {
    }

    public Argument(String string, NodeId nodeId, Integer n, UnsignedInteger[] unsignedIntegerArray, LocalizedText localizedText) {
        this.Name = string;
        this.DataType = nodeId;
        this.ValueRank = n;
        this.ArrayDimensions = unsignedIntegerArray;
        this.Description = localizedText;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = string;
    }

    public NodeId getDataType() {
        return this.DataType;
    }

    public void setDataType(NodeId nodeId) {
        this.DataType = nodeId;
    }

    public Integer getValueRank() {
        return this.ValueRank;
    }

    public void setValueRank(Integer n) {
        this.ValueRank = n;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.ArrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.ArrayDimensions = unsignedIntegerArray;
    }

    public LocalizedText getDescription() {
        return this.Description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.Description = localizedText;
    }

    public Argument clone() {
        Argument argument = new Argument();
        argument.Name = this.Name;
        argument.DataType = this.DataType;
        argument.ValueRank = this.ValueRank;
        argument.ArrayDimensions = this.ArrayDimensions == null ? null : (UnsignedInteger[])this.ArrayDimensions.clone();
        argument.Description = this.Description;
        return argument;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Argument argument = (Argument)object;
        if (this.Name == null ? argument.Name != null : !this.Name.equals(argument.Name)) {
            return false;
        }
        if (this.DataType == null ? argument.DataType != null : !this.DataType.equals(argument.DataType)) {
            return false;
        }
        if (this.ValueRank == null ? argument.ValueRank != null : !this.ValueRank.equals(argument.ValueRank)) {
            return false;
        }
        if (this.ArrayDimensions == null ? argument.ArrayDimensions != null : !Arrays.equals(this.ArrayDimensions, argument.ArrayDimensions)) {
            return false;
        }
        return !(this.Description == null ? argument.Description != null : !this.Description.equals(argument.Description));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Name == null ? 0 : this.Name.hashCode());
        n = 31 * n + (this.DataType == null ? 0 : this.DataType.hashCode());
        n = 31 * n + (this.ValueRank == null ? 0 : this.ValueRank.hashCode());
        n = 31 * n + (this.ArrayDimensions == null ? 0 : Arrays.hashCode(this.ArrayDimensions));
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "Argument: " + ObjectUtils.printFieldsDeep(this);
    }
}

