/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.AggregateConfiguration;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.utils.ObjectUtils;

public class AggregateFilterResult
extends MonitoringFilterResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.AggregateFilterResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.AggregateFilterResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.AggregateFilterResult_Encoding_DefaultXml);
    protected DateTime RevisedStartTime;
    protected Double RevisedProcessingInterval;
    protected AggregateConfiguration RevisedAggregateConfiguration;

    public AggregateFilterResult() {
    }

    public AggregateFilterResult(DateTime dateTime, Double d, AggregateConfiguration aggregateConfiguration) {
        this.RevisedStartTime = dateTime;
        this.RevisedProcessingInterval = d;
        this.RevisedAggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getRevisedStartTime() {
        return this.RevisedStartTime;
    }

    public void setRevisedStartTime(DateTime dateTime) {
        this.RevisedStartTime = dateTime;
    }

    public Double getRevisedProcessingInterval() {
        return this.RevisedProcessingInterval;
    }

    public void setRevisedProcessingInterval(Double d) {
        this.RevisedProcessingInterval = d;
    }

    public AggregateConfiguration getRevisedAggregateConfiguration() {
        return this.RevisedAggregateConfiguration;
    }

    public void setRevisedAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.RevisedAggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public AggregateFilterResult clone() {
        AggregateFilterResult aggregateFilterResult = new AggregateFilterResult();
        aggregateFilterResult.RevisedStartTime = this.RevisedStartTime;
        aggregateFilterResult.RevisedProcessingInterval = this.RevisedProcessingInterval;
        aggregateFilterResult.RevisedAggregateConfiguration = this.RevisedAggregateConfiguration == null ? null : this.RevisedAggregateConfiguration.clone();
        return aggregateFilterResult;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateFilterResult aggregateFilterResult = (AggregateFilterResult)object;
        if (this.RevisedStartTime == null ? aggregateFilterResult.RevisedStartTime != null : !this.RevisedStartTime.equals(aggregateFilterResult.RevisedStartTime)) {
            return false;
        }
        if (this.RevisedProcessingInterval == null ? aggregateFilterResult.RevisedProcessingInterval != null : !this.RevisedProcessingInterval.equals(aggregateFilterResult.RevisedProcessingInterval)) {
            return false;
        }
        return !(this.RevisedAggregateConfiguration == null ? aggregateFilterResult.RevisedAggregateConfiguration != null : !this.RevisedAggregateConfiguration.equals(aggregateFilterResult.RevisedAggregateConfiguration));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RevisedStartTime == null ? 0 : this.RevisedStartTime.hashCode());
        n = 31 * n + (this.RevisedProcessingInterval == null ? 0 : this.RevisedProcessingInterval.hashCode());
        n = 31 * n + (this.RevisedAggregateConfiguration == null ? 0 : this.RevisedAggregateConfiguration.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "AggregateFilterResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

