/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class AddReferencesRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.AddReferencesRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.AddReferencesRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.AddReferencesRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected AddReferencesItem[] ReferencesToAdd;

    public AddReferencesRequest() {
    }

    public AddReferencesRequest(RequestHeader requestHeader, AddReferencesItem[] addReferencesItemArray) {
        this.RequestHeader = requestHeader;
        this.ReferencesToAdd = addReferencesItemArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public AddReferencesItem[] getReferencesToAdd() {
        return this.ReferencesToAdd;
    }

    public void setReferencesToAdd(AddReferencesItem[] addReferencesItemArray) {
        this.ReferencesToAdd = addReferencesItemArray;
    }

    public AddReferencesRequest clone() {
        AddReferencesRequest addReferencesRequest = new AddReferencesRequest();
        RequestHeader requestHeader = addReferencesRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        if (this.ReferencesToAdd != null) {
            addReferencesRequest.ReferencesToAdd = new AddReferencesItem[this.ReferencesToAdd.length];
            for (int i = 0; i < this.ReferencesToAdd.length; ++i) {
                addReferencesRequest.ReferencesToAdd[i] = this.ReferencesToAdd[i].clone();
            }
        }
        return addReferencesRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AddReferencesRequest addReferencesRequest = (AddReferencesRequest)object;
        if (this.RequestHeader == null ? addReferencesRequest.RequestHeader != null : !this.RequestHeader.equals(addReferencesRequest.RequestHeader)) {
            return false;
        }
        return !(this.ReferencesToAdd == null ? addReferencesRequest.ReferencesToAdd != null : !Arrays.equals(this.ReferencesToAdd, addReferencesRequest.ReferencesToAdd));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.ReferencesToAdd == null ? 0 : Arrays.hashCode(this.ReferencesToAdd));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

