/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;

public enum AccessLevel implements Enumeration
{
    CurrentRead(1),
    CurrentWrite(2),
    HistoryRead(4),
    HistoryWrite(8),
    SemanticChange(16);

    public static EnumSet<AccessLevel> NONE;
    public static EnumSet<AccessLevel> READONLY;
    public static EnumSet<AccessLevel> READWRITE;
    public static EnumSet<AccessLevel> WRITEONLY;
    public static EnumSet<AccessLevel> HISTORYREAD;
    public static EnumSet<AccessLevel> HISTORYREADWRITE;
    public static EnumSet<AccessLevel> ALL;
    private final int value;
    private static final Map<Integer, AccessLevel> map;

    private AccessLevel(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static AccessLevel valueOf(int n) {
        return map.get(n);
    }

    public static AccessLevel valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : AccessLevel.valueOf(unsignedInteger.intValue());
    }

    public static AccessLevel[] valueOf(int[] nArray) {
        AccessLevel[] accessLevelArray = new AccessLevel[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            accessLevelArray[i] = AccessLevel.valueOf(nArray[i]);
        }
        return accessLevelArray;
    }

    public static AccessLevel[] valueOf(Integer[] integerArray) {
        AccessLevel[] accessLevelArray = new AccessLevel[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            accessLevelArray[i] = AccessLevel.valueOf(integerArray[i]);
        }
        return accessLevelArray;
    }

    public static AccessLevel[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        AccessLevel[] accessLevelArray = new AccessLevel[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            accessLevelArray[i] = AccessLevel.valueOf(unsignedIntegerArray[i]);
        }
        return accessLevelArray;
    }

    public static UnsignedByte getMask(AccessLevel ... accessLevelArray) {
        byte by = 0;
        for (AccessLevel accessLevel : accessLevelArray) {
            by = (byte)(by | accessLevel.value);
        }
        return UnsignedByte.getFromBits(by);
    }

    public static UnsignedByte getMask(Collection<AccessLevel> collection) {
        byte by = 0;
        for (AccessLevel accessLevel : collection) {
            by = (byte)(by | accessLevel.value);
        }
        return UnsignedByte.getFromBits(by);
    }

    public static EnumSet<AccessLevel> getSet(int n) {
        ArrayList<AccessLevel> arrayList = new ArrayList<AccessLevel>();
        for (AccessLevel accessLevel : AccessLevel.values()) {
            if ((n & accessLevel.value) != accessLevel.value) continue;
            arrayList.add(accessLevel);
        }
        if (arrayList.isEmpty()) {
            return NONE;
        }
        return EnumSet.copyOf(arrayList);
    }

    public static EnumSet<AccessLevel> getSet(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            return NONE;
        }
        return AccessLevel.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<AccessLevel> getSet(UnsignedShort unsignedShort) {
        if (unsignedShort == null) {
            return NONE;
        }
        return AccessLevel.getSet(unsignedShort.intValue());
    }

    public static EnumSet<AccessLevel> getSet(UnsignedByte unsignedByte) {
        if (unsignedByte == null) {
            return NONE;
        }
        return AccessLevel.getSet(unsignedByte.intValue());
    }

    static {
        NONE = EnumSet.noneOf(AccessLevel.class);
        READONLY = EnumSet.of(CurrentRead);
        READWRITE = EnumSet.of(CurrentRead, CurrentWrite);
        WRITEONLY = EnumSet.of(CurrentWrite);
        HISTORYREAD = EnumSet.of(HistoryRead);
        HISTORYREADWRITE = EnumSet.of(HistoryRead, HistoryWrite);
        ALL = EnumSet.allOf(AccessLevel.class);
        map = new HashMap<Integer, AccessLevel>();
        for (AccessLevel accessLevel : AccessLevel.values()) {
            map.put(accessLevel.value, accessLevel);
        }
    }
}

