/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import java.util.Arrays;
import org.opcfoundation.ua.utils.BijectionMap;

public class UriTable {
    BijectionMap<Integer, String> indexUriMap = new BijectionMap();

    public synchronized String[] toArray() {
        int n = 0;
        for (Integer n2 : this.indexUriMap.getLeftSet()) {
            if (n2 <= n) continue;
            n = n2;
        }
        String[] stringArray = new String[++n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.indexUriMap.getRight(i);
        }
        return stringArray;
    }

    public String getUri(int n) {
        return this.indexUriMap.getRight(n);
    }

    public int getIndex(String string) {
        Integer n = this.indexUriMap.getLeft(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int add(String string) {
        return this.add(-1, string);
    }

    private int nextIndex() {
        int n = -1;
        for (int n2 : this.indexUriMap.getLeftSet()) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    public void remove(int n) {
        this.indexUriMap.removeWithLeft(n);
    }

    public void remove(String string) {
        this.indexUriMap.removeWithRight(string);
    }

    public synchronized int add(int n, String string) {
        int n2 = this.getIndex(string);
        if (n2 >= 0) {
            return n2;
        }
        if (n < 0) {
            n = this.nextIndex();
        } else if (this.getUri(n) != null) {
            throw new IllegalArgumentException("namespaceTable already has namespaceIndex " + n);
        }
        this.indexUriMap.map(n, string);
        return n;
    }

    public void addAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(i, stringArray[i]);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public int size() {
        return this.indexUriMap.size();
    }
}

