/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Arrays;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;

public class ServiceResult {
    private StatusCode code;
    private String symbolicId;
    private String namespaceUri;
    private LocalizedText localizedText;
    private String additionalInfo;
    private ServiceResult innerResult;

    public static ServiceResult toServiceResult(Throwable throwable) {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_UnexpectedError));
        serviceResult.setSymbolicId(serviceResult.toString());
        serviceResult.setLocalizedText(new LocalizedText(throwable.getMessage(), ""));
        serviceResult.setAdditionalInfo(Arrays.toString(throwable.getStackTrace()));
        return serviceResult;
    }

    public ServiceResult() {
        this.initialize();
    }

    public ServiceResult(StatusCode statusCode) {
        this.initialize(statusCode);
    }

    public ServiceResult(StatusCode statusCode, Throwable throwable) {
        this.initialize(statusCode, throwable);
    }

    public ServiceResult(UnsignedInteger unsignedInteger, Throwable throwable) {
        this.initialize(new StatusCode(unsignedInteger), throwable);
    }

    public ServiceResult(UnsignedInteger unsignedInteger) {
        this.initialize(new StatusCode(unsignedInteger));
    }

    public boolean isBad() {
        if (this.code == null) {
            return false;
        }
        return this.code.isBad();
    }

    private String lookUpSymbolicId(StatusCode statusCode) {
        return statusCode.getName();
    }

    public static String buildExceptionTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return throwable.getStackTrace().toString();
    }

    private void initialize() {
        this.initialize(StatusCode.GOOD, null);
    }

    private void initialize(StatusCode statusCode) {
        this.code = statusCode;
        this.symbolicId = this.lookUpSymbolicId(statusCode);
        this.localizedText = null;
        this.additionalInfo = null;
    }

    private void initialize(StatusCode statusCode, Throwable throwable) {
        assert (throwable != null);
        this.code = statusCode;
        this.symbolicId = this.lookUpSymbolicId(this.code);
        this.localizedText = new LocalizedText(throwable.getMessage(), Locale.ENGLISH);
        this.additionalInfo = ServiceResult.buildExceptionTrace(throwable);
    }

    public boolean isGood() {
        if (this.code == null) {
            return false;
        }
        return this.code.isGood();
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = string;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public void setCode(StatusCode statusCode) {
        this.code = statusCode;
    }

    public ServiceResult getInnerResult() {
        return this.innerResult;
    }

    public void setInnerResult(ServiceResult serviceResult) {
        this.innerResult = serviceResult;
    }

    public LocalizedText getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalizedText(LocalizedText localizedText) {
        this.localizedText = localizedText;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String string) {
        this.namespaceUri = string;
    }

    public String getSymbolicId() {
        return this.symbolicId;
    }

    public void setSymbolicId(String string) {
        this.symbolicId = string;
    }
}

