/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.CryptoUtil;

public final class NodeId
implements Comparable<NodeId> {
    public static final NodeId ZERO = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_NUMERIC = new NodeId(0, UnsignedInteger.getFromBits(0));
    public static final NodeId NULL_STRING = NodeId.get(IdType.String, 0, "");
    public static final NodeId NULL_GUID = NodeId.get(IdType.Guid, 0, new UUID(0L, 0L));
    public static final NodeId NULL_OPAQUE = NodeId.get(IdType.Opaque, 0, new byte[0]);
    public static final NodeId NULL = NULL_NUMERIC;
    public static final NodeId ID = Identifiers.NodeId;
    IdType type;
    final int namespaceIndex;
    final Object value;
    static final Pattern INT_INT = Pattern.compile("ns=(\\d*);i=(\\d*)");
    static final Pattern NONE_INT = Pattern.compile("i=(\\d*)");
    static final Pattern INT_STRING = Pattern.compile("ns=(\\d*);s=(.*)");
    static final Pattern NONE_STRING = Pattern.compile("s=(.*)");
    static final Pattern INT_GUID = Pattern.compile("ns=(\\d*);g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern NONE_GUID = Pattern.compile("g=([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})");
    static final Pattern INT_OPAQUE = Pattern.compile("ns=(\\d*);b=([0-9a-zA-Z\\+/=]*)");
    static final Pattern NONE_OPAQUE = Pattern.compile("b=([0-9a-zA-Z\\+/=]*)");

    public static NodeId get(IdType idType, int n, Object object) {
        if (idType == IdType.Guid) {
            return new NodeId(n, (UUID)object);
        }
        if (idType == IdType.Numeric) {
            return new NodeId(n, (UnsignedInteger)object);
        }
        if (idType == IdType.Opaque) {
            return new NodeId(n, (byte[])object);
        }
        if (idType == IdType.String) {
            return new NodeId(n, (String)object);
        }
        throw new IllegalArgumentException("bad type");
    }

    public NodeId(int n, int n2) {
        this(n, UnsignedInteger.getFromBits(n2));
    }

    public NodeId(int n, UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        this.value = unsignedInteger;
        this.namespaceIndex = n;
        this.type = IdType.Numeric;
    }

    public NodeId(int n, String string) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (string != null && string.length() > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 characters");
        }
        this.type = IdType.String;
        this.value = string;
        this.namespaceIndex = n;
    }

    public NodeId(int n, UUID uUID) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (uUID == null) {
            throw new IllegalArgumentException("Numeric NodeId cannot be null");
        }
        this.type = IdType.Guid;
        this.value = uUID;
        this.namespaceIndex = n;
    }

    public NodeId(int n, byte[] byArray) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        if (byArray != null && byArray.length > 4096) {
            throw new IllegalArgumentException("The length is restricted to 4096 bytes");
        }
        this.type = IdType.Opaque;
        this.value = byArray;
        this.namespaceIndex = n;
    }

    public boolean isNullNodeId() {
        if (this.value == null) {
            return true;
        }
        if (this.namespaceIndex != 0) {
            return false;
        }
        switch (this.type) {
            case Numeric: {
                return ((UnsignedInteger)this.value).intValue() == 0;
            }
            case String: {
                return ((String)this.value).length() == 0;
            }
            case Guid: {
                return this.value.equals(NodeId.NULL_GUID.value);
            }
            case Opaque: {
                return Arrays.equals((byte[])this.value, (byte[])NodeId.NULL_OPAQUE.value);
            }
        }
        return false;
    }

    public static boolean isNull(NodeId nodeId) {
        return nodeId == null || nodeId.isNullNodeId();
    }

    public IdType getIdType() {
        return this.type;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int n = 13 * this.namespaceIndex;
        if (this.value != null) {
            n = this.value instanceof byte[] ? (n += 3 * Arrays.hashCode((byte[])this.value)) : (n += 3 * this.value.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return NodeId.isNull(this);
        }
        if (object instanceof NodeId) {
            NodeId nodeId = (NodeId)object;
            if (NodeId.isNull(this) || NodeId.isNull(nodeId)) {
                return NodeId.isNull(this) == NodeId.isNull(nodeId);
            }
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.type != this.type) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            if (nodeId.type == IdType.Opaque) {
                return Arrays.equals((byte[])this.value, (byte[])nodeId.value);
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (expandedNodeId.namespaceUri != null && expandedNodeId.namespaceUri != NamespaceTable.OPCUA_NAMESPACE || !expandedNodeId.isLocal()) {
                return false;
            }
            if (this.namespaceIndex != expandedNodeId.namespaceIndex || this.type != expandedNodeId.type) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            if (this.type == IdType.Opaque) {
                return Arrays.equals((byte[])expandedNodeId.value, (byte[])this.value);
            }
            return this.value.equals(expandedNodeId.value);
        }
        return false;
    }

    @Override
    public int compareTo(NodeId nodeId) {
        int n = this.namespaceIndex - nodeId.namespaceIndex;
        if (n == 0) {
            n = this.type.getValue() - nodeId.type.getValue();
        }
        if (n == 0) {
            switch (this.type) {
                case Numeric: {
                    n = ((UnsignedInteger)this.value).compareTo((UnsignedInteger)nodeId.value);
                    break;
                }
                case String: {
                    n = ((String)this.value).compareTo((String)nodeId.value);
                    break;
                }
                case Guid: {
                    n = ((UUID)this.value).compareTo((UUID)nodeId.value);
                    break;
                }
                case Opaque: {
                    n = Arrays.equals((byte[])this.value, (byte[])nodeId.value) ? 0 : 1;
                }
            }
        }
        return n;
    }

    public String toString() {
        String string;
        String string2 = string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "";
        if (this.type == IdType.Numeric) {
            return string + "i=" + this.value;
        }
        if (this.type == IdType.String) {
            return string + "s=" + this.value;
        }
        if (this.type == IdType.Guid) {
            return string + "g=" + this.value;
        }
        if (this.type == IdType.Opaque) {
            if (this.value == null) {
                return string + "b=null";
            }
            return string + "b=" + new String(CryptoUtil.base64Encode((byte[])this.value));
        }
        return "error";
    }

    @Deprecated
    public static NodeId decode(String string) throws IllegalArgumentException {
        return NodeId.parseNodeId(string);
    }

    public static NodeId parseNodeId(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null arg");
        }
        Matcher matcher = NONE_STRING.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return new NodeId(0, string2);
        }
        matcher = NONE_INT.matcher(string);
        if (matcher.matches()) {
            Integer n = Integer.valueOf(matcher.group(1));
            return new NodeId(0, n);
        }
        matcher = NONE_GUID.matcher(string);
        if (matcher.matches()) {
            UUID uUID = UUID.fromString(matcher.group(1));
            return new NodeId(0, uUID);
        }
        matcher = NONE_OPAQUE.matcher(string);
        if (matcher.matches()) {
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(1));
            return new NodeId(0, byArray);
        }
        matcher = INT_INT.matcher(string);
        if (matcher.matches()) {
            Integer n = Integer.valueOf(matcher.group(1));
            Integer n2 = Integer.valueOf(matcher.group(2));
            return new NodeId((int)n, n2);
        }
        matcher = INT_STRING.matcher(string);
        if (matcher.matches()) {
            Integer n = Integer.valueOf(matcher.group(1));
            String string3 = matcher.group(2);
            return new NodeId((int)n, string3);
        }
        matcher = INT_GUID.matcher(string);
        if (matcher.matches()) {
            Integer n = Integer.valueOf(matcher.group(1));
            UUID uUID = UUID.fromString(matcher.group(2));
            return new NodeId((int)n, uUID);
        }
        matcher = INT_OPAQUE.matcher(string);
        if (matcher.matches()) {
            Integer n = Integer.valueOf(matcher.group(1));
            byte[] byArray = CryptoUtil.base64Decode(matcher.group(2));
            return new NodeId((int)n, byArray);
        }
        throw new IllegalArgumentException("Invalid string representation of a nodeId: " + string);
    }

    public static NodeId randomGUID(int n) {
        return new NodeId(n, UUID.randomUUID());
    }

    public static boolean equals(NodeId nodeId, NodeId nodeId2) {
        if (nodeId == null && nodeId2 != null) {
            return false;
        }
        return nodeId.equals(nodeId2);
    }
}

