/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.ObjectUtils;

public final class ExpandedNodeId
implements Comparable<ExpandedNodeId> {
    public static final ExpandedNodeId NULL_NUMERIC = new ExpandedNodeId(NodeId.NULL_NUMERIC);
    public static final ExpandedNodeId NULL_STRING = new ExpandedNodeId(NodeId.NULL_STRING);
    public static final ExpandedNodeId NULL_GUID = new ExpandedNodeId(NodeId.NULL_GUID);
    public static final ExpandedNodeId NULL_OPAQUE = new ExpandedNodeId(NodeId.NULL_OPAQUE);
    public static final ExpandedNodeId NULL = NULL_NUMERIC;
    public static final NodeId ID = Identifiers.ExpandedNodeId;
    IdType type;
    int namespaceIndex;
    UnsignedInteger serverIndex;
    String namespaceUri;
    Object value;

    public ExpandedNodeId(UnsignedInteger unsignedInteger, int n, Object object) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        UnsignedInteger unsignedInteger2 = this.serverIndex = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.getFromBits((Integer)object);
        }
        this.value = object;
        this.namespaceIndex = n;
        if (!(n != 0 || ObjectUtils.equals(object, NodeId.NULL_NUMERIC.getValue()) || ObjectUtils.equals(object, NodeId.NULL_STRING.getValue()) || ObjectUtils.equals(object, NodeId.NULL_GUID.getValue()) || ObjectUtils.equals(object, NodeId.NULL_OPAQUE.getValue()))) {
            this.namespaceUri = NamespaceTable.OPCUA_NAMESPACE;
        }
        if (object == null) {
            this.type = IdType.String;
        } else if (object instanceof UnsignedInteger) {
            this.type = IdType.Numeric;
        } else if (object instanceof String) {
            this.type = IdType.String;
        } else if (object instanceof UUID) {
            this.type = IdType.Guid;
        } else if (object instanceof byte[]) {
            this.type = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, String string, Object object) {
        if (string == null) {
            throw new NullPointerException("namespaceUri; value=" + object);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("namespaceUri not defined");
        }
        UnsignedInteger unsignedInteger2 = this.serverIndex = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.valueOf(((Integer)object).intValue());
        }
        this.value = object;
        this.namespaceUri = string;
        if (object == null) {
            this.type = IdType.String;
        } else if (object instanceof UnsignedInteger) {
            this.type = IdType.Numeric;
        } else if (object instanceof String) {
            this.type = IdType.String;
        } else if (object instanceof UUID) {
            this.type = IdType.Guid;
        } else if (object instanceof byte[]) {
            this.type = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, NodeId nodeId) {
        this(unsignedInteger, nodeId.getNamespaceIndex(), nodeId.getValue());
    }

    public ExpandedNodeId(NodeId nodeId) {
        this(null, nodeId.getNamespaceIndex(), nodeId.getValue());
    }

    public ExpandedNodeId(String string, Object object) {
        this(UnsignedInteger.ZERO, string, object);
    }

    public boolean isNullNodeId() {
        return this.equals(NULL);
    }

    public boolean isAbsolute() {
        return this.namespaceUri != null && !this.namespaceUri.isEmpty() || !this.isLocal();
    }

    public IdType getIdType() {
        return this.type;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public UnsignedInteger getServerIndex() {
        return this.serverIndex;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public int hashCode() {
        int n = 0;
        if (this.value != null) {
            n += this.value instanceof byte[] ? 3 * Arrays.hashCode((byte[])this.value) : 3 * this.value.hashCode();
        }
        if (this.serverIndex != null) {
            n += this.serverIndex.hashCode() * 17;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this.equals(NULL);
        }
        if (object instanceof NodeId) {
            if (this.namespaceUri != null && this.namespaceUri != NamespaceTable.OPCUA_NAMESPACE || !this.isLocal()) {
                return false;
            }
            NodeId nodeId = (NodeId)object;
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.type != this.type) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            if (nodeId.type == IdType.Opaque) {
                return Arrays.equals((byte[])this.value, (byte[])nodeId.value);
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (this.namespaceUri != null) {
                if (expandedNodeId.namespaceUri == null || !expandedNodeId.namespaceUri.equals(this.namespaceUri)) {
                    return false;
                }
            } else {
                if (expandedNodeId.namespaceUri != null) {
                    return false;
                }
                if (expandedNodeId.namespaceIndex != this.namespaceIndex) {
                    return false;
                }
            }
            if (!this.isLocal() ? expandedNodeId.isLocal() || !expandedNodeId.serverIndex.equals(this.serverIndex) : !expandedNodeId.isLocal()) {
                return false;
            }
            if (expandedNodeId.type != this.type) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            if (expandedNodeId.type == IdType.Opaque) {
                return Arrays.equals((byte[])this.value, (byte[])expandedNodeId.value);
            }
            if (expandedNodeId.value != null) {
                return expandedNodeId.value.equals(this.value);
            }
            return this.value == null;
        }
        return false;
    }

    @Override
    public int compareTo(ExpandedNodeId expandedNodeId) {
        int n = this.namespaceUri != null && expandedNodeId.namespaceUri != null ? this.namespaceUri.compareTo(expandedNodeId.namespaceUri) : this.namespaceIndex - expandedNodeId.namespaceIndex;
        if (n == 0) {
            n = this.type.getValue() - expandedNodeId.type.getValue();
        }
        if (n == 0) {
            switch (this.type) {
                case Numeric: {
                    n = ((UnsignedInteger)this.value).compareTo((UnsignedInteger)expandedNodeId.value);
                    break;
                }
                case String: {
                    n = ((String)this.value).compareTo((String)expandedNodeId.value);
                    break;
                }
                case Guid: {
                    n = ((UUID)this.value).compareTo((UUID)expandedNodeId.value);
                    break;
                }
                case Opaque: {
                    n = Arrays.equals((byte[])this.value, (byte[])expandedNodeId.value) ? 0 : 1;
                }
            }
        }
        return n;
    }

    public String toString() {
        try {
            String string;
            String string2;
            String string3 = string2 = !this.isLocal() ? "srv=" + this.serverIndex + ";" : "";
            String string4 = this.namespaceUri != null ? "nsu=" + URLEncoder.encode(this.namespaceUri, "ISO8859-1") + ";" : (string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "");
            if (this.type == IdType.Numeric) {
                return string2 + string + "i=" + this.value;
            }
            if (this.type == IdType.String) {
                return string2 + string + "s=" + this.value;
            }
            if (this.type == IdType.Guid) {
                return string2 + string + "g=" + this.value;
            }
            if (this.type == IdType.Opaque) {
                if (this.value == null) {
                    return string2 + string + "b=null";
                }
                return string2 + string + "b=" + new String(CryptoUtil.base64Encode((byte[])this.value));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "error";
    }

    private static void assertExpandedNodeIdParts(String string, String[] stringArray, int n) throws ClassCastException {
        if (stringArray.length < n) {
            ExpandedNodeId.throwExpandedNodeIdCastException(string);
        }
    }

    private static void throwExpandedNodeIdCastException(String string) throws ClassCastException {
        throw new ClassCastException("String is not a valid ExpandedNodeId: " + string);
    }

    public static ExpandedNodeId parseExpandedNodeId(String string) {
        String[] stringArray = string.split(";");
        ExpandedNodeId.assertExpandedNodeIdParts(string, stringArray, 1);
        int n = 0;
        int n2 = 0;
        NodeId nodeId = NodeId.parseNodeId(stringArray[stringArray.length - 1]);
        ExpandedNodeId expandedNodeId = null;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            ExpandedNodeId.assertExpandedNodeIdParts(string, stringArray2, 2);
            if (stringArray2[0].equalsIgnoreCase("svr")) {
                n = Integer.parseInt(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equalsIgnoreCase("ns")) {
                n2 = Integer.parseInt(stringArray2[1]);
                expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n), n2, nodeId.getValue());
                continue;
            }
            if (stringArray2[0].equalsIgnoreCase("nsu")) {
                String string2 = stringArray2[1];
                expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n), string2, nodeId.getValue());
                continue;
            }
            ExpandedNodeId.throwExpandedNodeIdCastException(string);
        }
        return expandedNodeId;
    }

    public static boolean isNull(ExpandedNodeId expandedNodeId) {
        return expandedNodeId == null || expandedNodeId.isNullNodeId();
    }

    public boolean isLocal() {
        return this.serverIndex == null || this.serverIndex.getValue() == 0L;
    }
}

