/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.security.PrivateKey;
import org.opcfoundation.ua.application.Client;
import org.opcfoundation.ua.application.Session;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ActivateSessionRequest;
import org.opcfoundation.ua.core.ActivateSessionResponse;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.ChannelService;
import org.opcfoundation.ua.transport.RequestChannel;
import org.opcfoundation.ua.transport.ResultListener;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionChannel
extends ChannelService
implements RequestChannel {
    static Logger LOGGER = LoggerFactory.getLogger(SessionChannel.class);
    Client client;
    Session session;
    SecureChannel channel;

    public SessionChannel(Client client, Session session, SecureChannel secureChannel) {
        this.session = session;
        this.client = client;
        this.channel = secureChannel;
        this.setRequestChannel(this);
    }

    public ActivateSessionResponse activate() throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createAnonymousIdentityToken(this.session.getEndpoint());
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(String string, String string2) throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createUserNameIdentityToken(this.session.getEndpoint(), this.session.getServerNonce(), string, string2);
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(byte[] byArray) throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createIssuedIdentityToken(this.session.getEndpoint(), this.session.getServerNonce(), byArray);
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(UserIdentityToken userIdentityToken, SignatureData signatureData) throws ServiceResultException {
        Object object;
        Object object2;
        Structure structure;
        if (this.channel == null || userIdentityToken == null) {
            throw new IllegalArgumentException("null arg");
        }
        String string = userIdentityToken.getPolicyId();
        if (string != null && (structure = this.session.getEndpoint().findUserTokenPolicy(string)) == null) {
            throw new ServiceResultException("UserIdentityPolicy \"" + string + "\" is not supported by the given endpoint");
        }
        structure = null;
        if (!MessageSecurityMode.None.equals(this.channel.getMessageSecurityMode())) {
            object2 = this.channel.getSecurityPolicy();
            object = this.session.getClientPrivateKey().getPrivateKey();
            SecurityAlgorithm securityAlgorithm = ((SecurityPolicy)object2).getAsymmetricSignatureAlgorithm();
            byte[] byArray = this.session.getServerCertificate().getEncoded();
            if (this.session.getServerNonce() != null) {
                byArray = ByteBufferUtils.concatenate(byArray, this.session.getServerNonce());
            }
            structure = new SignatureData(securityAlgorithm.getUri(), CryptoUtil.getCryptoProvider().signAsymm((PrivateKey)object, securityAlgorithm, byArray));
        }
        object2 = new ActivateSessionRequest();
        ((ActivateSessionRequest)object2).setLocaleIds(this.client.getApplication().getLocaleIds());
        ((ActivateSessionRequest)object2).setClientSoftwareCertificates(this.client.getApplication().getSoftwareCertificates());
        ((ActivateSessionRequest)object2).setClientSignature((SignatureData)structure);
        ((ActivateSessionRequest)object2).setUserIdentityToken(ExtensionObject.binaryEncode(userIdentityToken, this.client.getEncoderContext()));
        ((ActivateSessionRequest)object2).setUserTokenSignature(signatureData);
        object = this.ActivateSession((ActivateSessionRequest)object2);
        this.session.serverNonce = ((ActivateSessionResponse)object).getServerNonce();
        return object;
    }

    public Session getSession() {
        return this.session;
    }

    public SecureChannel getSecureChannel() {
        return this.channel;
    }

    public void close() throws ServiceFaultException, ServiceResultException {
        this.CloseSession(null, true);
        this.closeSecureChannel();
    }

    public void closeUnsafe() {
        try {
            this.close();
        }
        catch (ServiceResultException serviceResultException) {
            LOGGER.error("Failed to close session channel", (Throwable)serviceResultException);
        }
    }

    public void closeSecureChannel() {
        this.channel.close();
    }

    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        AsyncResult<ServiceResponse> asyncResult = this.CloseSessionAsync(null, true);
        asyncResult.setListener(new ResultListener<ServiceResponse>(){

            @Override
            public void onCompleted(ServiceResponse serviceResponse) {
                AsyncResult<SecureChannel> asyncResult = SessionChannel.this.channel.closeAsync();
                asyncResultImpl.setSource(asyncResult);
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResult<SecureChannel> asyncResult = SessionChannel.this.channel.closeAsync();
                asyncResultImpl.setSource(asyncResult);
            }
        });
        return asyncResultImpl;
    }

    public void dispose() {
        this.channel.close();
        this.channel.dispose();
        this.channel = null;
        this.session = null;
    }

    @Override
    public IEncodeable serviceRequest(ServiceRequest serviceRequest) throws ServiceResultException {
        ServiceRequest serviceRequest2 = serviceRequest;
        RequestHeader requestHeader = serviceRequest2.getRequestHeader();
        if (requestHeader == null) {
            requestHeader = new RequestHeader();
            serviceRequest2.setRequestHeader(requestHeader);
        }
        requestHeader.setAuthenticationToken(this.session.getAuthenticationToken());
        requestHeader.setTimestamp(new DateTime());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("serviceRequest: Request={} SecureChannelId={}", (Object)serviceRequest.getClass().getSimpleName(), (Object)this.channel.getSecureChannelId());
        }
        return this.channel.serviceRequest(serviceRequest2);
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest) {
        RequestHeader requestHeader = serviceRequest.getRequestHeader();
        if (requestHeader == null) {
            requestHeader = new RequestHeader();
            serviceRequest.setRequestHeader(requestHeader);
        }
        requestHeader.setAuthenticationToken(this.session.getAuthenticationToken());
        requestHeader.setTimestamp(new DateTime());
        return this.channel.serviceRequestAsync(serviceRequest);
    }
}

