package astri.tcs.TCSHardwareDeviceImpl;

import alma.ACS.PropertyDesc;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.MonitorErr.DeviceAlreadyRegisteredEx;
import alma.MonitorErr.DeviceNotRegisteredEx;
import alma.MonitorErr.RegisteringDeviceProblemEx;
import alma.MonitorErr.StartMonitoringProblemEx;
import alma.MonitorErr.StopMonitoringProblemEx;
import alma.TMCDB.MonitorCollector;
import alma.TMCDB.MonitorCollectorHelper;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;
import astri.tcs.TCSHardwareDeviceOperations;
import astri.tcs.TCSControlDeviceImpl.TCSControlDeviceImpl;
import astri.tcs.TCSHardwareDevicePackage.tcshwState;

public class TCSHardwareDeviceImpl extends TCSControlDeviceImpl implements
		TCSHardwareDeviceOperations {
	private static ContainerServices container;
	private static String deviceName;
	private String serialNumber = "43";
	protected boolean monitoring = false;
	protected String  TelescopeLoc_m;
	MonitorCollector  monitorCollector_m = null;
	tcshwState deviceState = tcshwState.UNDEF;
	private String monitorCollectorComponentName = "MONITOR_COLLECTOR_TEST";
	
	
	protected void hwStartAction(){
		
	}
    protected  void hwConfigureAction(){
		
	}
    protected void hwInitializeAction() {
		
	}
    protected void hwOperationalAction() {
		
	}
    protected void hwStopAction() {
		
	}

    /// These two are defined here for the cases where they are disabled.
    protected  void hwDiagnosticAction() {};
    protected  void hwSimulationAction() {};
	
	protected TCSHardwareDeviceImpl() {
		super();
		// TODO Auto-generated constructor stub
		deviceState=tcshwState.UNDEF;
	}

	public TCSHardwareDeviceImpl(ContainerServices container2,
			String deviceName2) {
		// TODO Auto-generated constructor stub
		deviceState=tcshwState.UNDEF;
	}


	public void initialize() throws ComponentLifecycleException, AcsJContainerServicesEx{
		
		super.initialize(container);   
	    tcshwStart();
	       
	}

	public void cleanUp() throws AcsJComponentCleanUpEx{
			tcshwStop();
		
			super.cleanUp();
		
	}
	
	
	@Override
	public tcshwState getHwState() {
		// TODO Auto-generated method stub
		return deviceState;
	}

	@Override
	public String getSerialNumber() {
		// TODO Auto-generated method stub
		return serialNumber;
	}
	
	public void  setSerialNumber(String sn){
		if (sn !=null){
			serialNumber=sn;
		}
	}

	public void setMonitoringCollectorName(String mc){
		if (mc !=null){
			monitorCollectorComponentName=mc;
		}
	}
	
	private MonitorCollector getCollector() throws AcsJContainerServicesEx {
		String monitorCollectorName = monitorCollectorComponentName ; 
		ContainerServices mycont = getComponentContainerServices();
		
		org.omg.CORBA.Object objMonitor = mycont.getComponent(monitorCollectorName);
		return MonitorCollectorHelper.narrow(objMonitor);
	}

	public void registerWithCollector() throws AcsJContainerServicesEx {
		String cmpName=this.name();
		PropertyDesc[] props = this.descriptor().properties;
		m_logger.info("Component "+cmpName+" Number of properties: "+ props.length);
		//int i=0;
		//for (PropertyDesc p : props) {
		//	System.out.println((i++)+" "+p.property_ref.characteristic_component_name());
		//	System.out.println("   "+p.property_ref._get_interface_def());
		//}
		
		if (monitorCollector_m == null) {
			monitorCollector_m = getCollector();
		}
		
		try {
			monitorCollector_m.registerNonCollocatedMonitoredDevice(cmpName, serialNumber);
		} catch (RegisteringDeviceProblemEx e) {
			// TODO Auto-generated catch block
			monitorCollector_m=null;
			m_logger.severe("Problems encounterd registering component:"+cmpName);
			e.printStackTrace();
		} catch (DeviceAlreadyRegisteredEx e) {
			// TODO Auto-generated catch block
			m_logger.info(cmpName+" already registered");
			e.printStackTrace();
		}
	}
	
	public void deregisterWithCollector() throws AcsJContainerServicesEx{
		String cmpName=this.name();
		
		if (monitorCollector_m == null) {
			monitorCollector_m = getCollector();
		}
		
		try {
			monitorCollector_m.deregisterMonitoredDevice(cmpName);
			monitoring=false;
		} catch (DeviceNotRegisteredEx e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	@Override
	public boolean isMonitoring() {
		// TODO Auto-generated method stub
		return monitoring;
	}

	@Override
	public void monitoringOff() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		if (monitorCollector_m == null){
			String msg = "Component "+cmpName +" is not registered with a MONITOR_COLLECTOR component";
			m_logger.info(msg);
		}else{
			try {
				monitorCollector_m.stopMonitoring(cmpName);
				monitoring=false;
				m_logger.info("STOPPED monitoring of component:"+cmpName);
			} catch (StopMonitoringProblemEx e) {
				// TODO Auto-generated catch block
				m_logger.severe("Problems encounterd stopping component:"+cmpName);
				e.printStackTrace();
			}
		
		}
	}

	@Override
	public void monitoringOn() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		if (monitorCollector_m == null) {
			String msg = "Component "+cmpName +" is not registered with its MONITOR_COLLECTOR component";
			m_logger.info(msg);
			try {
				
				registerWithCollector();
			        if (monitorCollector_m != null){
					monitoring=true;
					msg = "Component "+cmpName
		               		 + " registered succesfully with its MONITOR_COLLECTOR";
					m_logger.info(msg);
				}else{
					monitoring=false;
					msg = "Component "+cmpName
		               		 + " NOT REGISTERED with its MONITOR_COLLECTOR";
					m_logger.info(msg); 
				}

			} catch (AcsJContainerServicesEx e) {
			// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		try {
			monitorCollector_m.startMonitoring(cmpName);
			monitoring=true;
		} catch (StartMonitoringProblemEx e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}		
	}

	@Override
	public void tcshwConfigure() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		m_logger.info("CONFIGURED component: "+cmpName);
		deviceState=tcshwState.CONFIGURE;
	}

	@Override
	public void tcshwInitialize() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		m_logger.info("INITIALIZED component: "+cmpName);
		deviceState=tcshwState.INIZIALIZE;
		
	}

	@Override
	public void tcshwOperational() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		m_logger.info("OPERATIVE component: "+cmpName);
		deviceState=tcshwState.OPERATIONAL;
	}

	@Override
	public void tcshwStart() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		deviceState=tcshwState.START;
		m_logger.info("STARTED component: "+cmpName);
	}

	@Override
	public void tcshwStop() {
		// TODO Auto-generated method stub
		String cmpName=this.name();
		deviceState=tcshwState.STOP;
		m_logger.info("STOPPED component: "+cmpName);
	}

}
