package astri.tcs.TCSControlDeviceImpl;

import java.util.HashMap;
import java.util.Map;

import alma.ACS.impl.CharacteristicComponentImpl;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.container.ContainerServices;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;
import astri.tcs.TCSControlDevice;
import astri.tcs.TCSControlDeviceHelper;
import astri.tcs.TCSControlDeviceOperations;
import astri.tcs.TCSDeviceConfig;


public class TCSControlDeviceImpl extends CharacteristicComponentImpl implements
		TCSControlDeviceOperations {
	private ContainerServices container;
	private String deviceName;
	public static Map<TCSDeviceConfig,TCSControlDevice> m_deviceList= new HashMap<TCSDeviceConfig,TCSControlDevice>();
	
	public TCSControlDeviceImpl() {
		super();
	
	}

	public TCSControlDeviceImpl(ContainerServices container2, String deviceName2) {
		// TODO Auto-generated constructor stub
	}

	
	public void setContainer(String Name, ContainerServices cs) {
		
		this.container=cs;
		this.deviceName=Name;
	}
	
	public void cleanUp() throws AcsJComponentCleanUpEx{
		
		this.releaseSubdevices();
		super.cleanUp();

		
	}
	
	private  TCSControlDevice getSubdeviceReference(String Name){
		TCSControlDevice comp = null;
		if (Name == null || Name.length()==0){
			return null;
		}
		try{
			container = getComponentContainerServices();
	        
	        comp=TCSControlDeviceHelper.narrow(container.getComponent(Name));
	       
		} catch (AcsJContainerServicesEx e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return comp;
		
	}
	
	
	@Override
	public void clearSubdeviceError(String arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getDeviceReferenceName() {
		// TODO Auto-generated method stub
		return deviceName;
	}

	@Override
	public String getErrorMessage() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String getSubdeviceName(String arg0) {
		// TODO Auto-generated method stub
		return deviceName;
	}

	@Override
	public boolean inErrorState() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void releaseSubdevices() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setSubdeviceError(String arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void createSubdevices(TCSDeviceConfig comp, String parent) {
		// TODO Auto-generated method stub
		TCSControlDevice tmp = null;
		try{
		tmp=getSubdeviceReference(comp.Name);
		if (tmp!=null){
			m_deviceList.put(comp,tmp);
		}
		}catch (Exception e){
			e.printStackTrace();
			setSubdeviceError(comp.Name);
		}
	
	}
}
