/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.LinkedList;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferFactory;

public class ByteQueue {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[0];
    ByteBufferFactory factory = ByteBufferFactory.LITTLE_ENDIAN_HEAP_BYTEBUFFER_FACTORY;
    int chunkSize = 4096;
    long bytesRead;
    long bytesWritten;
    long writeLimit = Long.MAX_VALUE;
    ByteOrder order = ByteOrder.nativeOrder();
    LinkedList<ByteBuffer> list = new LinkedList();
    ByteBuffer writeChunk;
    ByteBuffer readChunk;

    public ByteQueue() {
    }

    public ByteQueue(int n) {
        this.chunkSize = n;
    }

    public void put(byte[] byArray) throws BufferOverflowException {
        this.put(byArray, 0, byArray.length);
    }

    public void put(byte[] byArray, int n, int n2) throws BufferOverflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getWriteChunk();
            int n3 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.put(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void put(byte by) {
        this.getWriteChunk().put(by);
    }

    public void put(ByteBuffer byteBuffer) {
        this.put(byteBuffer, byteBuffer.remaining());
    }

    public void put(ByteBuffer byteBuffer, int n) {
        while (n > 0) {
            ByteBuffer byteBuffer2 = this.getWriteChunk();
            int n2 = Math.min(byteBuffer2.remaining(), n);
            ByteQueue.copy(byteBuffer, byteBuffer2, n2);
            n -= n2;
        }
    }

    public void offer(ByteBuffer byteBuffer) throws BufferOverflowException {
        if (this.getWriteableBytesRemaining() < byteBuffer.remaining()) {
            throw new BufferOverflowException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        this.flushWriteChunk();
        this.bytesWritten += (long)byteBuffer.remaining();
        this.list.addLast(byteBuffer);
    }

    public void get(byte[] byArray) throws BufferUnderflowException {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            if (byteBuffer == null) {
                throw new BufferUnderflowException();
            }
            int n3 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    public void get(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.get(byteBuffer, byteBuffer.remaining());
    }

    public void get(ByteBuffer byteBuffer, int n) throws BufferUnderflowException {
        if (n > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if ((long)n > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n > 0) {
            ByteBuffer byteBuffer2 = this.getReadChunk();
            int n2 = Math.min(byteBuffer2.remaining(), n);
            ByteQueue.copy(byteBuffer2, byteBuffer, n2);
            n -= n2;
        }
    }

    public ByteBuffer get(int n) throws BufferUnderflowException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n == 0) {
            return EMPTY_BUFFER;
        }
        int n2 = this.countChunks(n);
        if (n2 == 1) {
            ByteBuffer byteBuffer = this.getChunks(n)[0];
            return byteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(this.order);
        this.get(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void getAvailable(ByteBuffer byteBuffer) {
        this.get(byteBuffer, Math.min(byteBuffer.remaining(), (int)this.remaining()));
    }

    public ByteBuffer[] getChunks(int n) throws BufferUnderflowException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n == 0) {
            return EMPTY_BUFFERS;
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.countChunks(n)];
        int n2 = 0;
        ByteBuffer byteBuffer = this.getReadChunk();
        while (byteBuffer != null && n > 0) {
            if (n < byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = this.readChunk.slice();
                byteBuffer2.order(this.order);
                this.readChunk.position(this.readChunk.position() + n);
                byteBuffer2.limit(n);
                byteBufferArray[n2++] = byteBuffer2;
                n = 0;
            } else {
                this.bytesRead += (long)(byteBuffer.remaining() + byteBuffer.position());
                n -= byteBuffer.remaining();
                this.readChunk = null;
                byteBufferArray[n2++] = byteBuffer.slice().order(this.order);
            }
            byteBuffer = this.getReadChunk();
        }
        return byteBufferArray;
    }

    public void peek(byte[] byArray) throws BufferUnderflowException {
        this.peek(byArray, 0, byArray.length);
    }

    public void peek(byte[] byArray, int n, int n2) throws BufferUnderflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.readChunk != null) {
            int n3 = Math.min(this.readChunk.remaining(), n2);
            this.readChunk.mark();
            this.readChunk.get(byArray, n, n3);
            this.readChunk.reset();
            n += n3;
            if ((n2 -= n3) == 0) {
                return;
            }
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n2 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                int n4 = Math.min(byteBuffer.remaining(), n2);
                byteBuffer.mark();
                byteBuffer.get(byArray, n, n4);
                byteBuffer.reset();
                n += n4;
                n2 -= n4;
            }
        }
        if (this.writeChunk != null) {
            ByteBuffer byteBuffer = (ByteBuffer)this.writeChunk.duplicate().flip();
            byteBuffer.order(this.order);
            int n5 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.get(byArray, n, n5);
            n += n5;
            n2 -= n5;
        }
    }

    public void peek(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.peekAvailable(byteBuffer);
    }

    public ByteBuffer peek(int n) throws BufferUnderflowException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuffer[] byteBufferArray = this.peekChunks(n);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(this.order);
        this.peek(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void peekAvailable(ByteBuffer byteBuffer) {
        Object object;
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.readChunk != null) {
            this.readChunk.mark();
            ByteQueue.copyRemaining(this.readChunk, byteBuffer);
            this.readChunk.reset();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (!this.list.isEmpty()) {
            object = this.list.iterator();
            while (byteBuffer.hasRemaining() && object.hasNext()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)object.next();
                byteBuffer2.mark();
                ByteQueue.copyRemaining(byteBuffer2, byteBuffer);
                byteBuffer2.reset();
            }
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.writeChunk != null) {
            object = (ByteBuffer)this.writeChunk.duplicate().flip();
            ((ByteBuffer)object).order(this.order);
            ByteQueue.copyRemaining((ByteBuffer)object, byteBuffer);
        }
    }

    public ByteBuffer[] peekChunks(int n) throws BufferUnderflowException {
        Object object;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n == 0) {
            return EMPTY_BUFFERS;
        }
        int n2 = n;
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.countChunks(n)];
        int n3 = 0;
        if (this.readChunk != null) {
            object = this.readChunk.slice();
            assert (((Buffer)object).position() == 0);
            ((ByteBuffer)object).order(this.order);
            if (n2 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n2);
                n2 = 0;
            } else {
                n2 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n3++] = object;
        }
        if (!this.list.isEmpty() && n2 > 0) {
            object = this.list.iterator();
            while (n2 > 0 && object.hasNext()) {
                ByteBuffer byteBuffer = ((ByteBuffer)object.next()).slice();
                assert (byteBuffer.position() == 0);
                byteBuffer.order(this.order);
                if (n2 < byteBuffer.remaining()) {
                    byteBuffer.limit(n2);
                    n2 = 0;
                } else {
                    n2 -= byteBuffer.remaining();
                }
                byteBufferArray[n3++] = byteBuffer;
            }
        }
        if (n2 > 0 && this.writeChunk != null) {
            object = (ByteBuffer)this.writeChunk.duplicate().flip();
            assert (((Buffer)object).position() == 0);
            ((ByteBuffer)object).order(this.order);
            if (n2 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n2);
                n2 = 0;
            } else {
                n2 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n3++] = object;
        }
        assert (n2 == 0);
        return byteBufferArray;
    }

    private int countChunks(int n) {
        int n2 = 0;
        if (n == 0) {
            return n2;
        }
        if (this.readChunk != null) {
            n -= Math.min(this.readChunk.remaining(), n);
            ++n2;
        }
        if (n == 0) {
            return n2;
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                n -= Math.min(byteBuffer.remaining(), n);
                ++n2;
            }
        }
        if (n == 0) {
            return n2;
        }
        if (this.writeChunk != null) {
            ++n2;
        }
        return n2;
    }

    public long remaining() {
        return this.getBytesWritten() - this.getBytesRead();
    }

    public boolean isEmpty() {
        return this.remaining() == 0L;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public long getBytesRead() {
        return this.bytesRead + (long)(this.readChunk == null ? 0 : this.readChunk.position());
    }

    public long getBytesWritten() {
        return this.bytesWritten + (long)(this.writeChunk == null ? 0 : this.writeChunk.position());
    }

    public void omitAll() {
        if (this.writeChunk != null) {
            this.bytesWritten += (long)this.writeChunk.position();
        }
        this.bytesRead = this.bytesWritten;
        this.list.clear();
        this.writeChunk = null;
        this.readChunk = null;
    }

    public void clear() {
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
        this.list.clear();
        this.writeChunk = null;
        this.readChunk = null;
    }

    public void skip(int n) throws BufferOverflowException {
        if ((long)n > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (n > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            int n2 = Math.min(byteBuffer.remaining(), n);
            byteBuffer.position(byteBuffer.position() + n2);
            n -= n2;
        }
    }

    public ByteBuffer getReadChunk() {
        if (this.readChunk != null && !this.readChunk.hasRemaining()) {
            this.bytesRead += (long)this.readChunk.position();
            this.readChunk = null;
        }
        if (this.readChunk != null) {
            return this.readChunk;
        }
        if (this.list.isEmpty()) {
            this.flushWriteChunk();
        }
        if (!this.list.isEmpty()) {
            this.readChunk = this.list.removeFirst();
            this.bytesRead -= (long)this.readChunk.position();
            return this.readChunk;
        }
        return null;
    }

    public ByteBuffer getWriteChunk() {
        if (this.writeChunk != null && !this.writeChunk.hasRemaining()) {
            this.flushWriteChunk();
        }
        if (this.writeChunk != null) {
            return this.writeChunk;
        }
        int n = Math.min(this.getWriteableBytesRemaining(), this.chunkSize);
        if (n == 0) {
            throw new BufferOverflowException();
        }
        this.writeChunk = this.factory.allocate(n);
        this.writeChunk.order(this.order);
        return this.writeChunk;
    }

    private void flushWriteChunk() {
        if (this.writeChunk == null) {
            return;
        }
        if (this.writeChunk.position() == 0) {
            return;
        }
        if (!this.writeChunk.hasRemaining()) {
            this.bytesWritten += (long)this.writeChunk.position();
            this.writeChunk.flip();
            this.list.addLast(this.writeChunk);
            this.writeChunk = null;
            return;
        }
        this.bytesWritten += (long)this.writeChunk.position();
        ByteBuffer byteBuffer = this.writeChunk;
        this.writeChunk = this.writeChunk.slice();
        this.writeChunk.order(this.order);
        byteBuffer.flip();
        this.list.addLast(byteBuffer);
    }

    public int getWriteableBytesRemaining() {
        return (int)Math.min(Integer.MAX_VALUE, this.writeLimit - this.getBytesWritten());
    }

    public ByteOrder order() {
        return this.order;
    }

    public void order(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    private static void copyRemaining(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        ByteQueue.copy(byteBuffer, byteBuffer2, n);
    }

    private static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n);
        byteBuffer2.limit(byteBuffer2.position() + n);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n2);
        byteBuffer2.limit(n3);
    }

    public void setByteBufferFactory(ByteBufferFactory byteBufferFactory) {
        this.factory = byteBufferFactory;
    }

    public ByteBufferFactory getByteBufferFactory() {
        return this.factory;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("chunk size < 1");
        }
        this.chunkSize = n;
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(long l) {
        this.writeLimit = l;
    }

    public String toString() {
        return "ByteQueue (read=" + this.getBytesRead() + ", written=" + this.getBytesWritten() + ")";
    }
}

