/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.ByteQueue;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryReadable;

public class ByteBufferArrayReadable
implements IBinaryReadable {
    ByteQueue q;

    public ByteBufferArrayReadable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.q = new ByteQueue();
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.q.offer(byteBuffer);
        }
    }

    public ByteBufferArrayReadable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.q = byteQueue;
    }

    @Override
    public ByteOrder order() {
        return this.q.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.q.order(byteOrder);
    }

    @Override
    public byte get() throws IOException {
        return this.q.getReadChunk().get();
    }

    @Override
    public void get(byte[] byArray, int n, int n2) throws IOException {
        this.q.get(byArray, n, n2);
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.q.get(byArray);
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        this.q.get(byteBuffer);
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n) throws IOException {
        this.q.get(byteBuffer, n);
    }

    @Override
    public double getDouble() throws IOException {
        if (this.q.getReadChunk().remaining() >= 8) {
            return this.q.getReadChunk().getDouble();
        }
        return this.q.get(8).getDouble();
    }

    @Override
    public float getFloat() throws IOException {
        if (this.q.getReadChunk().remaining() >= 4) {
            return this.q.getReadChunk().getFloat();
        }
        return this.q.get(4).getFloat();
    }

    @Override
    public int getInt() throws IOException {
        if (this.q.getReadChunk().remaining() >= 4) {
            return this.q.getReadChunk().getInt();
        }
        return this.q.get(4).getInt();
    }

    @Override
    public long getLong() throws IOException {
        if (this.q.getReadChunk().remaining() >= 8) {
            return this.q.getReadChunk().getLong();
        }
        return this.q.get(8).getLong();
    }

    @Override
    public short getShort() throws IOException {
        if (this.q.getReadChunk().remaining() >= 2) {
            return this.q.getReadChunk().getShort();
        }
        return this.q.get(2).getShort();
    }

    @Override
    public long limit() {
        return this.q.getBytesWritten();
    }

    @Override
    public long position() {
        return this.q.getBytesRead();
    }
}

