/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableServerSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableServerSocketChannel.class);
    AtomicReference<ServerSocketChannel> channel = new AtomicReference<Object>(null);
    AsyncSelector selector;
    Executor executor;
    volatile ServerSocketAcceptable acceptableListener;
    boolean acceptableHndPending = false;
    boolean ownsSelector = false;
    Runnable acceptRun;
    AsyncSelector.SelectListener selectListener = new AsyncSelector.SelectListener(){

        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n, int n2) {
            Runnable runnable;
            if ((n & 0x10) != 0 && (runnable = ListenableServerSocketChannel.this.acceptRun) != null) {
                if (ListenableServerSocketChannel.this.executor == null) {
                    ListenableServerSocketChannel.this.acceptableHndPending = true;
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    ListenableServerSocketChannel.this.acceptableHndPending = true;
                    ListenableServerSocketChannel.this.executor.execute(runnable);
                }
            }
            asyncSelector.interestOps(selectableChannel, ListenableServerSocketChannel.this.getInterestOps());
        }
    };

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        if (serverSocketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        if (asyncSelector == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.executor = executor;
        this.channel.set(serverSocketChannel);
        this.selector = asyncSelector;
        asyncSelector.register(serverSocketChannel, 0, this.selectListener);
    }

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        this(serverSocketChannel, executor, new AsyncSelector(Selector.open()));
        this.ownsSelector = true;
    }

    public void setAcceptableListener(final ServerSocketAcceptable serverSocketAcceptable) {
        this.acceptableListener = serverSocketAcceptable;
        this.acceptRun = serverSocketAcceptable != null ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    serverSocketAcceptable.onConnectionAcceptable(ListenableServerSocketChannel.this);
                }
                finally {
                    ListenableServerSocketChannel.this.acceptableHndPending = false;
                    ListenableServerSocketChannel.this.updateInterestOps();
                }
            }
        } : null;
        this.updateInterestOps();
    }

    public ServerSocketAcceptable getAcceptableListener() {
        return this.acceptableListener;
    }

    void updateInterestOps() {
        ServerSocketChannel serverSocketChannel = this.channel.get();
        if (serverSocketChannel != null) {
            this.selector.interestOps(serverSocketChannel, this.getInterestOps());
        }
    }

    int getInterestOps() {
        ServerSocketChannel serverSocketChannel = this.channel.get();
        if (serverSocketChannel == null || !serverSocketChannel.isOpen() || !serverSocketChannel.isRegistered()) {
            return 0;
        }
        int n = 0;
        if (this.acceptableListener != null && !this.acceptableHndPending) {
            n |= 0x10;
        }
        return n;
    }

    public ServerSocketChannel getChannel() {
        return this.channel.get();
    }

    public AsyncSelector getSelectorThread() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ServerSocketChannel serverSocketChannel = this.channel.getAndSet(null);
        if (serverSocketChannel == null) {
            return;
        }
        this.selector.unregister(serverSocketChannel);
        if (this.ownsSelector) {
            this.selector.close();
        }
        serverSocketChannel.close();
        logger.debug("closed");
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        ServerSocketChannel serverSocketChannel = this.getChannel();
        serverSocketChannel.socket().bind(socketAddress, n);
        this.selector.register(serverSocketChannel, 16, this.selectListener);
    }

    public static interface ServerSocketAcceptable {
        public void onConnectionAcceptable(ListenableServerSocketChannel var1);
    }
}

