/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSelector;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSocketImpl;
import org.opcfoundation.ua.utils.asyncsocket.ListenableServerSocketChannel;
import org.opcfoundation.ua.utils.asyncsocket.ServerSocketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncServerSocket
extends AbstractState<ServerSocketState, IOException> {
    ServerSocketChannel c;
    ListenableServerSocketChannel ls;
    Executor executor;
    CopyOnWriteArrayList<ConnectListener> listeners = new CopyOnWriteArrayList();
    ListenableServerSocketChannel.ServerSocketAcceptable listener = new ListenableServerSocketChannel.ServerSocketAcceptable(){

        @Override
        public void onConnectionAcceptable(ListenableServerSocketChannel listenableServerSocketChannel) {
            try {
                SocketChannel socketChannel = listenableServerSocketChannel.getChannel().accept();
                socketChannel.configureBlocking(false);
                AsyncSocketImpl asyncSocketImpl = new AsyncSocketImpl(socketChannel, AsyncServerSocket.this.executor, AsyncServerSocket.this.ls.getSelectorThread());
                AsyncServerSocket.this.fireConnected(asyncSocketImpl);
            }
            catch (ClosedChannelException closedChannelException) {
                AsyncServerSocket.this.setState((Object)ServerSocketState.Closed);
            }
            catch (IOException iOException) {
                AsyncServerSocket.this.setError(iOException);
            }
        }
    };
    static Logger logger = LoggerFactory.getLogger(AsyncServerSocket.class);

    public AsyncServerSocket(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        super(ServerSocketState.Ready, ServerSocketState.Error);
        this.ls = new ListenableServerSocketChannel(serverSocketChannel, executor, asyncSelector);
        this.executor = executor;
        this.c = serverSocketChannel;
    }

    public AsyncServerSocket(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        super(ServerSocketState.Ready, ServerSocketState.Error);
        this.ls = new ListenableServerSocketChannel(serverSocketChannel, executor);
        this.executor = executor;
        this.c = serverSocketChannel;
    }

    public AsyncServerSocket bind(SocketAddress socketAddress, int n) throws IOException {
        ServerSocketState serverSocketState = (ServerSocketState)((Object)this.getState());
        if (serverSocketState == ServerSocketState.Closed) {
            throw new ClosedChannelException();
        }
        this.assertNoError();
        this.ls.bind(socketAddress, n);
        this.setState(ServerSocketState.Bound);
        this.ls.setAcceptableListener(this.listener);
        return this;
    }

    public AsyncServerSocket close() {
        logger.debug("close");
        try {
            this.ls.close();
            this.setState(ServerSocketState.Closed);
        }
        catch (IOException iOException) {
            logger.error("close", (Throwable)iOException);
            this.setError(iOException);
        }
        return this;
    }

    public ServerSocketChannel channel() {
        return this.c;
    }

    public ServerSocket socket() {
        return this.c.socket();
    }

    public void addListener(ConnectListener connectListener) {
        this.listeners.add(connectListener);
    }

    public void removeListener(ConnectListener connectListener) {
        this.listeners.remove(connectListener);
    }

    void fireConnected(final AsyncSocketImpl asyncSocketImpl) {
        for (final ConnectListener connectListener : this.listeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    connectListener.onConnected(AsyncServerSocket.this, asyncSocketImpl);
                }
            });
        }
    }

    public String toString() {
        if (!this.c.socket().isBound()) {
            return "unbound";
        }
        return this.c.socket().getLocalSocketAddress().toString();
    }

    public static interface ConnectListener {
        public void onConnected(AsyncServerSocket var1, AsyncSocketImpl var2);
    }
}

