/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;

public class TimerUtil {
    public static WeakReference<Timer> timer;

    public static synchronized Timer getTimer() {
        Timer timer;
        Timer timer2 = timer = TimerUtil.timer != null ? (Timer)TimerUtil.timer.get() : null;
        if (timer == null) {
            timer = new Timer("UA Timer", true);
            TimerUtil.timer = new WeakReference<Timer>(timer);
        }
        return timer;
    }

    public static TimerTask schedule(final Runnable runnable, final Executor executor, long l) {
        if (runnable == null || executor == null) {
            throw new IllegalArgumentException("null arg");
        }
        long l2 = l - System.currentTimeMillis();
        if (l2 < 1L) {
            l2 = 1L;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                executor.execute(runnable);
            }

            @Override
            public boolean cancel() {
                boolean bl = super.cancel();
                TimerUtil.purge();
                return bl;
            }
        };
        TimerUtil.getTimer().schedule(timerTask, l2);
        return timerTask;
    }

    protected static void purge() {
        Timer timer;
        Timer timer2 = timer = TimerUtil.timer != null ? (Timer)TimerUtil.timer.get() : null;
        if (timer != null) {
            timer.purge();
        }
    }

    public static TimerTask schedule(Timer timer, final Runnable runnable, final Executor executor, long l) {
        if (runnable == null || executor == null) {
            throw new IllegalArgumentException("null arg");
        }
        long l2 = l - System.currentTimeMillis();
        if (l2 < 1L) {
            l2 = 1L;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                executor.execute(runnable);
            }

            @Override
            public boolean cancel() {
                boolean bl = super.cancel();
                TimerUtil.purge();
                return bl;
            }
        };
        timer.schedule(timerTask, l2);
        return timerTask;
    }
}

