/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;

public class NumericRange {
    private int[] begin;
    private int[] end;

    public NumericRange() {
        this.init(1);
    }

    private void init(int[] ... nArray) {
        int n = nArray.length;
        this.init(n);
        for (int i = 0; i < n; ++i) {
            if (nArray[i].length > 0) {
                this.begin[i] = nArray[i][0];
            }
            if (nArray[i].length <= 1) continue;
            this.end[i] = nArray[i][1];
        }
    }

    public NumericRange(int n) {
        this.init(new int[][]{{n, -1}});
    }

    public NumericRange(int n, int n2) {
        this.init(new int[][]{{n, n2}});
    }

    public NumericRange(int[] ... nArray) {
        this.init(nArray);
    }

    public boolean ensureValid(Object object) {
        int n = -1;
        try {
            Collection collection = (Collection)object;
            n = collection.size();
        }
        catch (Exception exception) {
            try {
                n = Array.getLength(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.ensureValid(n);
    }

    public boolean ensureValid(int n) {
        if (n == -1) {
            return false;
        }
        if (this.begin[0] > n || this.end[0] >= n) {
            return false;
        }
        if (this.begin[0] < 0) {
            this.begin[0] = 0;
        }
        if (this.end[0] < 0) {
            this.end[0] = n;
        }
        return true;
    }

    public int getBegin() {
        return this.getBegin(0);
    }

    public int getEnd() {
        return this.getEnd(0);
    }

    public int getBegin(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Dim");
        }
        if (n >= this.getDimensions()) {
            return -1;
        }
        return this.begin[n];
    }

    public int getEnd(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Dim");
        }
        if (n >= this.getDimensions()) {
            return -1;
        }
        return this.end[n] < 0 ? this.begin[n] : this.end[n];
    }

    public void setBegin(int n) {
        this.setBegin(1, n);
    }

    public void setEnd(int n) {
        this.setEnd(1, n);
    }

    public void setBegin(int n, int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("Begin");
        }
        if (n < 0 || n >= this.getDimensions()) {
            throw new IllegalArgumentException("Dim");
        }
        int n3 = this.end[n];
        if (n3 != -1 && (n2 > n3 || n2 < 0)) {
            throw new IllegalArgumentException("Begin < End");
        }
        this.begin[n] = n2;
    }

    public void setEnd(int n, int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("End");
        }
        if (n < 0 || n >= this.getDimensions()) {
            throw new IllegalArgumentException("Dim");
        }
        int n3 = this.getBegin(n);
        if (n2 != -1 && (n3 > n2 || n3 < 0)) {
            throw new IllegalArgumentException("Begin > End");
        }
        this.end[n] = n2;
    }

    public static NumericRange getEmpty() {
        return new NumericRange();
    }

    public static NumericRange parse(String string) throws ServiceResultException {
        if (string == null || string.length() == 0) {
            return NumericRange.getEmpty();
        }
        NumericRange numericRange = new NumericRange();
        String[] stringArray = string.split(",");
        numericRange.setDimensions(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = stringArray[i];
                String[] stringArray2 = string2.split(":");
                if (stringArray2.length > 1) {
                    numericRange.setBegin(i, Integer.parseInt(stringArray2[0]));
                    numericRange.setEnd(i, Integer.parseInt(stringArray2[1]));
                    if (numericRange.getBegin(i) != numericRange.getEnd(i)) continue;
                    throw new IllegalArgumentException("Begin = End");
                }
                numericRange.setBegin(i, Integer.parseInt(stringArray2[0]));
                continue;
            }
            catch (Exception exception) {
                throw new ServiceResultException(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception, "Cannot parse numeric range: " + string + ".");
            }
        }
        return numericRange;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            if (this.getBegin(i) < 0) continue;
            if (this.getEnd(i) <= this.getBegin(i)) {
                stringBuilder.append(String.valueOf(this.getBegin(i)));
                continue;
            }
            stringBuilder.append(String.format("%d:%d", this.getBegin(i), this.getEnd(i)));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NumericRange)) {
            return false;
        }
        NumericRange numericRange = (NumericRange)object;
        if (numericRange.getDimensions() != this.getDimensions()) {
            return false;
        }
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (numericRange.getBegin(i) != this.getBegin(i)) {
                return false;
            }
            if (numericRange.getEnd(i) == this.getEnd(i)) continue;
            return false;
        }
        return true;
    }

    public void setDimensions(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than 0. Was:" + n);
        }
        if (n != this.getDimensions()) {
            this.init(n);
        }
    }

    private void init(int n) {
        this.begin = new int[n];
        this.end = new int[n];
        for (int i = 0; i < n; ++i) {
            this.begin[i] = -1;
            this.end[i] = -1;
        }
    }

    public int getDimensions() {
        return this.begin.length;
    }

    public boolean isEmpty() {
        return this.getDimensions() == 1 && this.getBegin() == -1;
    }

    public boolean isEmpty(int n) {
        return this.getBegin(n) == -1;
    }

    public static boolean isNullOrEmpty(NumericRange numericRange) {
        return numericRange == null || numericRange.isEmpty();
    }

    public static String toString(NumericRange numericRange) {
        return numericRange == null ? null : numericRange.toString();
    }
}

