/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.transport.security.BcCertificateProvider;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateProvider;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.transport.security.ScCertificateProvider;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SunJceCertificateProvider;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final int NAME_URI = 6;
    private static Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static int keySize = 2048;
    private static String certificateSignatureAlgorithm = "SHA256WithRSA";
    private static CertificateProvider certificateProvider;

    public static SignatureData sign(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        try {
            return CryptoUtil.signAsymm(privateKey, securityAlgorithm, byArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SignatureException(serviceResultException);
        }
    }

    public static boolean verify(X509Certificate x509Certificate, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            return CryptoUtil.verifyAsymm(x509Certificate, securityAlgorithm, byArray, byArray2);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SignatureException(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readX509Certificate(URL uRL) throws IOException, CertificateException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        finally {
            inputStream.close();
        }
    }

    public static X509Certificate readX509Certificate(File file) throws IOException, CertificateException {
        return CertificateUtils.readX509Certificate(file.toURI().toURL());
    }

    public static byte[] createThumbprint(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
    }

    public static X509Certificate decodeX509Certificate(byte[] byArray) throws CertificateException {
        try {
            if (byArray == null) {
                throw new IllegalArgumentException("null arg");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            return x509Certificate;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey loadFromKeyStore(URL uRL, String string) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        logger.debug("loadFromKeyStore: keystoreUrl={}", (Object)uRL);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            Object object;
            KeyStore keyStore;
            if (logger.isDebugEnabled()) {
                logger.debug("getproviders={}", (Object)Arrays.toString(Security.getProviders()));
            }
            try {
                try {
                    keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    keyStore = KeyStore.getInstance("PKCS12", CryptoUtil.getSecurityProviderName(KeyStore.class));
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            logger.debug("loadFromKeyStore: keyStore Provider={}", (Object)keyStore.getProvider());
            keyStore.load(inputStream, string == null ? null : string.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            Key key = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                key = keyStore.getKey((String)object, string == null ? null : string.toCharArray());
            }
            object = (RSAPrivateKey)key;
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyPairToProtectedStore(KeyPair keyPair, String string, String string2, String string3, String string4) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance("JKS");
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                keyStore.load(fileInputStream, string3.toCharArray());
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            keyStore.load(null, null);
        }
        Certificate[] certificateArray = new Certificate[]{keyPair.certificate.getCertificate()};
        keyStore.setKeyEntry(string2, keyPair.privateKey.getPrivateKey(), string4.toCharArray(), certificateArray);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            keyStore.store(fileOutputStream, string3.toCharArray());
        }
        finally {
            fileOutputStream.close();
        }
        return true;
    }

    public static KeyPair loadKeyPairFromProtectedStore(String string, String string2, String string3, String string4) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance("JKS");
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        keyStore.load(fileInputStream, string3.toCharArray());
        fileInputStream.close();
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyStore.getKey(string2, string4.toCharArray());
        return new KeyPair(new Cert(x509Certificate), new PrivKey(rSAPrivateKey));
    }

    public static KeyPair renewApplicationInstanceCertificate(String string, String string2, String string3, int n, KeyPair keyPair, KeyPair keyPair2, String ... stringArray) throws IOException, IllegalStateException, GeneralSecurityException {
        if (string3 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        PublicKey publicKey = keyPair.getCertificate().getCertificate().getPublicKey();
        RSAPrivateKey rSAPrivateKey = keyPair.getPrivateKey().getPrivateKey();
        X509Certificate x509Certificate = CertificateUtils.generateCertificate("CN=" + string + (string2 == null ? "" : ", O=" + string2), n, string3, new java.security.KeyPair(publicKey, rSAPrivateKey), keyPair2, stringArray);
        Cert cert = new Cert(x509Certificate);
        PrivKey privKey = new PrivKey(rSAPrivateKey);
        return new KeyPair(cert, privKey);
    }

    public static KeyPair renewApplicationInstanceCertificate(String string, String string2, String string3, int n, KeyPair keyPair, String ... stringArray) throws IOException, IllegalStateException, GeneralSecurityException {
        return CertificateUtils.renewApplicationInstanceCertificate(string, string2, string3, n, keyPair, null, stringArray);
    }

    public static void setCertificateSignatureAlgorithm(String string) {
        certificateSignatureAlgorithm = string;
    }

    public static int getKeySize() {
        return keySize;
    }

    public static void setKeySize(int n) {
        if (n < 1024 || n % 1024 != 0 || n > 4096) {
            throw new IllegalArgumentException("KeySize must be 1024, 2048, 3072 or 4096");
        }
        keySize = n;
    }

    private static X509Certificate generateCertificate(String string, int n, String string2, java.security.KeyPair keyPair, KeyPair keyPair2, String ... stringArray) throws GeneralSecurityException, IOException {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return CertificateUtils.generateCertificate(string, n, string2, publicKey, privateKey, keyPair2, stringArray);
    }

    private static X509Certificate generateCertificate(String string, int n, String string2, PublicKey publicKey, PrivateKey privateKey, KeyPair keyPair, String ... stringArray) throws IOException, GeneralSecurityException {
        Date date = CertificateUtils.getCertificateStartDate();
        Date date2 = CertificateUtils.getCertificateEndDate(n);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        return CertificateUtils.getCertificateProvider().generateCertificate(string, publicKey, privateKey, keyPair, date, date2, bigInteger, string2, stringArray);
    }

    public static CertificateProvider getCertificateProvider() {
        if (certificateProvider == null) {
            if ("SC".equals(CryptoUtil.getSecurityProviderName())) {
                certificateProvider = new ScCertificateProvider();
            } else if ("BC".equals(CryptoUtil.getSecurityProviderName())) {
                certificateProvider = new BcCertificateProvider();
            } else if ("SunJCE".equals(CryptoUtil.getSecurityProviderName())) {
                certificateProvider = new SunJceCertificateProvider();
            } else {
                throw new RuntimeException("NO CRYPTO PROVIDER AVAILABLE!");
            }
        }
        return certificateProvider;
    }

    public static void setCertificateProvider(CertificateProvider certificateProvider) {
        CertificateUtils.certificateProvider = certificateProvider;
    }

    private static Date getCertificateStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    private static Date getCertificateEndDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, n);
        return calendar.getTime();
    }

    public static KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n, String ... stringArray) throws IOException, GeneralSecurityException {
        return CertificateUtils.createApplicationInstanceCertificate(string, string2, string3, n, null, stringArray);
    }

    public static KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n, KeyPair keyPair, String ... stringArray) throws IOException, GeneralSecurityException {
        if (string3 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        java.security.KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        String string4 = "CN=" + string + (string2 == null ? "" : ", O=" + string2) + (stringArray == null || stringArray.length == 0 ? "" : ", DC=" + stringArray[0]);
        X509Certificate x509Certificate = CertificateUtils.generateCertificate(string4, n, string3, keyPair2, keyPair, stringArray);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static KeyPair toKeyPair(X509Certificate x509Certificate, PrivateKey privateKey) throws CertificateEncodingException {
        Cert cert = new Cert(x509Certificate);
        PrivKey privKey = new PrivKey((RSAPrivateKey)privateKey);
        return new KeyPair(cert, privKey);
    }

    private static java.security.KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(CertificateUtils.getKeySize());
        java.security.KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static KeyPair createIssuerCertificate(String string, int n, KeyPair keyPair) throws GeneralSecurityException, IOException {
        java.security.KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        Date date = CertificateUtils.getCertificateStartDate();
        Date date2 = CertificateUtils.getCertificateEndDate(n);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        if (!string.startsWith("CN=")) {
            string = "CN=" + string;
        }
        X509Certificate x509Certificate = CertificateUtils.getCertificateProvider().generateIssuerCert(keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, string, bigInteger, date, date2);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static KeyPair createHttpsCertificate(String string, String string2, int n, KeyPair keyPair) throws IOException, GeneralSecurityException {
        if (string2 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        java.security.KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        X509Certificate x509Certificate = CertificateUtils.generateCertificate("CN=" + string, n, string2, keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, new String[0]);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static void writeToPem(X509Certificate x509Certificate, File file) throws IOException {
        CertificateUtils.getCertificateProvider().writeToPem(x509Certificate, file, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToProtectedStore(PrivateKey privateKey, Certificate certificate, File file, String string, String string2, String string3, String string4) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        keyStore = string4.equals("PKCS12") ? KeyStore.getInstance(string4, CryptoUtil.getSecurityProviderName(KeyStore.class)) : KeyStore.getInstance(string4);
        keyStore.load(null, null);
        Certificate[] certificateArray = new Certificate[]{certificate};
        if (string2 != null) {
            keyStore.setKeyEntry(string, privateKey, string2.toCharArray(), certificateArray);
        } else {
            keyStore.setKeyEntry(string, privateKey, null, certificateArray);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            keyStore.store(fileOutputStream, string3 == null ? null : string3.toCharArray());
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static String getCertificateSignatureAlgorithm() {
        return certificateSignatureAlgorithm;
    }

    protected static Collection<List<?>> getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        return CertificateUtils.getCertificateProvider().getSubjectAlternativeNames(x509Certificate);
    }

    public static String getApplicationUriOfCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        Collection<List<?>> collection = CertificateUtils.getSubjectAlternativeNames(x509Certificate);
        if (collection != null) {
            for (List<?> list : collection) {
                int n = (Integer)list.get(0);
                String string = (String)list.get(1);
                if (n != 6) continue;
                return string;
            }
        }
        return "";
    }

    public static String getApplicationUriOfCertificate(Cert cert) throws CertificateParsingException {
        return CertificateUtils.getApplicationUriOfCertificate(cert.getCertificate());
    }
}

