/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import org.opcfoundation.ua.transport.tcp.impl.ChunkSymmDecryptVerifier;
import org.opcfoundation.ua.transport.tcp.impl.ChunkUtils;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.transport.tcp.impl.TcpConnectionParameters;
import org.opcfoundation.ua.transport.tcp.nio.InputMessage;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.bytebuffer.IncubationBuffer;
import org.opcfoundation.ua.utils.bytebuffer.InputStreamReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureInputMessageBuilder
implements InputMessage {
    MessageListener listener;
    Object token;
    TcpConnectionParameters ctx;
    EncoderContext encoderCtx;
    Exception error;
    IncubationBuffer chunkSink;
    Runnable messageDecoderRun;
    int chunksAdded;
    IEncodeable msg;
    Integer requestId;
    Integer securityChannelId;
    int messageType;
    boolean acceptsChunks = true;
    boolean done;
    String securityPolicyUri;
    byte[] senderCertificate;
    byte[] receiverCertificateThumbPrint;
    List<Integer> chunkSequenceNumbers = new ArrayList<Integer>(1);
    AtomicInteger expectedSequenceNumber;
    static Logger log = LoggerFactory.getLogger(SecureInputMessageBuilder.class);

    public SecureInputMessageBuilder(Object object, MessageListener messageListener, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, AtomicInteger atomicInteger) {
        assert (object != null);
        this.listener = messageListener;
        this.token = object;
        this.ctx = tcpConnectionParameters;
        this.encoderCtx = encoderContext;
        this.expectedSequenceNumber = atomicInteger;
        log.debug("SecureInputMessageBuilder: expectedSequenceNumber={}", (Object)atomicInteger);
        this.chunkSink = new IncubationBuffer();
        int n = tcpConnectionParameters.maxRecvMessageSize == 0 ? Integer.MAX_VALUE : tcpConnectionParameters.maxRecvMessageSize;
        InputStreamReadable inputStreamReadable = new InputStreamReadable(this.chunkSink, n);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
        binaryDecoder.setEncoderContext(encoderContext);
        this.messageDecoderRun = new Runnable(){

            @Override
            public void run() {
                try {
                    Object t = binaryDecoder.getMessage();
                    if (!(SecureInputMessageBuilder.this.token instanceof SecurityToken)) {
                        for (int i = 1; i < SecureInputMessageBuilder.this.chunkSequenceNumbers.size(); ++i) {
                            if (SecureInputMessageBuilder.this.chunkSequenceNumbers.get(i) == SecureInputMessageBuilder.this.chunkSequenceNumbers.get(i - 1) - 1) continue;
                            String string = "Sequence numbers of chunks are not consecutive";
                            log.info(string);
                            SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, string));
                            return;
                        }
                    }
                    SecureInputMessageBuilder.this.setMessage((IEncodeable)t);
                }
                catch (Exception exception) {
                    SecureInputMessageBuilder.this.setError(exception);
                }
                catch (StackOverflowError stackOverflowError) {
                    SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
                }
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("token=" + this.token);
        stringBuilder.append(", secureChannelId=" + this.securityChannelId);
        stringBuilder.append(", more=" + this.moreChunksRequired());
        return stringBuilder.toString();
    }

    public synchronized void addChunk(final ByteBuffer byteBuffer) throws ServiceResultException {
        if (!this.acceptsChunks) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Final chunk added to message builder");
        }
        final int n = this.chunksAdded++;
        this.chunkSequenceNumbers.add(null);
        int n2 = ChunkUtils.getMessageType(byteBuffer);
        int n3 = n2 & 0xFFFFFF;
        int n4 = n2 & 0xFF000000;
        if (n4 == 0x46000000) {
            this.acceptsChunks = false;
        }
        final Integer n5 = this.expectedSequenceNumber != null ? Integer.valueOf(this.expectedSequenceNumber.getAndIncrement()) : null;
        log.debug("addChunk: expectedSequenceNumber={}", (Object)n5);
        if (n4 == 0x41000000) {
            this.setMessage(null);
        }
        if (n == 0) {
            this.messageType = n3;
            this.securityChannelId = ChunkUtils.getSecureChannelId(byteBuffer);
        }
        this.chunkSink.incubate(byteBuffer);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SecureInputMessageBuilder.this.hasError()) {
                    return;
                }
                try {
                    log.debug("token: {}", SecureInputMessageBuilder.this.token);
                    if (SecureInputMessageBuilder.this.token instanceof SecurityToken) {
                        new ChunkSymmDecryptVerifier(byteBuffer, (SecurityToken)SecureInputMessageBuilder.this.token).run();
                    } else if (SecureInputMessageBuilder.this.token instanceof SecurityConfiguration) {
                        ChunkAsymmDecryptVerifier chunkAsymmDecryptVerifier = new ChunkAsymmDecryptVerifier(byteBuffer, (SecurityConfiguration)SecureInputMessageBuilder.this.token);
                        chunkAsymmDecryptVerifier.run();
                        SecureInputMessageBuilder.this.securityPolicyUri = chunkAsymmDecryptVerifier.getSecurityPolicyUri();
                        SecureInputMessageBuilder.this.senderCertificate = chunkAsymmDecryptVerifier.getSenderCertificate();
                        SecureInputMessageBuilder.this.receiverCertificateThumbPrint = chunkAsymmDecryptVerifier.getReceiverCertificateThumbprint();
                    }
                    int n6 = byteBuffer.position();
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    byteBuffer.position(n6);
                    int n2 = byteBuffer.position();
                    byteBuffer.position(n2 - 8);
                    int n3 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.chunkSequenceNumbers.set(n, n3);
                    if (n5 != null) {
                        if (n3 > n5) {
                            long l = System.currentTimeMillis();
                            long l2 = 100L;
                            while (n3 > n5 && System.currentTimeMillis() - l < l2) {
                                Thread.sleep(1L);
                            }
                        }
                        if (n5 != n3) {
                            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "chunkSequenceNumber=" + n3 + ", expectedSequenceNumber=" + n5);
                        }
                    }
                    int n4 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.setRequestId(n4);
                    int n52 = ChunkUtils.getSecureChannelId(byteBuffer);
                    if (n52 != SecureInputMessageBuilder.this.securityChannelId) {
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "secureChannelId=" + n52 + ", expected Id");
                    }
                    byteBuffer.position(n2);
                    SecureInputMessageBuilder.this.chunkSink.hatch(byteBuffer);
                }
                catch (Exception exception) {
                    log.info("addChunk: failed", (Throwable)exception);
                    SecureInputMessageBuilder.this.chunkSink.forceClose();
                    SecureInputMessageBuilder.this.setError(exception);
                }
            }
        };
        StackUtils.getNonBlockingWorkExecutor().execute(runnable);
        if (n == 0) {
            StackUtils.getBlockingWorkExecutor().execute(this.messageDecoderRun);
        }
    }

    protected void fireComplete() {
        if (this.listener != null) {
            this.listener.onMessageComplete(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Exception exception) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                log.info("setError[when done]", (Throwable)exception);
                return;
            }
            this.done = true;
            this.error = exception;
            this.chunkSink.forceClose();
        }
        this.fireComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(IEncodeable iEncodeable) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                return;
            }
            this.chunkSink.close();
            this.done = true;
            this.msg = iEncodeable;
        }
        this.fireComplete();
    }

    private synchronized void setRequestId(int n) throws ServiceResultException {
        if (this.requestId != null && this.requestId != n) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        this.requestId = n;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean moreChunksRequired() {
        return this.acceptsChunks;
    }

    public void close() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.chunkSink.forceClose();
    }

    @Override
    public IEncodeable getMessage() {
        return this.msg;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    @Override
    public int getSecureChannelId() {
        return this.securityChannelId;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public byte[] getSenderCertificate() {
        return this.senderCertificate;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.receiverCertificateThumbPrint;
    }

    @Override
    public List<Integer> getSequenceNumbers() {
        return this.chunkSequenceNumbers;
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    protected synchronized boolean hasError() {
        return this.error != null;
    }

    public static interface MessageListener {
        public void onMessageComplete(InputMessage var1);
    }
}

